/*
  Copyright (C) 2016 National Institute For Space Research (INPE) - Brazil.

  This file is part of the WTSS.CXX.

  WTSS.CXX is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 3 as
  published by the Free Software Foundation.

  WTSS.CXX is distributed  "AS-IS" in the hope that it will be useful,
  but WITHOUT ANY WARRANTY OF ANY KIND; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with WTSS.CXX. See COPYING. If not, see <http://www.gnu.org/licenses/lgpl-3.0.html>.
 */

/*!
  \file wtss-cxx/wtss_cxx_version.hpp

  \brief WTSS.CXX version information.

  \author Matheus Cavassan Zaglia
 */

#ifndef __WTSS_CXX_VERSION_HPP__
#define __WTSS_CXX_VERSION_HPP__

//! Major version of WTSS.CXX (or version).
#define WTSS_CXX_VERSION_MAJOR 0

//! Minor version of WTSS.CXX (or revision).
#define WTSS_CXX_VERSION_MINOR 4

//! Patched version of WTSS.CXX (or patch).
#define WTSS_CXX_VERSION_PATCH 0

//! Release status: alpha, beta, rc (release candidate), stable.
#define WTSS_CXX_VERSION_STATUS ""

//! A string description of WTSS.CXX version.
#define WTSS_CXX_VERSION_STRING "0.4.0"

//! WTSS.CXX version.
#define WTSS_CXX_VERSION 0x000100

#endif  // __WTSS_CXX_VERSION_HPP__
