/*
 *  EPSG PCS Codes - GeoTIFF Rev 0.2
 */

/* C database for Geotiff include files.   */
/* the macro ValuePair() must be defined   */
/* by the enclosing include file           */

#ifdef INCLUDE_OLD_CODES
#include old_pcs.inc
#endif /* OLD Codes */

/* Newer PCS */
ValuePair(PCS_Hjorsey_1955_Lambert, 3053)
ValuePair(PCS_ISN93_Lambert_1993, 3057)
ValuePair(PCS_ETRS89_Poland_CS2000_zone_5,2176)
ValuePair(PCS_ETRS89_Poland_CS2000_zone_6,2177)
ValuePair(PCS_ETRS89_Poland_CS2000_zone_7,2177)
ValuePair(PCS_ETRS89_Poland_CS2000_zone_8,2178)
ValuePair(PCS_ETRS89_Poland_CS92,2180)
ValuePair(PCS_GDA94_GEODETIC_FIX, 4283)
/* New PCS */
ValuePair(PCS_GGRS87_Greek_Grid,2100)
ValuePair(PCS_KKJ_Finland_zone_1,2391)
ValuePair(PCS_KKJ_Finland_zone_2,2392)
ValuePair(PCS_KKJ_Finland_zone_3,2393)
ValuePair(PCS_KKJ_Finland_zone_4,2394)
ValuePair(PCS_RT90_2_5_gon_W,2400)
ValuePair(PCS_Lietuvos_Koordinoei_Sistema_1994,2600)
ValuePair(PCS_Estonian_Coordinate_System_of_1992,3300)
ValuePair(PCS_PULKOVO_ROS4270,19926)
ValuePair(PCS_HD72_EOV,23700)
ValuePair(PCS_Dealul_Piscului_1970_Stereo_70,31700)

ValuePair(PCS_Adindan_UTM_zone_37N,	20137)
ValuePair(PCS_Adindan_UTM_zone_38N,	20138)
ValuePair(PCS_AGD66_AMG_zone_48,	20248)
ValuePair(PCS_AGD66_AMG_zone_49,	20249)
ValuePair(PCS_AGD66_AMG_zone_50,	20250)
ValuePair(PCS_AGD66_AMG_zone_51,	20251)
ValuePair(PCS_AGD66_AMG_zone_52,	20252)
ValuePair(PCS_AGD66_AMG_zone_53,	20253)
ValuePair(PCS_AGD66_AMG_zone_54,	20254)
ValuePair(PCS_AGD66_AMG_zone_55,	20255)
ValuePair(PCS_AGD66_AMG_zone_56,	20256)
ValuePair(PCS_AGD66_AMG_zone_57,	20257)
ValuePair(PCS_AGD66_AMG_zone_58,	20258)
ValuePair(PCS_AGD84_AMG_zone_48,	20348)
ValuePair(PCS_AGD84_AMG_zone_49,	20349)
ValuePair(PCS_AGD84_AMG_zone_50,	20350)
ValuePair(PCS_AGD84_AMG_zone_51,	20351)
ValuePair(PCS_AGD84_AMG_zone_52,	20352)
ValuePair(PCS_AGD84_AMG_zone_53,	20353)
ValuePair(PCS_AGD84_AMG_zone_54,	20354)
ValuePair(PCS_AGD84_AMG_zone_55,	20355)
ValuePair(PCS_AGD84_AMG_zone_56,	20356)
ValuePair(PCS_AGD84_AMG_zone_57,	20357)
ValuePair(PCS_AGD84_AMG_zone_58,	20358)
ValuePair(PCS_Ain_el_Abd_UTM_zone_37N,	20437)
ValuePair(PCS_Ain_el_Abd_UTM_zone_38N,	20438)
ValuePair(PCS_Ain_el_Abd_UTM_zone_39N,	20439)
ValuePair(PCS_Ain_el_Abd_Bahrain_Grid,	20499)
ValuePair(PCS_Afgooye_UTM_zone_38N,	20538)
ValuePair(PCS_Afgooye_UTM_zone_39N,	20539)
ValuePair(PCS_Lisbon_Portugese_Grid,	20700)
ValuePair(PCS_Aratu_UTM_zone_22S,	20822)
ValuePair(PCS_Aratu_UTM_zone_23S,	20823)
ValuePair(PCS_Aratu_UTM_zone_24S,	20824)
ValuePair(PCS_Arc_1950_Lo13,	20973)
ValuePair(PCS_Arc_1950_Lo15,	20975)
ValuePair(PCS_Arc_1950_Lo17,	20977)
ValuePair(PCS_Arc_1950_Lo19,	20979)
ValuePair(PCS_Arc_1950_Lo21,	20981)
ValuePair(PCS_Arc_1950_Lo23,	20983)
ValuePair(PCS_Arc_1950_Lo25,	20985)
ValuePair(PCS_Arc_1950_Lo27,	20987)
ValuePair(PCS_Arc_1950_Lo29,	20989)
ValuePair(PCS_Arc_1950_Lo31,	20991)
ValuePair(PCS_Arc_1950_Lo33,	20993)
ValuePair(PCS_Arc_1950_Lo35,	20995)
ValuePair(PCS_Batavia_NEIEZ,	21100)
ValuePair(PCS_Batavia_UTM_zone_48S,	21148)
ValuePair(PCS_Batavia_UTM_zone_49S,	21149)
ValuePair(PCS_Batavia_UTM_zone_50S,	21150)
ValuePair(PCS_Beijing_Gauss_zone_13,	21413)
ValuePair(PCS_Beijing_Gauss_zone_14,	21414)
ValuePair(PCS_Beijing_Gauss_zone_15,	21415)
ValuePair(PCS_Beijing_Gauss_zone_16,	21416)
ValuePair(PCS_Beijing_Gauss_zone_17,	21417)
ValuePair(PCS_Beijing_Gauss_zone_18,	21418)
ValuePair(PCS_Beijing_Gauss_zone_19,	21419)
ValuePair(PCS_Beijing_Gauss_zone_20,	21420)
ValuePair(PCS_Beijing_Gauss_zone_21,	21421)
ValuePair(PCS_Beijing_Gauss_zone_22,	21422)
ValuePair(PCS_Beijing_Gauss_zone_23,	21423)
ValuePair(PCS_Beijing_Gauss_13N,	21473)
ValuePair(PCS_Beijing_Gauss_14N,	21474)
ValuePair(PCS_Beijing_Gauss_15N,	21475)
ValuePair(PCS_Beijing_Gauss_16N,	21476)
ValuePair(PCS_Beijing_Gauss_17N,	21477)
ValuePair(PCS_Beijing_Gauss_18N,	21478)
ValuePair(PCS_Beijing_Gauss_19N,	21479)
ValuePair(PCS_Beijing_Gauss_20N,	21480)
ValuePair(PCS_Beijing_Gauss_21N,	21481)
ValuePair(PCS_Beijing_Gauss_22N,	21482)
ValuePair(PCS_Beijing_Gauss_23N,	21483)
ValuePair(PCS_Belge_Lambert_50,	21500)
ValuePair(PCS_Bern_1898_Swiss_Old,	21790)
ValuePair(PCS_Bogota_UTM_zone_17N,	21817)
ValuePair(PCS_Bogota_UTM_zone_18N,	21818)
ValuePair(PCS_Bogota_Colombia_3W,	21891)
ValuePair(PCS_Bogota_Colombia_Bogota,	21892)
ValuePair(PCS_Bogota_Colombia_3E,	21893)
ValuePair(PCS_Bogota_Colombia_6E,	21894)
ValuePair(PCS_Camacupa_UTM_32S,	22032)
ValuePair(PCS_Camacupa_UTM_33S,	22033)
ValuePair(PCS_C_Inchauspe_Argentina_1,	22191)
ValuePair(PCS_C_Inchauspe_Argentina_2,	22192)
ValuePair(PCS_C_Inchauspe_Argentina_3,	22193)
ValuePair(PCS_C_Inchauspe_Argentina_4,	22194)
ValuePair(PCS_C_Inchauspe_Argentina_5,	22195)
ValuePair(PCS_C_Inchauspe_Argentina_6,	22196)
ValuePair(PCS_C_Inchauspe_Argentina_7,	22197)
ValuePair(PCS_Carthage_UTM_zone_32N,	22332)
ValuePair(PCS_Carthage_Nord_Tunisie,	22391)
ValuePair(PCS_Carthage_Sud_Tunisie,	22392)
ValuePair(PCS_Corrego_Alegre_UTM_23S,	22523)
ValuePair(PCS_Corrego_Alegre_UTM_24S,	22524)
ValuePair(PCS_Douala_UTM_zone_32N,	22832)
ValuePair(PCS_Egypt_1907_Red_Belt,	22992)
ValuePair(PCS_Egypt_1907_Purple_Belt,	22993)
ValuePair(PCS_Egypt_1907_Ext_Purple,	22994)
ValuePair(PCS_ED50_UTM_zone_28N,	23028)
ValuePair(PCS_ED50_UTM_zone_29N,	23029)
ValuePair(PCS_ED50_UTM_zone_30N,	23030)
ValuePair(PCS_ED50_UTM_zone_31N,	23031)
ValuePair(PCS_ED50_UTM_zone_32N,	23032)
ValuePair(PCS_ED50_UTM_zone_33N,	23033)
ValuePair(PCS_ED50_UTM_zone_34N,	23034)
ValuePair(PCS_ED50_UTM_zone_35N,	23035)
ValuePair(PCS_ED50_UTM_zone_36N,	23036)
ValuePair(PCS_ED50_UTM_zone_37N,	23037)
ValuePair(PCS_ED50_UTM_zone_38N,	23038)
ValuePair(PCS_Fahud_UTM_zone_39N,	23239)
ValuePair(PCS_Fahud_UTM_zone_40N,	23240)
ValuePair(PCS_Garoua_UTM_zone_33N,	23433)
ValuePair(PCS_ID74_UTM_zone_46N,	23846)
ValuePair(PCS_ID74_UTM_zone_47N,	23847)
ValuePair(PCS_ID74_UTM_zone_48N,	23848)
ValuePair(PCS_ID74_UTM_zone_49N,	23849)
ValuePair(PCS_ID74_UTM_zone_50N,	23850)
ValuePair(PCS_ID74_UTM_zone_51N,	23851)
ValuePair(PCS_ID74_UTM_zone_52N,	23852)
ValuePair(PCS_ID74_UTM_zone_53N,	23853)
ValuePair(PCS_ID74_UTM_zone_46S,	23886)
ValuePair(PCS_ID74_UTM_zone_47S,	23887)
ValuePair(PCS_ID74_UTM_zone_48S,	23888)
ValuePair(PCS_ID74_UTM_zone_49S,	23889)
ValuePair(PCS_ID74_UTM_zone_50S,	23890)
ValuePair(PCS_ID74_UTM_zone_51S,	23891)
ValuePair(PCS_ID74_UTM_zone_52S,	23892)
ValuePair(PCS_ID74_UTM_zone_53S,	23893)
ValuePair(PCS_ID74_UTM_zone_54S,	23894)
ValuePair(PCS_Indian_1954_UTM_47N,	23947)
ValuePair(PCS_Indian_1954_UTM_48N,	23948)
ValuePair(PCS_Indian_1975_UTM_47N,	24047)
ValuePair(PCS_Indian_1975_UTM_48N,	24048)
ValuePair(PCS_Jamaica_1875_Old_Grid,	24100)
ValuePair(PCS_JAD69_Jamaica_Grid,	24200)
ValuePair(PCS_Kalianpur_India_0,	24370)
ValuePair(PCS_Kalianpur_India_I,	24371)
ValuePair(PCS_Kalianpur_India_IIa,	24372)
ValuePair(PCS_Kalianpur_India_IIIa,	24373)
ValuePair(PCS_Kalianpur_India_IVa,	24374)
ValuePair(PCS_Kalianpur_India_IIb,	24382)
ValuePair(PCS_Kalianpur_India_IIIb,	24383)
ValuePair(PCS_Kalianpur_India_IVb,	24384)
ValuePair(PCS_Kertau_Singapore_Grid,	24500)
ValuePair(PCS_Kertau_UTM_zone_47N,	24547)
ValuePair(PCS_Kertau_UTM_zone_48N,	24548)
ValuePair(PCS_La_Canoa_UTM_zone_20N,	24720)
ValuePair(PCS_La_Canoa_UTM_zone_21N,	24721)
ValuePair(PCS_PSAD56_UTM_zone_18N,	24818)
ValuePair(PCS_PSAD56_UTM_zone_19N,	24819)
ValuePair(PCS_PSAD56_UTM_zone_20N,	24820)
ValuePair(PCS_PSAD56_UTM_zone_21N,	24821)
ValuePair(PCS_PSAD56_UTM_zone_17S,	24877)
ValuePair(PCS_PSAD56_UTM_zone_18S,	24878)
ValuePair(PCS_PSAD56_UTM_zone_19S,	24879)
ValuePair(PCS_PSAD56_UTM_zone_20S,	24880)
ValuePair(PCS_PSAD56_Peru_west_zone,	24891)
ValuePair(PCS_PSAD56_Peru_central,	24892)
ValuePair(PCS_PSAD56_Peru_east_zone,	24893)
ValuePair(PCS_Leigon_Ghana_Grid,	25000)
ValuePair(PCS_Lome_UTM_zone_31N,	25231)
ValuePair(PCS_Luzon_Philippines_I,	25391)
ValuePair(PCS_Luzon_Philippines_II,	25392)
ValuePair(PCS_Luzon_Philippines_III,	25393)
ValuePair(PCS_Luzon_Philippines_IV,	25394)
ValuePair(PCS_Luzon_Philippines_V,	25395)
ValuePair(PCS_Makassar_NEIEZ,	25700)
ValuePair(PCS_Malongo_1987_UTM_32S,	25932)
ValuePair(PCS_Merchich_Nord_Maroc,	26191)
ValuePair(PCS_Merchich_Sud_Maroc,	26192)
ValuePair(PCS_Merchich_Sahara,	26193)
ValuePair(PCS_Massawa_UTM_zone_37N,	26237)
ValuePair(PCS_Minna_UTM_zone_31N,	26331)
ValuePair(PCS_Minna_UTM_zone_32N,	26332)
ValuePair(PCS_Minna_Nigeria_West,	26391)
ValuePair(PCS_Minna_Nigeria_Mid_Belt,	26392)
ValuePair(PCS_Minna_Nigeria_East,	26393)
ValuePair(PCS_Mhast_UTM_zone_32S,	26432)
ValuePair(PCS_Monte_Mario_Italy_1,	26591)
ValuePair(PCS_Monte_Mario_Italy_2,	26592)
ValuePair(PCS_M_poraloko_UTM_32N,	26632)
ValuePair(PCS_M_poraloko_UTM_32S,	26692)
ValuePair(PCS_NAD27_UTM_zone_3N,	26703)
ValuePair(PCS_NAD27_UTM_zone_4N,	26704)
ValuePair(PCS_NAD27_UTM_zone_5N,	26705)
ValuePair(PCS_NAD27_UTM_zone_6N,	26706)
ValuePair(PCS_NAD27_UTM_zone_7N,	26707)
ValuePair(PCS_NAD27_UTM_zone_8N,	26708)
ValuePair(PCS_NAD27_UTM_zone_9N,	26709)
ValuePair(PCS_NAD27_UTM_zone_10N,	26710)
ValuePair(PCS_NAD27_UTM_zone_11N,	26711)
ValuePair(PCS_NAD27_UTM_zone_12N,	26712)
ValuePair(PCS_NAD27_UTM_zone_13N,	26713)
ValuePair(PCS_NAD27_UTM_zone_14N,	26714)
ValuePair(PCS_NAD27_UTM_zone_15N,	26715)
ValuePair(PCS_NAD27_UTM_zone_16N,	26716)
ValuePair(PCS_NAD27_UTM_zone_17N,	26717)
ValuePair(PCS_NAD27_UTM_zone_18N,	26718)
ValuePair(PCS_NAD27_UTM_zone_19N,	26719)
ValuePair(PCS_NAD27_UTM_zone_20N,	26720)
ValuePair(PCS_NAD27_UTM_zone_21N,	26721)
ValuePair(PCS_NAD27_UTM_zone_22N,	26722)
ValuePair(PCS_NAD27_Alabama_East,	26729)
ValuePair(PCS_NAD27_Alabama_West,	26730)
ValuePair(PCS_NAD27_Alaska_zone_1,	26731)
ValuePair(PCS_NAD27_Alaska_zone_2,	26732)
ValuePair(PCS_NAD27_Alaska_zone_3,	26733)
ValuePair(PCS_NAD27_Alaska_zone_4,	26734)
ValuePair(PCS_NAD27_Alaska_zone_5,	26735)
ValuePair(PCS_NAD27_Alaska_zone_6,	26736)
ValuePair(PCS_NAD27_Alaska_zone_7,	26737)
ValuePair(PCS_NAD27_Alaska_zone_8,	26738)
ValuePair(PCS_NAD27_Alaska_zone_9,	26739)
ValuePair(PCS_NAD27_Alaska_zone_10,	26740)
ValuePair(PCS_NAD27_California_I,	26741)
ValuePair(PCS_NAD27_California_II,	26742)
ValuePair(PCS_NAD27_California_III,	26743)
ValuePair(PCS_NAD27_California_IV,	26744)
ValuePair(PCS_NAD27_California_V,	26745)
ValuePair(PCS_NAD27_California_VI,	26746)
ValuePair(PCS_NAD27_California_VII,	26747)
ValuePair(PCS_NAD27_Arizona_East,	26748)
ValuePair(PCS_NAD27_Arizona_Central,	26749)
ValuePair(PCS_NAD27_Arizona_West,	26750)
ValuePair(PCS_NAD27_Arkansas_North,	26751)
ValuePair(PCS_NAD27_Arkansas_South,	26752)
ValuePair(PCS_NAD27_Colorado_North,	26753)
ValuePair(PCS_NAD27_Colorado_Central,	26754)
ValuePair(PCS_NAD27_Colorado_South,	26755)
ValuePair(PCS_NAD27_Connecticut,	26756)
ValuePair(PCS_NAD27_Delaware,	26757)
ValuePair(PCS_NAD27_Florida_East,	26758)
ValuePair(PCS_NAD27_Florida_West,	26759)
ValuePair(PCS_NAD27_Florida_North,	26760)
ValuePair(PCS_NAD27_Hawaii_zone_1,	26761)
ValuePair(PCS_NAD27_Hawaii_zone_2,	26762)
ValuePair(PCS_NAD27_Hawaii_zone_3,	26763)
ValuePair(PCS_NAD27_Hawaii_zone_4,	26764)
ValuePair(PCS_NAD27_Hawaii_zone_5,	26765)
ValuePair(PCS_NAD27_Georgia_East,	26766)
ValuePair(PCS_NAD27_Georgia_West,	26767)
ValuePair(PCS_NAD27_Idaho_East,	26768)
ValuePair(PCS_NAD27_Idaho_Central,	26769)
ValuePair(PCS_NAD27_Idaho_West,	26770)
ValuePair(PCS_NAD27_Illinois_East,	26771)
ValuePair(PCS_NAD27_Illinois_West,	26772)
ValuePair(PCS_NAD27_Indiana_East,	26773)
ValuePair(PCS_NAD27_BLM_14N_feet,	26774)
ValuePair(PCS_NAD27_Indiana_West,	26774)
ValuePair(PCS_NAD27_BLM_15N_feet,	26775)
ValuePair(PCS_NAD27_Iowa_North,	26775)
ValuePair(PCS_NAD27_BLM_16N_feet,	26776)
ValuePair(PCS_NAD27_Iowa_South,	26776)
ValuePair(PCS_NAD27_BLM_17N_feet,	26777)
ValuePair(PCS_NAD27_Kansas_North,	26777)
ValuePair(PCS_NAD27_Kansas_South,	26778)
ValuePair(PCS_NAD27_Kentucky_North,	26779)
ValuePair(PCS_NAD27_Kentucky_South,	26780)
ValuePair(PCS_NAD27_Louisiana_North,	26781)
ValuePair(PCS_NAD27_Louisiana_South,	26782)
ValuePair(PCS_NAD27_Maine_East,	26783)
ValuePair(PCS_NAD27_Maine_West,	26784)
ValuePair(PCS_NAD27_Maryland,	26785)
ValuePair(PCS_NAD27_Massachusetts,	26786)
ValuePair(PCS_NAD27_Massachusetts_Is,	26787)
ValuePair(PCS_NAD27_Michigan_North,	26788)
ValuePair(PCS_NAD27_Michigan_Central,	26789)
ValuePair(PCS_NAD27_Michigan_South,	26790)
ValuePair(PCS_NAD27_Minnesota_North,	26791)
ValuePair(PCS_NAD27_Minnesota_Cent,	26792)
ValuePair(PCS_NAD27_Minnesota_South,	26793)
ValuePair(PCS_NAD27_Mississippi_East,	26794)
ValuePair(PCS_NAD27_Mississippi_West,	26795)
ValuePair(PCS_NAD27_Missouri_East,	26796)
ValuePair(PCS_NAD27_Missouri_Central,	26797)
ValuePair(PCS_NAD27_Missouri_West,	26798)
ValuePair(PCS_NAD_Michigan_Michigan_East,	26801)
ValuePair(PCS_NAD_Michigan_Michigan_Old_Central,	26802)
ValuePair(PCS_NAD_Michigan_Michigan_West,	26803)
ValuePair(PCS_NAD83_UTM_zone_3N,	26903)
ValuePair(PCS_NAD83_UTM_zone_4N,	26904)
ValuePair(PCS_NAD83_UTM_zone_5N,	26905)
ValuePair(PCS_NAD83_UTM_zone_6N,	26906)
ValuePair(PCS_NAD83_UTM_zone_7N,	26907)
ValuePair(PCS_NAD83_UTM_zone_8N,	26908)
ValuePair(PCS_NAD83_UTM_zone_9N,	26909)
ValuePair(PCS_NAD83_UTM_zone_10N,	26910)
ValuePair(PCS_NAD83_UTM_zone_11N,	26911)
ValuePair(PCS_NAD83_UTM_zone_12N,	26912)
ValuePair(PCS_NAD83_UTM_zone_13N,	26913)
ValuePair(PCS_NAD83_UTM_zone_14N,	26914)
ValuePair(PCS_NAD83_UTM_zone_15N,	26915)
ValuePair(PCS_NAD83_UTM_zone_16N,	26916)
ValuePair(PCS_NAD83_UTM_zone_17N,	26917)
ValuePair(PCS_NAD83_UTM_zone_18N,	26918)
ValuePair(PCS_NAD83_UTM_zone_19N,	26919)
ValuePair(PCS_NAD83_UTM_zone_20N,	26920)
ValuePair(PCS_NAD83_UTM_zone_21N,	26921)
ValuePair(PCS_NAD83_UTM_zone_22N,	26922)
ValuePair(PCS_NAD83_UTM_zone_23N,	26923)
ValuePair(PCS_NAD83_Alabama_East,	26929)
ValuePair(PCS_NAD83_Alabama_West,	26930)
ValuePair(PCS_NAD83_Alaska_zone_1,	26931)
ValuePair(PCS_NAD83_Alaska_zone_2,	26932)
ValuePair(PCS_NAD83_Alaska_zone_3,	26933)
ValuePair(PCS_NAD83_Alaska_zone_4,	26934)
ValuePair(PCS_NAD83_Alaska_zone_5,	26935)
ValuePair(PCS_NAD83_Alaska_zone_6,	26936)
ValuePair(PCS_NAD83_Alaska_zone_7,	26937)
ValuePair(PCS_NAD83_Alaska_zone_8,	26938)
ValuePair(PCS_NAD83_Alaska_zone_9,	26939)
ValuePair(PCS_NAD83_Alaska_zone_10,	26940)
ValuePair(PCS_NAD83_California_1,	26941)
ValuePair(PCS_NAD83_California_2,	26942)
ValuePair(PCS_NAD83_California_3,	26943)
ValuePair(PCS_NAD83_California_4,	26944)
ValuePair(PCS_NAD83_California_5,	26945)
ValuePair(PCS_NAD83_California_6,	26946)
ValuePair(PCS_NAD83_Arizona_East,	26948)
ValuePair(PCS_NAD83_Arizona_Central,	26949)
ValuePair(PCS_NAD83_Arizona_West,	26950)
ValuePair(PCS_NAD83_Arkansas_North,	26951)
ValuePair(PCS_NAD83_Arkansas_South,	26952)
ValuePair(PCS_NAD83_Colorado_North,	26953)
ValuePair(PCS_NAD83_Colorado_Central,	26954)
ValuePair(PCS_NAD83_Colorado_South,	26955)
ValuePair(PCS_NAD83_Connecticut,	26956)
ValuePair(PCS_NAD83_Delaware,	26957)
ValuePair(PCS_NAD83_Florida_East,	26958)
ValuePair(PCS_NAD83_Florida_West,	26959)
ValuePair(PCS_NAD83_Florida_North,	26960)
ValuePair(PCS_NAD83_Hawaii_zone_1,	26961)
ValuePair(PCS_NAD83_Hawaii_zone_2,	26962)
ValuePair(PCS_NAD83_Hawaii_zone_3,	26963)
ValuePair(PCS_NAD83_Hawaii_zone_4,	26964)
ValuePair(PCS_NAD83_Hawaii_zone_5,	26965)
ValuePair(PCS_NAD83_Georgia_East,	26966)
ValuePair(PCS_NAD83_Georgia_West,	26967)
ValuePair(PCS_NAD83_Idaho_East,	26968)
ValuePair(PCS_NAD83_Idaho_Central,	26969)
ValuePair(PCS_NAD83_Idaho_West,	26970)
ValuePair(PCS_NAD83_Illinois_East,	26971)
ValuePair(PCS_NAD83_Illinois_West,	26972)
ValuePair(PCS_NAD83_Indiana_East,	26973)
ValuePair(PCS_NAD83_Indiana_West,	26974)
ValuePair(PCS_NAD83_Iowa_North,	26975)
ValuePair(PCS_NAD83_Iowa_South,	26976)
ValuePair(PCS_NAD83_Kansas_North,	26977)
ValuePair(PCS_NAD83_Kansas_South,	26978)
ValuePair(PCS_NAD83_Kentucky_North,	26979)
ValuePair(PCS_NAD83_Kentucky_South,	26980)
ValuePair(PCS_NAD83_Louisiana_North,	26981)
ValuePair(PCS_NAD83_Louisiana_South,	26982)
ValuePair(PCS_NAD83_Maine_East,	26983)
ValuePair(PCS_NAD83_Maine_West,	26984)
ValuePair(PCS_NAD83_Maryland,	26985)
ValuePair(PCS_NAD83_Massachusetts,	26986)
ValuePair(PCS_NAD83_Massachusetts_Is,	26987)
ValuePair(PCS_NAD83_Michigan_North,	26988)
ValuePair(PCS_NAD83_Michigan_Central,	26989)
ValuePair(PCS_NAD83_Michigan_South,	26990)
ValuePair(PCS_NAD83_Minnesota_North,	26991)
ValuePair(PCS_NAD83_Minnesota_Cent,	26992)
ValuePair(PCS_NAD83_Minnesota_South,	26993)
ValuePair(PCS_NAD83_Mississippi_East,	26994)
ValuePair(PCS_NAD83_Mississippi_West,	26995)
ValuePair(PCS_NAD83_Missouri_East,	26996)
ValuePair(PCS_NAD83_Missouri_Central,	26997)
ValuePair(PCS_NAD83_Missouri_West,	26998)
ValuePair(PCS_Nahrwan_1967_UTM_38N,	27038)
ValuePair(PCS_Nahrwan_1967_UTM_39N,	27039)
ValuePair(PCS_Nahrwan_1967_UTM_40N,	27040)
ValuePair(PCS_Nahrwan_1967_UTM_38N_Old,	27038)
ValuePair(PCS_Nahrwan_1967_UTM_39N_Old,	27039)
ValuePair(PCS_Nahrwan_1967_UTM_40N_Old,	27040)
ValuePair(PCS_Naparima_UTM_20N,	27120)
ValuePair(PCS_GD49_NZ_Map_Grid,	27200)
ValuePair(PCS_GD49_North_Island_Grid,	27291)
ValuePair(PCS_GD49_South_Island_Grid,	27292)
ValuePair(PCS_Datum_73_UTM_zone_29N,	27429)
ValuePair(PCS_ATF_Nord_de_Guerre,	27500)
ValuePair(PCS_NTF_France_I,	27581)
ValuePair(PCS_NTF_France_II,	27582)
ValuePair(PCS_NTF_France_III,	27583)
ValuePair(PCS_NTF_Nord_France,	27591)
ValuePair(PCS_NTF_Centre_France,	27592)
ValuePair(PCS_NTF_Sud_France,	27593)
ValuePair(PCS_British_National_Grid,	27700)
ValuePair(PCS_Point_Noire_UTM_32S,	28232)
ValuePair(PCS_GDA94_MGA_zone_48,	28348)
ValuePair(PCS_GDA94_MGA_zone_49,	28349)
ValuePair(PCS_GDA94_MGA_zone_50,	28350)
ValuePair(PCS_GDA94_MGA_zone_51,	28351)
ValuePair(PCS_GDA94_MGA_zone_52,	28352)
ValuePair(PCS_GDA94_MGA_zone_53,	28353)
ValuePair(PCS_GDA94_MGA_zone_54,	28354)
ValuePair(PCS_GDA94_MGA_zone_55,	28355)
ValuePair(PCS_GDA94_MGA_zone_56,	28356)
ValuePair(PCS_GDA94_MGA_zone_57,	28357)
ValuePair(PCS_GDA94_MGA_zone_58,	28358)
ValuePair(PCS_Pulkovo_Gauss_zone_4,	28404)
ValuePair(PCS_Pulkovo_Gauss_zone_5,	28405)
ValuePair(PCS_Pulkovo_Gauss_zone_6,	28406)
ValuePair(PCS_Pulkovo_Gauss_zone_7,	28407)
ValuePair(PCS_Pulkovo_Gauss_zone_8,	28408)
ValuePair(PCS_Pulkovo_Gauss_zone_9,	28409)
ValuePair(PCS_Pulkovo_Gauss_zone_10,	28410)
ValuePair(PCS_Pulkovo_Gauss_zone_11,	28411)
ValuePair(PCS_Pulkovo_Gauss_zone_12,	28412)
ValuePair(PCS_Pulkovo_Gauss_zone_13,	28413)
ValuePair(PCS_Pulkovo_Gauss_zone_14,	28414)
ValuePair(PCS_Pulkovo_Gauss_zone_15,	28415)
ValuePair(PCS_Pulkovo_Gauss_zone_16,	28416)
ValuePair(PCS_Pulkovo_Gauss_zone_17,	28417)
ValuePair(PCS_Pulkovo_Gauss_zone_18,	28418)
ValuePair(PCS_Pulkovo_Gauss_zone_19,	28419)
ValuePair(PCS_Pulkovo_Gauss_zone_20,	28420)
ValuePair(PCS_Pulkovo_Gauss_zone_21,	28421)
ValuePair(PCS_Pulkovo_Gauss_zone_22,	28422)
ValuePair(PCS_Pulkovo_Gauss_zone_23,	28423)
ValuePair(PCS_Pulkovo_Gauss_zone_24,	28424)
ValuePair(PCS_Pulkovo_Gauss_zone_25,	28425)
ValuePair(PCS_Pulkovo_Gauss_zone_26,	28426)
ValuePair(PCS_Pulkovo_Gauss_zone_27,	28427)
ValuePair(PCS_Pulkovo_Gauss_zone_28,	28428)
ValuePair(PCS_Pulkovo_Gauss_zone_29,	28429)
ValuePair(PCS_Pulkovo_Gauss_zone_30,	28430)
ValuePair(PCS_Pulkovo_Gauss_zone_31,	28431)
ValuePair(PCS_Pulkovo_Gauss_zone_32,	28432)
ValuePair(PCS_Pulkovo_Gauss_4N,	28464)
ValuePair(PCS_Pulkovo_Gauss_5N,	28465)
ValuePair(PCS_Pulkovo_Gauss_6N,	28466)
ValuePair(PCS_Pulkovo_Gauss_7N,	28467)
ValuePair(PCS_Pulkovo_Gauss_8N,	28468)
ValuePair(PCS_Pulkovo_Gauss_9N,	28469)
ValuePair(PCS_Pulkovo_Gauss_10N,	28470)
ValuePair(PCS_Pulkovo_Gauss_11N,	28471)
ValuePair(PCS_Pulkovo_Gauss_12N,	28472)
ValuePair(PCS_Pulkovo_Gauss_13N,	28473)
ValuePair(PCS_Pulkovo_Gauss_14N,	28474)
ValuePair(PCS_Pulkovo_Gauss_15N,	28475)
ValuePair(PCS_Pulkovo_Gauss_16N,	28476)
ValuePair(PCS_Pulkovo_Gauss_17N,	28477)
ValuePair(PCS_Pulkovo_Gauss_18N,	28478)
ValuePair(PCS_Pulkovo_Gauss_19N,	28479)
ValuePair(PCS_Pulkovo_Gauss_20N,	28480)
ValuePair(PCS_Pulkovo_Gauss_21N,	28481)
ValuePair(PCS_Pulkovo_Gauss_22N,	28482)
ValuePair(PCS_Pulkovo_Gauss_23N,	28483)
ValuePair(PCS_Pulkovo_Gauss_24N,	28484)
ValuePair(PCS_Pulkovo_Gauss_25N,	28485)
ValuePair(PCS_Pulkovo_Gauss_26N,	28486)
ValuePair(PCS_Pulkovo_Gauss_27N,	28487)
ValuePair(PCS_Pulkovo_Gauss_28N,	28488)
ValuePair(PCS_Pulkovo_Gauss_29N,	28489)
ValuePair(PCS_Pulkovo_Gauss_30N,	28490)
ValuePair(PCS_Pulkovo_Gauss_31N,	28491)
ValuePair(PCS_Pulkovo_Gauss_32N,	28492)
ValuePair(PCS_Qatar_National_Grid,	28600)
ValuePair(PCS_RD_Netherlands_Old,	28991)
ValuePair(PCS_RD_Netherlands_New,	28992)
ValuePair(PCS_SAD69_UTM_zone_18N,	29118)
ValuePair(PCS_SAD69_UTM_zone_19N,	29119)
ValuePair(PCS_SAD69_UTM_zone_20N,	29120)
ValuePair(PCS_SAD69_UTM_zone_21N,	29121)
ValuePair(PCS_SAD69_UTM_zone_22N,	29122)
ValuePair(PCS_SAD69_UTM_zone_17S,	29177)
ValuePair(PCS_SAD69_UTM_zone_18S,	29178)
ValuePair(PCS_SAD69_UTM_zone_19S,	29179)
ValuePair(PCS_SAD69_UTM_zone_20S,	29180)
ValuePair(PCS_SAD69_UTM_zone_21S,	29181)
ValuePair(PCS_SAD69_UTM_zone_22S,	29182)
ValuePair(PCS_SAD69_UTM_zone_23S,	29183)
ValuePair(PCS_SAD69_UTM_zone_24S,	29184)
ValuePair(PCS_SAD69_UTM_zone_25S,	29185)
ValuePair(PCS_Sapper_Hill_UTM_20S,	29220)
ValuePair(PCS_Sapper_Hill_UTM_21S,	29221)
ValuePair(PCS_Schwarzeck_UTM_33S,	29333)
ValuePair(PCS_Sudan_UTM_zone_35N,	29635)
ValuePair(PCS_Sudan_UTM_zone_36N,	29636)
ValuePair(PCS_Tananarive_Laborde,	29700)
ValuePair(PCS_Tananarive_UTM_38S,	29738)
ValuePair(PCS_Tananarive_UTM_39S,	29739)
ValuePair(PCS_Timbalai_1948_Borneo,	29800)
ValuePair(PCS_Timbalai_1948_UTM_49N,	29849)
ValuePair(PCS_Timbalai_1948_UTM_50N,	29850)
ValuePair(PCS_TM65_Irish_Nat_Grid,	29900)
ValuePair(PCS_Trinidad_1903_Trinidad,	30200)
ValuePair(PCS_TC_1948_UTM_zone_39N,	30339)
ValuePair(PCS_TC_1948_UTM_zone_40N,	30340)
ValuePair(PCS_Voirol_N_Algerie_ancien,	30491)
ValuePair(PCS_Voirol_S_Algerie_ancien,	30492)
ValuePair(PCS_Voirol_Unifie_N_Algerie,	30591)
ValuePair(PCS_Voirol_Unifie_S_Algerie,	30592)
ValuePair(PCS_Bern_1938_Swiss_New,	30600)
ValuePair(PCS_Nord_Sahara_UTM_29N,	30729)
ValuePair(PCS_Nord_Sahara_UTM_30N,	30730)
ValuePair(PCS_Nord_Sahara_UTM_31N,	30731)
ValuePair(PCS_Nord_Sahara_UTM_32N,	30732)
ValuePair(PCS_Yoff_UTM_zone_28N,	31028)
ValuePair(PCS_Zanderij_UTM_zone_21N,	31121)
ValuePair(PCS_MGI_Austria_West,	31291)
ValuePair(PCS_MGI_Austria_Central,	31292)
ValuePair(PCS_MGI_Austria_East,	31293)
ValuePair(PCS_Belge_Lambert_72,	31300)
ValuePair(PCS_DHDN_Germany_zone_1,	31491)
ValuePair(PCS_DHDN_Germany_zone_2,	31492)
ValuePair(PCS_DHDN_Germany_zone_3,	31493)
ValuePair(PCS_DHDN_Germany_zone_4,	31494)
ValuePair(PCS_DHDN_Germany_zone_5,	31495)
ValuePair(PCS_NAD27_Montana_North,	32001)
ValuePair(PCS_NAD27_Montana_Central,	32002)
ValuePair(PCS_NAD27_Montana_South,	32003)
ValuePair(PCS_NAD27_Nebraska_North,	32005)
ValuePair(PCS_NAD27_Nebraska_South,	32006)
ValuePair(PCS_NAD27_Nevada_East,	32007)
ValuePair(PCS_NAD27_Nevada_Central,	32008)
ValuePair(PCS_NAD27_Nevada_West,	32009)
ValuePair(PCS_NAD27_New_Hampshire,	32010)
ValuePair(PCS_NAD27_New_Jersey,	32011)
ValuePair(PCS_NAD27_New_Mexico_East,	32012)
ValuePair(PCS_NAD27_New_Mexico_Cent,	32013)
ValuePair(PCS_NAD27_New_Mexico_West,	32014)
ValuePair(PCS_NAD27_New_York_East,	32015)
ValuePair(PCS_NAD27_New_York_Central,	32016)
ValuePair(PCS_NAD27_New_York_West,	32017)
ValuePair(PCS_NAD27_New_York_Long_Is,	32018)
ValuePair(PCS_NAD27_North_Carolina,	32019)
ValuePair(PCS_NAD27_North_Dakota_N,	32020)
ValuePair(PCS_NAD27_North_Dakota_S,	32021)
ValuePair(PCS_NAD27_Ohio_North,	32022)
ValuePair(PCS_NAD27_Ohio_South,	32023)
ValuePair(PCS_NAD27_Oklahoma_North,	32024)
ValuePair(PCS_NAD27_Oklahoma_South,	32025)
ValuePair(PCS_NAD27_Oregon_North,	32026)
ValuePair(PCS_NAD27_Oregon_South,	32027)
ValuePair(PCS_NAD27_Pennsylvania_N,	32028)
ValuePair(PCS_NAD27_Pennsylvania_S,	32029)
ValuePair(PCS_NAD27_Rhode_Island,	32030)
ValuePair(PCS_NAD27_South_Carolina_N,	32031)
ValuePair(PCS_NAD27_South_Carolina_S,	32033)
ValuePair(PCS_NAD27_South_Dakota_N,	32034)
ValuePair(PCS_NAD27_South_Dakota_S,	32035)
ValuePair(PCS_NAD27_Tennessee,	32036)
ValuePair(PCS_NAD27_Texas_North,	32037)
ValuePair(PCS_NAD27_Texas_North_Cen,	32038)
ValuePair(PCS_NAD27_Texas_Central,	32039)
ValuePair(PCS_NAD27_Texas_South_Cen,	32040)
ValuePair(PCS_NAD27_Texas_South,	32041)
ValuePair(PCS_NAD27_Utah_North,	32042)
ValuePair(PCS_NAD27_Utah_Central,	32043)
ValuePair(PCS_NAD27_Utah_South,	32044)
ValuePair(PCS_NAD27_Vermont,	32045)
ValuePair(PCS_NAD27_Virginia_North,	32046)
ValuePair(PCS_NAD27_Virginia_South,	32047)
ValuePair(PCS_NAD27_Washington_North,	32048)
ValuePair(PCS_NAD27_Washington_South,	32049)
ValuePair(PCS_NAD27_West_Virginia_N,	32050)
ValuePair(PCS_NAD27_West_Virginia_S,	32051)
ValuePair(PCS_NAD27_Wisconsin_North,	32052)
ValuePair(PCS_NAD27_Wisconsin_Cen,	32053)
ValuePair(PCS_NAD27_Wisconsin_South,	32054)
ValuePair(PCS_NAD27_Wyoming_East,	32055)
ValuePair(PCS_NAD27_Wyoming_E_Cen,	32056)
ValuePair(PCS_NAD27_Wyoming_W_Cen,	32057)
ValuePair(PCS_NAD27_Wyoming_West,	32058)
ValuePair(PCS_NAD27_Puerto_Rico,	32059)
ValuePair(PCS_NAD27_St_Croix,	32060)
ValuePair(PCS_NAD83_Montana,	32100)
ValuePair(PCS_NAD83_Nebraska,	32104)
ValuePair(PCS_NAD83_Nevada_East,	32107)
ValuePair(PCS_NAD83_Nevada_Central,	32108)
ValuePair(PCS_NAD83_Nevada_West,	32109)
ValuePair(PCS_NAD83_New_Hampshire,	32110)
ValuePair(PCS_NAD83_New_Jersey,	32111)
ValuePair(PCS_NAD83_New_Mexico_East,	32112)
ValuePair(PCS_NAD83_New_Mexico_Cent,	32113)
ValuePair(PCS_NAD83_New_Mexico_West,	32114)
ValuePair(PCS_NAD83_New_York_East,	32115)
ValuePair(PCS_NAD83_New_York_Central,	32116)
ValuePair(PCS_NAD83_New_York_West,	32117)
ValuePair(PCS_NAD83_New_York_Long_Is,	32118)
ValuePair(PCS_NAD83_North_Carolina,	32119)
ValuePair(PCS_NAD83_North_Dakota_N,	32120)
ValuePair(PCS_NAD83_North_Dakota_S,	32121)
ValuePair(PCS_NAD83_Ohio_North,	32122)
ValuePair(PCS_NAD83_Ohio_South,	32123)
ValuePair(PCS_NAD83_Oklahoma_North,	32124)
ValuePair(PCS_NAD83_Oklahoma_South,	32125)
ValuePair(PCS_NAD83_Oregon_North,	32126)
ValuePair(PCS_NAD83_Oregon_South,	32127)
ValuePair(PCS_NAD83_Pennsylvania_N,	32128)
ValuePair(PCS_NAD83_Pennsylvania_S,	32129)
ValuePair(PCS_NAD83_Rhode_Island,	32130)
ValuePair(PCS_NAD83_South_Carolina,	32133)
ValuePair(PCS_NAD83_South_Dakota_N,	32134)
ValuePair(PCS_NAD83_South_Dakota_S,	32135)
ValuePair(PCS_NAD83_Tennessee,	32136)
ValuePair(PCS_NAD83_Texas_North,	32137)
ValuePair(PCS_NAD83_Texas_North_Cen,	32138)
ValuePair(PCS_NAD83_Texas_Central,	32139)
ValuePair(PCS_NAD83_Texas_South_Cen,	32140)
ValuePair(PCS_NAD83_Texas_South,	32141)
ValuePair(PCS_NAD83_Utah_North,	32142)
ValuePair(PCS_NAD83_Utah_Central,	32143)
ValuePair(PCS_NAD83_Utah_South,	32144)
ValuePair(PCS_NAD83_Vermont,	32145)
ValuePair(PCS_NAD83_Virginia_North,	32146)
ValuePair(PCS_NAD83_Virginia_South,	32147)
ValuePair(PCS_NAD83_Washington_North,	32148)
ValuePair(PCS_NAD83_Washington_South,	32149)
ValuePair(PCS_NAD83_West_Virginia_N,	32150)
ValuePair(PCS_NAD83_West_Virginia_S,	32151)
ValuePair(PCS_NAD83_Wisconsin_North,	32152)
ValuePair(PCS_NAD83_Wisconsin_Cen,	32153)
ValuePair(PCS_NAD83_Wisconsin_South,	32154)
ValuePair(PCS_NAD83_Wyoming_East,	32155)
ValuePair(PCS_NAD83_Wyoming_E_Cen,	32156)
ValuePair(PCS_NAD83_Wyoming_W_Cen,	32157)
ValuePair(PCS_NAD83_Wyoming_West,	32158)
ValuePair(PCS_NAD83_Puerto_Rico_Virgin_Is,	32161)
ValuePair(PCS_WGS72_UTM_zone_1N,	32201)
ValuePair(PCS_WGS72_UTM_zone_2N,	32202)
ValuePair(PCS_WGS72_UTM_zone_3N,	32203)
ValuePair(PCS_WGS72_UTM_zone_4N,	32204)
ValuePair(PCS_WGS72_UTM_zone_5N,	32205)
ValuePair(PCS_WGS72_UTM_zone_6N,	32206)
ValuePair(PCS_WGS72_UTM_zone_7N,	32207)
ValuePair(PCS_WGS72_UTM_zone_8N,	32208)
ValuePair(PCS_WGS72_UTM_zone_9N,	32209)
ValuePair(PCS_WGS72_UTM_zone_10N,	32210)
ValuePair(PCS_WGS72_UTM_zone_11N,	32211)
ValuePair(PCS_WGS72_UTM_zone_12N,	32212)
ValuePair(PCS_WGS72_UTM_zone_13N,	32213)
ValuePair(PCS_WGS72_UTM_zone_14N,	32214)
ValuePair(PCS_WGS72_UTM_zone_15N,	32215)
ValuePair(PCS_WGS72_UTM_zone_16N,	32216)
ValuePair(PCS_WGS72_UTM_zone_17N,	32217)
ValuePair(PCS_WGS72_UTM_zone_18N,	32218)
ValuePair(PCS_WGS72_UTM_zone_19N,	32219)
ValuePair(PCS_WGS72_UTM_zone_20N,	32220)
ValuePair(PCS_WGS72_UTM_zone_21N,	32221)
ValuePair(PCS_WGS72_UTM_zone_22N,	32222)
ValuePair(PCS_WGS72_UTM_zone_23N,	32223)
ValuePair(PCS_WGS72_UTM_zone_24N,	32224)
ValuePair(PCS_WGS72_UTM_zone_25N,	32225)
ValuePair(PCS_WGS72_UTM_zone_26N,	32226)
ValuePair(PCS_WGS72_UTM_zone_27N,	32227)
ValuePair(PCS_WGS72_UTM_zone_28N,	32228)
ValuePair(PCS_WGS72_UTM_zone_29N,	32229)
ValuePair(PCS_WGS72_UTM_zone_30N,	32230)
ValuePair(PCS_WGS72_UTM_zone_31N,	32231)
ValuePair(PCS_WGS72_UTM_zone_32N,	32232)
ValuePair(PCS_WGS72_UTM_zone_33N,	32233)
ValuePair(PCS_WGS72_UTM_zone_34N,	32234)
ValuePair(PCS_WGS72_UTM_zone_35N,	32235)
ValuePair(PCS_WGS72_UTM_zone_36N,	32236)
ValuePair(PCS_WGS72_UTM_zone_37N,	32237)
ValuePair(PCS_WGS72_UTM_zone_38N,	32238)
ValuePair(PCS_WGS72_UTM_zone_39N,	32239)
ValuePair(PCS_WGS72_UTM_zone_40N,	32240)
ValuePair(PCS_WGS72_UTM_zone_41N,	32241)
ValuePair(PCS_WGS72_UTM_zone_42N,	32242)
ValuePair(PCS_WGS72_UTM_zone_43N,	32243)
ValuePair(PCS_WGS72_UTM_zone_44N,	32244)
ValuePair(PCS_WGS72_UTM_zone_45N,	32245)
ValuePair(PCS_WGS72_UTM_zone_46N,	32246)
ValuePair(PCS_WGS72_UTM_zone_47N,	32247)
ValuePair(PCS_WGS72_UTM_zone_48N,	32248)
ValuePair(PCS_WGS72_UTM_zone_49N,	32249)
ValuePair(PCS_WGS72_UTM_zone_50N,	32250)
ValuePair(PCS_WGS72_UTM_zone_51N,	32251)
ValuePair(PCS_WGS72_UTM_zone_52N,	32252)
ValuePair(PCS_WGS72_UTM_zone_53N,	32253)
ValuePair(PCS_WGS72_UTM_zone_54N,	32254)
ValuePair(PCS_WGS72_UTM_zone_55N,	32255)
ValuePair(PCS_WGS72_UTM_zone_56N,	32256)
ValuePair(PCS_WGS72_UTM_zone_57N,	32257)
ValuePair(PCS_WGS72_UTM_zone_58N,	32258)
ValuePair(PCS_WGS72_UTM_zone_59N,	32259)
ValuePair(PCS_WGS72_UTM_zone_60N,	32260)
ValuePair(PCS_WGS72_UTM_zone_1S,	32301)
ValuePair(PCS_WGS72_UTM_zone_2S,	32302)
ValuePair(PCS_WGS72_UTM_zone_3S,	32303)
ValuePair(PCS_WGS72_UTM_zone_4S,	32304)
ValuePair(PCS_WGS72_UTM_zone_5S,	32305)
ValuePair(PCS_WGS72_UTM_zone_6S,	32306)
ValuePair(PCS_WGS72_UTM_zone_7S,	32307)
ValuePair(PCS_WGS72_UTM_zone_8S,	32308)
ValuePair(PCS_WGS72_UTM_zone_9S,	32309)
ValuePair(PCS_WGS72_UTM_zone_10S,	32310)
ValuePair(PCS_WGS72_UTM_zone_11S,	32311)
ValuePair(PCS_WGS72_UTM_zone_12S,	32312)
ValuePair(PCS_WGS72_UTM_zone_13S,	32313)
ValuePair(PCS_WGS72_UTM_zone_14S,	32314)
ValuePair(PCS_WGS72_UTM_zone_15S,	32315)
ValuePair(PCS_WGS72_UTM_zone_16S,	32316)
ValuePair(PCS_WGS72_UTM_zone_17S,	32317)
ValuePair(PCS_WGS72_UTM_zone_18S,	32318)
ValuePair(PCS_WGS72_UTM_zone_19S,	32319)
ValuePair(PCS_WGS72_UTM_zone_20S,	32320)
ValuePair(PCS_WGS72_UTM_zone_21S,	32321)
ValuePair(PCS_WGS72_UTM_zone_22S,	32322)
ValuePair(PCS_WGS72_UTM_zone_23S,	32323)
ValuePair(PCS_WGS72_UTM_zone_24S,	32324)
ValuePair(PCS_WGS72_UTM_zone_25S,	32325)
ValuePair(PCS_WGS72_UTM_zone_26S,	32326)
ValuePair(PCS_WGS72_UTM_zone_27S,	32327)
ValuePair(PCS_WGS72_UTM_zone_28S,	32328)
ValuePair(PCS_WGS72_UTM_zone_29S,	32329)
ValuePair(PCS_WGS72_UTM_zone_30S,	32330)
ValuePair(PCS_WGS72_UTM_zone_31S,	32331)
ValuePair(PCS_WGS72_UTM_zone_32S,	32332)
ValuePair(PCS_WGS72_UTM_zone_33S,	32333)
ValuePair(PCS_WGS72_UTM_zone_34S,	32334)
ValuePair(PCS_WGS72_UTM_zone_35S,	32335)
ValuePair(PCS_WGS72_UTM_zone_36S,	32336)
ValuePair(PCS_WGS72_UTM_zone_37S,	32337)
ValuePair(PCS_WGS72_UTM_zone_38S,	32338)
ValuePair(PCS_WGS72_UTM_zone_39S,	32339)
ValuePair(PCS_WGS72_UTM_zone_40S,	32340)
ValuePair(PCS_WGS72_UTM_zone_41S,	32341)
ValuePair(PCS_WGS72_UTM_zone_42S,	32342)
ValuePair(PCS_WGS72_UTM_zone_43S,	32343)
ValuePair(PCS_WGS72_UTM_zone_44S,	32344)
ValuePair(PCS_WGS72_UTM_zone_45S,	32345)
ValuePair(PCS_WGS72_UTM_zone_46S,	32346)
ValuePair(PCS_WGS72_UTM_zone_47S,	32347)
ValuePair(PCS_WGS72_UTM_zone_48S,	32348)
ValuePair(PCS_WGS72_UTM_zone_49S,	32349)
ValuePair(PCS_WGS72_UTM_zone_50S,	32350)
ValuePair(PCS_WGS72_UTM_zone_51S,	32351)
ValuePair(PCS_WGS72_UTM_zone_52S,	32352)
ValuePair(PCS_WGS72_UTM_zone_53S,	32353)
ValuePair(PCS_WGS72_UTM_zone_54S,	32354)
ValuePair(PCS_WGS72_UTM_zone_55S,	32355)
ValuePair(PCS_WGS72_UTM_zone_56S,	32356)
ValuePair(PCS_WGS72_UTM_zone_57S,	32357)
ValuePair(PCS_WGS72_UTM_zone_58S,	32358)
ValuePair(PCS_WGS72_UTM_zone_59S,	32359)
ValuePair(PCS_WGS72_UTM_zone_60S,	32360)
ValuePair(PCS_WGS72BE_UTM_zone_1N,	32401)
ValuePair(PCS_WGS72BE_UTM_zone_2N,	32402)
ValuePair(PCS_WGS72BE_UTM_zone_3N,	32403)
ValuePair(PCS_WGS72BE_UTM_zone_4N,	32404)
ValuePair(PCS_WGS72BE_UTM_zone_5N,	32405)
ValuePair(PCS_WGS72BE_UTM_zone_6N,	32406)
ValuePair(PCS_WGS72BE_UTM_zone_7N,	32407)
ValuePair(PCS_WGS72BE_UTM_zone_8N,	32408)
ValuePair(PCS_WGS72BE_UTM_zone_9N,	32409)
ValuePair(PCS_WGS72BE_UTM_zone_10N,	32410)
ValuePair(PCS_WGS72BE_UTM_zone_11N,	32411)
ValuePair(PCS_WGS72BE_UTM_zone_12N,	32412)
ValuePair(PCS_WGS72BE_UTM_zone_13N,	32413)
ValuePair(PCS_WGS72BE_UTM_zone_14N,	32414)
ValuePair(PCS_WGS72BE_UTM_zone_15N,	32415)
ValuePair(PCS_WGS72BE_UTM_zone_16N,	32416)
ValuePair(PCS_WGS72BE_UTM_zone_17N,	32417)
ValuePair(PCS_WGS72BE_UTM_zone_18N,	32418)
ValuePair(PCS_WGS72BE_UTM_zone_19N,	32419)
ValuePair(PCS_WGS72BE_UTM_zone_20N,	32420)
ValuePair(PCS_WGS72BE_UTM_zone_21N,	32421)
ValuePair(PCS_WGS72BE_UTM_zone_22N,	32422)
ValuePair(PCS_WGS72BE_UTM_zone_23N,	32423)
ValuePair(PCS_WGS72BE_UTM_zone_24N,	32424)
ValuePair(PCS_WGS72BE_UTM_zone_25N,	32425)
ValuePair(PCS_WGS72BE_UTM_zone_26N,	32426)
ValuePair(PCS_WGS72BE_UTM_zone_27N,	32427)
ValuePair(PCS_WGS72BE_UTM_zone_28N,	32428)
ValuePair(PCS_WGS72BE_UTM_zone_29N,	32429)
ValuePair(PCS_WGS72BE_UTM_zone_30N,	32430)
ValuePair(PCS_WGS72BE_UTM_zone_31N,	32431)
ValuePair(PCS_WGS72BE_UTM_zone_32N,	32432)
ValuePair(PCS_WGS72BE_UTM_zone_33N,	32433)
ValuePair(PCS_WGS72BE_UTM_zone_34N,	32434)
ValuePair(PCS_WGS72BE_UTM_zone_35N,	32435)
ValuePair(PCS_WGS72BE_UTM_zone_36N,	32436)
ValuePair(PCS_WGS72BE_UTM_zone_37N,	32437)
ValuePair(PCS_WGS72BE_UTM_zone_38N,	32438)
ValuePair(PCS_WGS72BE_UTM_zone_39N,	32439)
ValuePair(PCS_WGS72BE_UTM_zone_40N,	32440)
ValuePair(PCS_WGS72BE_UTM_zone_41N,	32441)
ValuePair(PCS_WGS72BE_UTM_zone_42N,	32442)
ValuePair(PCS_WGS72BE_UTM_zone_43N,	32443)
ValuePair(PCS_WGS72BE_UTM_zone_44N,	32444)
ValuePair(PCS_WGS72BE_UTM_zone_45N,	32445)
ValuePair(PCS_WGS72BE_UTM_zone_46N,	32446)
ValuePair(PCS_WGS72BE_UTM_zone_47N,	32447)
ValuePair(PCS_WGS72BE_UTM_zone_48N,	32448)
ValuePair(PCS_WGS72BE_UTM_zone_49N,	32449)
ValuePair(PCS_WGS72BE_UTM_zone_50N,	32450)
ValuePair(PCS_WGS72BE_UTM_zone_51N,	32451)
ValuePair(PCS_WGS72BE_UTM_zone_52N,	32452)
ValuePair(PCS_WGS72BE_UTM_zone_53N,	32453)
ValuePair(PCS_WGS72BE_UTM_zone_54N,	32454)
ValuePair(PCS_WGS72BE_UTM_zone_55N,	32455)
ValuePair(PCS_WGS72BE_UTM_zone_56N,	32456)
ValuePair(PCS_WGS72BE_UTM_zone_57N,	32457)
ValuePair(PCS_WGS72BE_UTM_zone_58N,	32458)
ValuePair(PCS_WGS72BE_UTM_zone_59N,	32459)
ValuePair(PCS_WGS72BE_UTM_zone_60N,	32460)
ValuePair(PCS_WGS72BE_UTM_zone_1S,	32501)
ValuePair(PCS_WGS72BE_UTM_zone_2S,	32502)
ValuePair(PCS_WGS72BE_UTM_zone_3S,	32503)
ValuePair(PCS_WGS72BE_UTM_zone_4S,	32504)
ValuePair(PCS_WGS72BE_UTM_zone_5S,	32505)
ValuePair(PCS_WGS72BE_UTM_zone_6S,	32506)
ValuePair(PCS_WGS72BE_UTM_zone_7S,	32507)
ValuePair(PCS_WGS72BE_UTM_zone_8S,	32508)
ValuePair(PCS_WGS72BE_UTM_zone_9S,	32509)
ValuePair(PCS_WGS72BE_UTM_zone_10S,	32510)
ValuePair(PCS_WGS72BE_UTM_zone_11S,	32511)
ValuePair(PCS_WGS72BE_UTM_zone_12S,	32512)
ValuePair(PCS_WGS72BE_UTM_zone_13S,	32513)
ValuePair(PCS_WGS72BE_UTM_zone_14S,	32514)
ValuePair(PCS_WGS72BE_UTM_zone_15S,	32515)
ValuePair(PCS_WGS72BE_UTM_zone_16S,	32516)
ValuePair(PCS_WGS72BE_UTM_zone_17S,	32517)
ValuePair(PCS_WGS72BE_UTM_zone_18S,	32518)
ValuePair(PCS_WGS72BE_UTM_zone_19S,	32519)
ValuePair(PCS_WGS72BE_UTM_zone_20S,	32520)
ValuePair(PCS_WGS72BE_UTM_zone_21S,	32521)
ValuePair(PCS_WGS72BE_UTM_zone_22S,	32522)
ValuePair(PCS_WGS72BE_UTM_zone_23S,	32523)
ValuePair(PCS_WGS72BE_UTM_zone_24S,	32524)
ValuePair(PCS_WGS72BE_UTM_zone_25S,	32525)
ValuePair(PCS_WGS72BE_UTM_zone_26S,	32526)
ValuePair(PCS_WGS72BE_UTM_zone_27S,	32527)
ValuePair(PCS_WGS72BE_UTM_zone_28S,	32528)
ValuePair(PCS_WGS72BE_UTM_zone_29S,	32529)
ValuePair(PCS_WGS72BE_UTM_zone_30S,	32530)
ValuePair(PCS_WGS72BE_UTM_zone_31S,	32531)
ValuePair(PCS_WGS72BE_UTM_zone_32S,	32532)
ValuePair(PCS_WGS72BE_UTM_zone_33S,	32533)
ValuePair(PCS_WGS72BE_UTM_zone_34S,	32534)
ValuePair(PCS_WGS72BE_UTM_zone_35S,	32535)
ValuePair(PCS_WGS72BE_UTM_zone_36S,	32536)
ValuePair(PCS_WGS72BE_UTM_zone_37S,	32537)
ValuePair(PCS_WGS72BE_UTM_zone_38S,	32538)
ValuePair(PCS_WGS72BE_UTM_zone_39S,	32539)
ValuePair(PCS_WGS72BE_UTM_zone_40S,	32540)
ValuePair(PCS_WGS72BE_UTM_zone_41S,	32541)
ValuePair(PCS_WGS72BE_UTM_zone_42S,	32542)
ValuePair(PCS_WGS72BE_UTM_zone_43S,	32543)
ValuePair(PCS_WGS72BE_UTM_zone_44S,	32544)
ValuePair(PCS_WGS72BE_UTM_zone_45S,	32545)
ValuePair(PCS_WGS72BE_UTM_zone_46S,	32546)
ValuePair(PCS_WGS72BE_UTM_zone_47S,	32547)
ValuePair(PCS_WGS72BE_UTM_zone_48S,	32548)
ValuePair(PCS_WGS72BE_UTM_zone_49S,	32549)
ValuePair(PCS_WGS72BE_UTM_zone_50S,	32550)
ValuePair(PCS_WGS72BE_UTM_zone_51S,	32551)
ValuePair(PCS_WGS72BE_UTM_zone_52S,	32552)
ValuePair(PCS_WGS72BE_UTM_zone_53S,	32553)
ValuePair(PCS_WGS72BE_UTM_zone_54S,	32554)
ValuePair(PCS_WGS72BE_UTM_zone_55S,	32555)
ValuePair(PCS_WGS72BE_UTM_zone_56S,	32556)
ValuePair(PCS_WGS72BE_UTM_zone_57S,	32557)
ValuePair(PCS_WGS72BE_UTM_zone_58S,	32558)
ValuePair(PCS_WGS72BE_UTM_zone_59S,	32559)
ValuePair(PCS_WGS72BE_UTM_zone_60S,	32560)
ValuePair(PCS_WGS84_UTM_zone_1N,	32601)
ValuePair(PCS_WGS84_UTM_zone_2N,	32602)
ValuePair(PCS_WGS84_UTM_zone_3N,	32603)
ValuePair(PCS_WGS84_UTM_zone_4N,	32604)
ValuePair(PCS_WGS84_UTM_zone_5N,	32605)
ValuePair(PCS_WGS84_UTM_zone_6N,	32606)
ValuePair(PCS_WGS84_UTM_zone_7N,	32607)
ValuePair(PCS_WGS84_UTM_zone_8N,	32608)
ValuePair(PCS_WGS84_UTM_zone_9N,	32609)
ValuePair(PCS_WGS84_UTM_zone_10N,	32610)
ValuePair(PCS_WGS84_UTM_zone_11N,	32611)
ValuePair(PCS_WGS84_UTM_zone_12N,	32612)
ValuePair(PCS_WGS84_UTM_zone_13N,	32613)
ValuePair(PCS_WGS84_UTM_zone_14N,	32614)
ValuePair(PCS_WGS84_UTM_zone_15N,	32615)
ValuePair(PCS_WGS84_UTM_zone_16N,	32616)
ValuePair(PCS_WGS84_UTM_zone_17N,	32617)
ValuePair(PCS_WGS84_UTM_zone_18N,	32618)
ValuePair(PCS_WGS84_UTM_zone_19N,	32619)
ValuePair(PCS_WGS84_UTM_zone_20N,	32620)
ValuePair(PCS_WGS84_UTM_zone_21N,	32621)
ValuePair(PCS_WGS84_UTM_zone_22N,	32622)
ValuePair(PCS_WGS84_UTM_zone_23N,	32623)
ValuePair(PCS_WGS84_UTM_zone_24N,	32624)
ValuePair(PCS_WGS84_UTM_zone_25N,	32625)
ValuePair(PCS_WGS84_UTM_zone_26N,	32626)
ValuePair(PCS_WGS84_UTM_zone_27N,	32627)
ValuePair(PCS_WGS84_UTM_zone_28N,	32628)
ValuePair(PCS_WGS84_UTM_zone_29N,	32629)
ValuePair(PCS_WGS84_UTM_zone_30N,	32630)
ValuePair(PCS_WGS84_UTM_zone_31N,	32631)
ValuePair(PCS_WGS84_UTM_zone_32N,	32632)
ValuePair(PCS_WGS84_UTM_zone_33N,	32633)
ValuePair(PCS_WGS84_UTM_zone_34N,	32634)
ValuePair(PCS_WGS84_UTM_zone_35N,	32635)
ValuePair(PCS_WGS84_UTM_zone_36N,	32636)
ValuePair(PCS_WGS84_UTM_zone_37N,	32637)
ValuePair(PCS_WGS84_UTM_zone_38N,	32638)
ValuePair(PCS_WGS84_UTM_zone_39N,	32639)
ValuePair(PCS_WGS84_UTM_zone_40N,	32640)
ValuePair(PCS_WGS84_UTM_zone_41N,	32641)
ValuePair(PCS_WGS84_UTM_zone_42N,	32642)
ValuePair(PCS_WGS84_UTM_zone_43N,	32643)
ValuePair(PCS_WGS84_UTM_zone_44N,	32644)
ValuePair(PCS_WGS84_UTM_zone_45N,	32645)
ValuePair(PCS_WGS84_UTM_zone_46N,	32646)
ValuePair(PCS_WGS84_UTM_zone_47N,	32647)
ValuePair(PCS_WGS84_UTM_zone_48N,	32648)
ValuePair(PCS_WGS84_UTM_zone_49N,	32649)
ValuePair(PCS_WGS84_UTM_zone_50N,	32650)
ValuePair(PCS_WGS84_UTM_zone_51N,	32651)
ValuePair(PCS_WGS84_UTM_zone_52N,	32652)
ValuePair(PCS_WGS84_UTM_zone_53N,	32653)
ValuePair(PCS_WGS84_UTM_zone_54N,	32654)
ValuePair(PCS_WGS84_UTM_zone_55N,	32655)
ValuePair(PCS_WGS84_UTM_zone_56N,	32656)
ValuePair(PCS_WGS84_UTM_zone_57N,	32657)
ValuePair(PCS_WGS84_UTM_zone_58N,	32658)
ValuePair(PCS_WGS84_UTM_zone_59N,	32659)
ValuePair(PCS_WGS84_UTM_zone_60N,	32660)
ValuePair(PCS_WGS84_UTM_zone_1S,	32701)
ValuePair(PCS_WGS84_UTM_zone_2S,	32702)
ValuePair(PCS_WGS84_UTM_zone_3S,	32703)
ValuePair(PCS_WGS84_UTM_zone_4S,	32704)
ValuePair(PCS_WGS84_UTM_zone_5S,	32705)
ValuePair(PCS_WGS84_UTM_zone_6S,	32706)
ValuePair(PCS_WGS84_UTM_zone_7S,	32707)
ValuePair(PCS_WGS84_UTM_zone_8S,	32708)
ValuePair(PCS_WGS84_UTM_zone_9S,	32709)
ValuePair(PCS_WGS84_UTM_zone_10S,	32710)
ValuePair(PCS_WGS84_UTM_zone_11S,	32711)
ValuePair(PCS_WGS84_UTM_zone_12S,	32712)
ValuePair(PCS_WGS84_UTM_zone_13S,	32713)
ValuePair(PCS_WGS84_UTM_zone_14S,	32714)
ValuePair(PCS_WGS84_UTM_zone_15S,	32715)
ValuePair(PCS_WGS84_UTM_zone_16S,	32716)
ValuePair(PCS_WGS84_UTM_zone_17S,	32717)
ValuePair(PCS_WGS84_UTM_zone_18S,	32718)
ValuePair(PCS_WGS84_UTM_zone_19S,	32719)
ValuePair(PCS_WGS84_UTM_zone_20S,	32720)
ValuePair(PCS_WGS84_UTM_zone_21S,	32721)
ValuePair(PCS_WGS84_UTM_zone_22S,	32722)
ValuePair(PCS_WGS84_UTM_zone_23S,	32723)
ValuePair(PCS_WGS84_UTM_zone_24S,	32724)
ValuePair(PCS_WGS84_UTM_zone_25S,	32725)
ValuePair(PCS_WGS84_UTM_zone_26S,	32726)
ValuePair(PCS_WGS84_UTM_zone_27S,	32727)
ValuePair(PCS_WGS84_UTM_zone_28S,	32728)
ValuePair(PCS_WGS84_UTM_zone_29S,	32729)
ValuePair(PCS_WGS84_UTM_zone_30S,	32730)
ValuePair(PCS_WGS84_UTM_zone_31S,	32731)
ValuePair(PCS_WGS84_UTM_zone_32S,	32732)
ValuePair(PCS_WGS84_UTM_zone_33S,	32733)
ValuePair(PCS_WGS84_UTM_zone_34S,	32734)
ValuePair(PCS_WGS84_UTM_zone_35S,	32735)
ValuePair(PCS_WGS84_UTM_zone_36S,	32736)
ValuePair(PCS_WGS84_UTM_zone_37S,	32737)
ValuePair(PCS_WGS84_UTM_zone_38S,	32738)
ValuePair(PCS_WGS84_UTM_zone_39S,	32739)
ValuePair(PCS_WGS84_UTM_zone_40S,	32740)
ValuePair(PCS_WGS84_UTM_zone_41S,	32741)
ValuePair(PCS_WGS84_UTM_zone_42S,	32742)
ValuePair(PCS_WGS84_UTM_zone_43S,	32743)
ValuePair(PCS_WGS84_UTM_zone_44S,	32744)
ValuePair(PCS_WGS84_UTM_zone_45S,	32745)
ValuePair(PCS_WGS84_UTM_zone_46S,	32746)
ValuePair(PCS_WGS84_UTM_zone_47S,	32747)
ValuePair(PCS_WGS84_UTM_zone_48S,	32748)
ValuePair(PCS_WGS84_UTM_zone_49S,	32749)
ValuePair(PCS_WGS84_UTM_zone_50S,	32750)
ValuePair(PCS_WGS84_UTM_zone_51S,	32751)
ValuePair(PCS_WGS84_UTM_zone_52S,	32752)
ValuePair(PCS_WGS84_UTM_zone_53S,	32753)
ValuePair(PCS_WGS84_UTM_zone_54S,	32754)
ValuePair(PCS_WGS84_UTM_zone_55S,	32755)
ValuePair(PCS_WGS84_UTM_zone_56S,	32756)
ValuePair(PCS_WGS84_UTM_zone_57S,	32757)
ValuePair(PCS_WGS84_UTM_zone_58S,	32758)
ValuePair(PCS_WGS84_UTM_zone_59S,	32759)
ValuePair(PCS_WGS84_UTM_zone_60S,	32760)
/* end of list */
