# - Config file for the terralib package
# It defines the following variables
#  TE_INCLUDE_DIRS - include directories for FooBar
#  TE_LIBRARIES    - libraries to link against
#  TE_BINARIES 	   - binaries of terralib dependencies
		
# Usage:
#	- In your cmake project use "find_package ( terralib )" command.
# 	- Terralib may also be required with specific modules using "find_package (terralib COMPONENTS shp spl ...) command.
#	- Note that if a module is required and NOT available (was not compiled) an exeception will be raised to cmake.
#
# 	- Components that can be required:
#		- stat (Algorithms for spatial statistics)
#		- shp (Shapefile format support)
#		- dxf (DXF format support)
#		- spl (SPL support for constructing plug-ins)
#		- pdi (Support for image processing algorithms)
#		- dtm (DTM support)
#		- qt3_drivers (Some drivers for qt3 use)
#		- qwt3_drivers (Some drivers for qwt-qt3 use)
 
# Compute paths
get_filename_component(TERRALIB_CMAKE_DIR "${CMAKE_CURRENT_LIST_FILE}" PATH)
if(EXISTS "${TERRALIB_CMAKE_DIR}/CMakeCache.txt")
   # In build tree
   include("${TERRALIB_CMAKE_DIR}/teBuildTreeSettings.cmake")
else()
	set ( TE_DIRS /kernel;/utils;/functions;/dtm;/stat;/drivers/SQLite;/drivers/SQLite/sqlite3;/drivers/libjpeg;/drivers/ado )	
	set ( TE_INCLUDE_DIRS ${TERRALIB_CMAKE_DIR}/../../../include/terralib4)
	set ( TE_BINS  )
	set ( TE_TRANS "" )
	
	foreach( TRANSLATION ${TE_TRANS} )
		STRING ( REGEX REPLACE ".*/" "" FILENAME "${TRANSLATION}")
		list ( APPEND TE_TRANSLATIONS "${TDK_CMAKE_DIR}/../..//translation/${FILENAME}")
	endforeach()	
	foreach( TBIN ${TE_BINS} )
		STRING ( REGEX REPLACE ".*/" "" BIN "${TBIN}")
		list ( APPEND TE_BINARIES "${TERRALIB_CMAKE_DIR}/../..//${BIN}")
	endforeach()	

  set ( TE_INCLUDE_DIRS "${TERRALIB_CMAKE_DIR}/../../../include/terralib4/.." "${TE_INCLUDE_DIRS}")

	foreach( TDIR ${TE_DIRS} )
		list ( APPEND TE_INCLUDE_DIRS "${TERRALIB_CMAKE_DIR}/../../../include/terralib4${TDIR}")
	endforeach()	
	include ( ${TERRALIB_CMAKE_DIR}/CMakeUtils.cmake )	
endif()
 


# Our library dependencies (contains definitions for IMPORTED targets)
include("${TERRALIB_CMAKE_DIR}/teLibraryDepends.cmake")
 
# These are IMPORTED targets created by teLibraryDepends.cmake
set ( TE_LIBRARIES terralib_ado;terralib )

# Modules compiled 
# This code is used to verify the compiled components.
set ( TE_MODULES dtm;stat;SQLite;ado )

IF( terralib_FIND_COMPONENTS )
  FOREACH( comp ${terralib_FIND_COMPONENTS} )
	list ( FIND TE_MODULES ${comp} cmp_found )
    if( cmp_found EQUAL "-1" )
      SET(terralib_${comp}_FOUND 0)
      IF(terralib_FIND_REQUIRED_${comp})
        MESSAGE(FATAL_ERROR "TerraLib ${comp} not available.")
      ENDIF()
    ELSE()
      SET(terralib_${comp}_FOUND 1)
	  MESSAGE("TerraLib module ${comp} available.")
    ENDIF()
  ENDFOREACH()
ENDIF() 

