/*  Copyright (C) 2001-2009 National Institute For Space Research (INPE) - Brazil.

    This file is part of the TerraLib - a Framework for building GIS enabled applications.

    TerraLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License,
    or (at your option) any later version.

    TerraLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with TerraLib. See COPYING. If not, write to
    TerraLib Team at <terralib-team@terralib.org>.
 */

/*!
  \file CommonExamples.h

  \brief A set of module common examples.
*/

#ifndef __TERRALIB_EXAMPLES_COMMON_INTERNAL_COMMONEXAMPLES_H
#define __TERRALIB_EXAMPLES_COMMON_INTERNAL_COMMONEXAMPLES_H

// TerraLib
#include <terralib/common.h>

/*! \brief This example shows TerraLib handles Units of Measure. */
void UOMManage();

/*! \brief This example test how to retrieve a SRS unit of measure. */
void UnitSRS();

/*! \brief This example shows charset conversion. */
void CharEncodingConv();

#endif  // __TERRALIB_EXAMPLES_COMMON_INTERNAL_COMMONEXAMPLES_H
