/*  Copyright (C) 2001-2009 National Institute For Space Research (INPE) - Brazil.

    This file is part of the TerraLib - a Framework for building GIS enabled applications.

    TerraLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License,
    or (at your option) any later version.

    TerraLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with TerraLib. See COPYING. If not, write to
    TerraLib Team at <terralib-team@terralib.org>.
 */

/*!
  \file Globals.cpp
   
  \brief An static class with global definitions.
 */

// TerraLib
#include "Globals.h"

const char* te::fe::Globals::sm_propertyIsEqualTo = "PropertyIsEqualTo";
const char* te::fe::Globals::sm_propertyIsNotEqualTo = "PropertyIsNotEqualTo";
const char* te::fe::Globals::sm_propertyIsLessThan = "PropertyIsLessThan";
const char* te::fe::Globals::sm_propertyIsGreaterThan = "PropertyIsGreaterThan";
const char* te::fe::Globals::sm_propertyIsLessThanOrEqualTo = "PropertyIsLessThanOrEqualTo";
const char* te::fe::Globals::sm_propertyIsGreaterThanOrEqualTo = "PropertyIsGreaterThanOrEqualTo";

const char* te::fe::Globals::sm_propertyIsLike = "PropertyIsLike";
const char* te::fe::Globals::sm_propertyIsNull = "PropertyIsNull";
const char* te::fe::Globals::sm_propertyIsBetween = "PropertyIsBetween";

const char* te::fe::Globals::sm_and = "And";
const char* te::fe::Globals::sm_or = "Or";

const char* te::fe::Globals::sm_not = "Not";

const char* te::fe::Globals::sm_add = "Add";
const char* te::fe::Globals::sm_sub = "Sub";
const char* te::fe::Globals::sm_mul = "Mul";
const char* te::fe::Globals::sm_div = "Div";

const char* te::fe::Globals::sm_bbox = "BBOX";

const char* te::fe::Globals::sm_equals = "Equals";
const char* te::fe::Globals::sm_disjoint = "Disjoint";
const char* te::fe::Globals::sm_touches = "Touches";
const char* te::fe::Globals::sm_within = "Within";
const char* te::fe::Globals::sm_overlaps = "Overlaps";
const char* te::fe::Globals::sm_crosses = "Crosses";
const char* te::fe::Globals::sm_intersects = "Intersects";
const char* te::fe::Globals::sm_contains = "Contains";

const char* te::fe::Globals::sm_dWithin = "DWithin";
const char* te::fe::Globals::sm_beyond = "Beyond";

const char* te::fe::Globals::sm_lessThan = "LessThan";
const char* te::fe::Globals::sm_greaterThan = "GreaterThan";
const char* te::fe::Globals::sm_lessThanEqualTo = "LessThanEqualTo";
const char* te::fe::Globals::sm_greaterThanEqualTo = "GreaterThanEqualTo";
const char* te::fe::Globals::sm_equalTo = "EqualTo";
const char* te::fe::Globals::sm_notEqualTo = "NotEqualTo";
const char* te::fe::Globals::sm_like = "Like";
const char* te::fe::Globals::sm_between = "Between";
const char* te::fe::Globals::sm_nullCheck = "NullCheck";

const char* te::fe::Globals::sm_envelope = "gml:Envelope";
const char* te::fe::Globals::sm_point = "gml:Point";
const char* te::fe::Globals::sm_lineString = "gml:LineString";
const char* te::fe::Globals::sm_polygon = "gml:Polygon";
const char* te::fe::Globals::sm_arcByCenterPoint = "gml:ArcByCenterPoint";
const char* te::fe::Globals::sm_circleByCenterPoint = "gml:CircleByCenterPoint";
const char* te::fe::Globals::sm_arc = "gml:Arc";
const char* te::fe::Globals::sm_circle = "gml:Circle";
const char* te::fe::Globals::sm_arcByBulge = "gml:ArcByBulge";
const char* te::fe::Globals::sm_bezier = "gml:Bezier";
const char* te::fe::Globals::sm_clothoid = "gml:Clothoid";
const char* te::fe::Globals::sm_cubicSpline = "gml:CubicSpline";
const char* te::fe::Globals::sm_geodesic = "gml:Geodesic";
const char* te::fe::Globals::sm_offsetCurve = "gml:OffsetCurve";
const char* te::fe::Globals::sm_triangle = "gml:Triangle";
const char* te::fe::Globals::sm_polyhedralSurface = "gml:PolyhedralSurface";
const char* te::fe::Globals::sm_triangulatedSurface = "gml:TriangulatedSurface";
const char* te::fe::Globals::sm_tin = "gml:Tin";
const char* te::fe::Globals::sm_solid = "gml:Solid";


