/*  Copyright (C) 2001-2009 National Institute For Space Research (INPE) - Brazil.

    This file is part of the TerraLib - a Framework for building GIS enabled applications.

    TerraLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License,
    or (at your option) any later version.

    TerraLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with TerraLib. See COPYING. If not, write to
    TerraLib Team at <terralib-team@terralib.org>.
 */

/*!
  \file terralib/rp/Module.h
   
  \brief This singleton defines the TerraLib Raster Processing module entry.
 */

#ifndef __TERRALIB_RP_INTERNAL_MODULE_H
#define __TERRALIB_RP_INTERNAL_MODULE_H

// TerraLib
#include "Config.h"
#include "../common/Singleton.h"

#include <string>

namespace te
{
  namespace rp
  {
    /*!
      \class Module

      \brief This singleton defines the TerraLib Raster Processing module entry.
     */
    class TERPEXPORT Module : public te::common::Singleton<Module>
    {
      friend class te::common::Singleton<Module>;
      
      public :

        /*!
          \brief Returns the last log string generated by this module.
         */
        static const std::string& getLastLogStr() { return m_lastLogString; };

        /*!
          \brief Set the last log string generated by this module.
         */        
        static void setLastLogStr( const std::string& errorStr ) { m_lastLogString = errorStr; };

      protected:

        /*! \brief The singleton constructor is not callable outside the class. */
        Module();

        /* \brief Destructor. */
        ~Module();

      private:

        /*!
          \brief This is the startup function for the TerraLib Raster Processing module.

          \note This method doesn't perform operations for this module.
         */
        static void initialize();

        /*!
          \brief This is the cleanup function for the TerraLib DataType module.

          \note This method doesn't perform operations for this module.
         */
        static void finalize();

      private:

        static const Module& sm_module; //!< Just to make a static initialization.
        
        static std::string m_lastLogString; //!< The last error string generated by this module.
    };

  } // end namespace rp
}   // end namespace te

#endif  // __TERRALIB_DATATYPE_INTERNAL_MODULE_H

