/*  Copyright (C) 2001-2009 National Institute For Space Research (INPE) - Brazil.

    This file is part of the TerraLib - a Framework for building GIS enabled applications.

    TerraLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License,
    or (at your option) any later version.

    TerraLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with TerraLib. See COPYING. If not, write to
    TerraLib Team at <terralib-team@terralib.org>.
 */

/*!
  \file xlink.h
  
  \brief This file contains include headers for TerraLib XLink module.
 */
#ifndef __TERRALIB_INTERNAL_XLINK_H
#define __TERRALIB_INTERNAL_XLINK_H

// TerraLib
#include "xlink/Config.h"
#include "xlink/Enumerators.h"
#include "xlink/SimpleLink.h"

namespace te
{
  /*!
	  \brief This is the namespace for the XLink module.

    Most of the documentation used in XLink classes were extracted
    from the xlinks.xsd available at: http://schemas.opengis.net/xlink/1.0.0/.
  
    \note See namespace te comments for any detail on using namespaces.
   */
  namespace xl
  {
  } // end namespace xl
}   // end namespace te

#endif  // __TERRALIB_INTERNAL_XLINK_H

