/*  Copyright (C) 2001-2009 National Institute For Space Research (INPE) - Brazil.

    This file is part of the TerraLib - a Framework for building GIS enabled applications.

    TerraLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License,
    or (at your option) any later version.

    TerraLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with TerraLib. See COPYING. If not, write to
    TerraLib Team at <terralib-team@terralib.org>.
 */

/*!
  \file xml.h

  \brief This file contains include headers for TerraLib XML module.
 */

#ifndef __TERRALIB_INTERNAL_XML_H
#define __TERRALIB_INTERNAL_XML_H

// TerraLib
#include "xml/Config.h"
#include "xml/Reader.h"
#include "xml/ReaderFactory.h"

/*!
  \defgroup xml XML

  \brief The XML module implements the main framework for reading and writing XML documents in TerraLib.

  The namespace associated to the XML module is te::xml. To know more about it, see the te::xml namespace documentation.
*/

namespace te
{
  /*!
    \brief Namespace for the XML module of TerraLib.
  */
  namespace xml
  {
  } // end namespace xml
}   // end namespace te

#endif  // __TERRALIB_INTERNAL_XML_H

