/*  Copyright (C) 2001-2009 National Institute For Space Research (INPE) - Brazil.

    This file is part of the TerraLib - a Framework for building GIS enabled applications.

    TerraLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License,
    or (at your option) any later version.

    TerraLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with TerraLib. See COPYING. If not, write to
    TerraLib Team at <terralib-team@terralib.org>.
 */

// Unit-Test TerraLib
#include "TsGTFilter.h"
#include "../Config.h"

// TerraLib
#include <terralib/geometry/GTParameters.h>
#include <terralib/geometry/GTFactory.h>
#include <terralib/geometry/GTFilter.h>

#include <cmath> 

#define testDirectMapping( transfPtr, pt1, pt2, maxError ) \
{ \
  te::gm::Coord2D mappedCoord; \
  transfPtr->directMap( pt1, mappedCoord ); \
  const double diffx = mappedCoord.x - pt2.x; \
  const double diffy = mappedCoord.y - pt2.y; \
  const double error = sqrt( ( diffx * diffx ) + ( diffy * diffy ) ); \
  CPPUNIT_ASSERT_DOUBLES_EQUAL( 0, error, maxError ); \
}

#define testInverseMapping( transfPtr, pt1, pt2, maxError ) \
{ \
  te::gm::Coord2D mappedCoord; \
  transfPtr->inverseMap( pt2, mappedCoord ); \
  const double diffx = mappedCoord.x - pt1.x; \
  const double diffy = mappedCoord.y - pt1.y; \
  const double error = sqrt( ( diffx * diffx ) + ( diffy * diffy ) ); \
  CPPUNIT_ASSERT_DOUBLES_EQUAL( 0, error, maxError ); \
}

CPPUNIT_TEST_SUITE_REGISTRATION( TsGTFilter );

void TsGTFilter::setUp()
{
}

void TsGTFilter::tearDown()
{
}

void  TsGTFilter::generateTestTPSet1( 
  std::vector< te::gm::GTParameters::TiePoint >& tiePoints )
{
  tiePoints.clear();
  
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 277.00, 82.00), te::gm::Coord2D( 372.00, 780.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 597.00, 118.00), te::gm::Coord2D( 558.00, 827.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 361.00, 162.00), te::gm::Coord2D( 363.00, 795.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 594.00, 193.00), te::gm::Coord2D( 429.00, 895.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 326.00, 206.00), te::gm::Coord2D( 440.00, 589.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 403.00, 241.00), te::gm::Coord2D( 328.00, 243.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 408.00, 235.00), te::gm::Coord2D( 411.00, 246.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 529.00, 258.00), te::gm::Coord2D( 529.00, 258.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 238.00, 282.00), te::gm::Coord2D( 238.00, 282.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 249.00, 267.00), te::gm::Coord2D( 249.00, 267.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 306.00, 266.00), te::gm::Coord2D( 306.00, 266.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 352.00, 272.00), te::gm::Coord2D( 352.00, 272.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 393.00, 276.00), te::gm::Coord2D( 393.00, 276.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 451.00, 288.00), te::gm::Coord2D( 451.00, 288.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 479.00, 275.00), te::gm::Coord2D( 479.00, 275.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 503.00, 271.00), te::gm::Coord2D( 503.00, 271.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 548.00, 265.00), te::gm::Coord2D( 548.00, 265.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 587.00, 273.00), te::gm::Coord2D( 587.00, 273.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 632.00, 266.00), te::gm::Coord2D( 632.00, 266.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 236.00, 313.00), te::gm::Coord2D( 236.00, 313.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 285.00, 319.00), te::gm::Coord2D( 285.00, 319.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 414.00, 297.00), te::gm::Coord2D( 414.00, 297.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 462.00, 314.00), te::gm::Coord2D( 462.00, 314.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 511.00, 302.00), te::gm::Coord2D( 511.00, 302.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 529.00, 314.00), te::gm::Coord2D( 529.00, 314.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 557.00, 315.00), te::gm::Coord2D( 557.00, 315.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 603.00, 317.00), te::gm::Coord2D( 603.00, 317.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 645.00, 308.00), te::gm::Coord2D( 645.00, 308.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 298.00, 333.00), te::gm::Coord2D( 298.00, 333.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 364.00, 330.00), te::gm::Coord2D( 364.00, 330.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 380.00, 353.00), te::gm::Coord2D( 380.00, 353.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 431.00, 334.00), te::gm::Coord2D( 431.00, 334.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 486.00, 342.00), te::gm::Coord2D( 486.00, 342.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 502.00, 330.00), te::gm::Coord2D( 502.00, 330.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 524.00, 347.00), te::gm::Coord2D( 524.00, 347.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 556.00, 352.00), te::gm::Coord2D( 556.00, 352.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 626.00, 345.00), te::gm::Coord2D( 625.00, 346.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 657.00, 343.00), te::gm::Coord2D( 657.00, 343.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 274.00, 367.00), te::gm::Coord2D( 274.00, 367.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 371.00, 369.00), te::gm::Coord2D( 371.00, 369.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 410.00, 365.00), te::gm::Coord2D( 410.00, 365.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 467.00, 387.00), te::gm::Coord2D( 467.00, 387.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 644.00, 368.00), te::gm::Coord2D( 644.00, 368.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 231.00, 405.00), te::gm::Coord2D( 231.00, 405.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 251.00, 400.00), te::gm::Coord2D( 251.00, 400.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 277.00, 395.00), te::gm::Coord2D( 277.00, 395.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 305.00, 417.00), te::gm::Coord2D( 305.00, 417.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 373.00, 404.00), te::gm::Coord2D( 373.00, 404.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 382.00, 418.00), te::gm::Coord2D( 382.00, 418.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 426.00, 410.00), te::gm::Coord2D( 426.00, 410.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 492.00, 394.00), te::gm::Coord2D( 492.00, 394.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 577.00, 412.00), te::gm::Coord2D( 577.00, 412.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 605.00, 412.00), te::gm::Coord2D( 605.00, 412.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 53.00, 419.00), te::gm::Coord2D( 259.00, 776.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 458.00, 429.00), te::gm::Coord2D( 458.00, 429.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 476.00, 436.00), te::gm::Coord2D( 513.00, 956.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 496.00, 427.00), te::gm::Coord2D( 496.00, 427.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 540.00, 444.00), te::gm::Coord2D( 540.00, 444.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 551.00, 435.00), te::gm::Coord2D( 551.00, 435.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 620.00, 445.00), te::gm::Coord2D( 620.00, 445.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 635.00, 425.00), te::gm::Coord2D( 635.00, 425.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 96.00, 461.00), te::gm::Coord2D( 429.00, 819.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 116.00, 457.00), te::gm::Coord2D( 392.00, 850.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 267.00, 460.00), te::gm::Coord2D( 267.00, 460.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 308.00, 460.00), te::gm::Coord2D( 308.00, 460.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 336.00, 452.00), te::gm::Coord2D( 336.00, 452.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 398.00, 451.00), te::gm::Coord2D( 398.00, 451.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 413.00, 452.00), te::gm::Coord2D( 413.00, 452.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 458.00, 455.00), te::gm::Coord2D( 458.00, 455.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 533.00, 450.00), te::gm::Coord2D( 346.00, 851.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 302.00, 507.00), te::gm::Coord2D( 302.00, 507.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 334.00, 492.00), te::gm::Coord2D( 334.00, 492.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 419.00, 485.00), te::gm::Coord2D( 419.00, 485.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 440.00, 491.00), te::gm::Coord2D( 440.00, 491.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 499.00, 501.00), te::gm::Coord2D( 499.00, 501.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 554.00, 488.00), te::gm::Coord2D( 554.00, 488.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 581.00, 485.00), te::gm::Coord2D( 581.00, 485.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 623.00, 491.00), te::gm::Coord2D( 623.00, 491.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 216.00, 533.00), te::gm::Coord2D( 216.00, 533.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 340.00, 531.00), te::gm::Coord2D( 340.00, 531.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 372.00, 531.00), te::gm::Coord2D( 372.00, 531.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 445.00, 523.00), te::gm::Coord2D( 445.00, 523.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 569.00, 515.00), te::gm::Coord2D( 569.00, 515.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 618.00, 523.00), te::gm::Coord2D( 618.00, 523.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 642.00, 518.00), te::gm::Coord2D( 617.00, 846.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 187.00, 544.00), te::gm::Coord2D( 736.00, 794.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 242.00, 567.00), te::gm::Coord2D( 242.00, 567.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 336.00, 573.00), te::gm::Coord2D( 336.00, 573.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 376.00, 548.00), te::gm::Coord2D( 376.00, 548.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 486.00, 553.00), te::gm::Coord2D( 486.00, 553.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 493.00, 567.00), te::gm::Coord2D( 493.00, 567.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 541.00, 560.00), te::gm::Coord2D( 541.00, 560.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 558.00, 549.00), te::gm::Coord2D( 558.00, 549.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 631.00, 559.00), te::gm::Coord2D( 631.00, 559.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 233.00, 598.00), te::gm::Coord2D( 233.00, 598.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 277.00, 588.00), te::gm::Coord2D( 277.00, 588.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 311.00, 593.00), te::gm::Coord2D( 311.00, 593.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 371.00, 592.00), te::gm::Coord2D( 371.00, 592.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 383.00, 594.00), te::gm::Coord2D( 383.00, 594.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 411.00, 603.00), te::gm::Coord2D( 411.00, 603.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 475.00, 594.00), te::gm::Coord2D( 475.00, 594.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 546.00, 597.00), te::gm::Coord2D( 546.00, 597.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 612.00, 594.00), te::gm::Coord2D( 612.00, 594.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 642.00, 581.00), te::gm::Coord2D( 642.00, 581.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 90.00, 627.00), te::gm::Coord2D( 468.00, 978.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 109.00, 630.00), te::gm::Coord2D( 414.00, 806.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 242.00, 633.00), te::gm::Coord2D( 242.00, 633.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 288.00, 606.00), te::gm::Coord2D( 288.00, 606.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 312.00, 631.00), te::gm::Coord2D( 312.00, 631.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 335.00, 621.00), te::gm::Coord2D( 335.00, 621.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 366.00, 608.00), te::gm::Coord2D( 366.00, 608.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 411.00, 632.00), te::gm::Coord2D( 411.00, 632.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 480.00, 612.00), te::gm::Coord2D( 480.00, 612.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 496.00, 626.00), te::gm::Coord2D( 496.00, 626.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 532.00, 621.00), te::gm::Coord2D( 532.00, 621.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 585.00, 614.00), te::gm::Coord2D( 585.00, 614.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 627.00, 611.00), te::gm::Coord2D( 627.00, 611.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 262.00, 666.00), te::gm::Coord2D( 262.00, 666.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 275.00, 640.00), te::gm::Coord2D( 275.00, 640.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 311.00, 655.00), te::gm::Coord2D( 394.00, 795.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 335.00, 641.00), te::gm::Coord2D( 573.00, 859.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 366.00, 641.00), te::gm::Coord2D( 366.00, 641.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 398.00, 638.00), te::gm::Coord2D( 398.00, 638.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 541.00, 654.00), te::gm::Coord2D( 541.00, 654.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 593.00, 659.00), te::gm::Coord2D( 592.00, 658.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 613.00, 640.00), te::gm::Coord2D( 613.00, 640.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 44.00, 679.00), te::gm::Coord2D( 664.00, 696.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 228.00, 688.00), te::gm::Coord2D( 228.00, 688.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 266.00, 694.00), te::gm::Coord2D( 266.00, 694.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 293.00, 696.00), te::gm::Coord2D( 293.00, 696.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 322.00, 685.00), te::gm::Coord2D( 322.00, 685.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 374.00, 667.00), te::gm::Coord2D( 374.00, 666.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 422.00, 684.00), te::gm::Coord2D( 422.00, 684.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 457.00, 670.00), te::gm::Coord2D( 457.00, 670.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 490.00, 671.00), te::gm::Coord2D( 490.00, 671.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 562.00, 684.00), te::gm::Coord2D( 562.00, 684.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 587.00, 675.00), te::gm::Coord2D( 587.00, 675.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 623.00, 673.00), te::gm::Coord2D( 623.00, 673.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 651.00, 678.00), te::gm::Coord2D( 651.00, 678.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 221.00, 699.00), te::gm::Coord2D( 221.00, 699.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 288.00, 721.00), te::gm::Coord2D( 242.00, 856.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 343.00, 711.00), te::gm::Coord2D( 343.00, 711.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 434.00, 718.00), te::gm::Coord2D( 434.00, 718.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 508.00, 724.00), te::gm::Coord2D( 508.00, 724.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 523.00, 700.00), te::gm::Coord2D( 523.00, 700.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 565.00, 725.00), te::gm::Coord2D( 565.00, 725.00 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 635.00, 725.00), te::gm::Coord2D( 635.00, 725.00 ) ) );
}

void  TsGTFilter::generateTestTPSet2( 
  std::vector< te::gm::GTParameters::TiePoint >& tiePoints )
{
  tiePoints.clear();
  
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1802, 1310 ), te::gm::Coord2D( 1854, 1783 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4070, 450 ), te::gm::Coord2D( 4067, 775 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 605, 2497 ), te::gm::Coord2D( 715, 3040 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2733, 625 ), te::gm::Coord2D( 2741, 1050 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4584, 2076 ), te::gm::Coord2D( 4731, 2359 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1937, 858 ), te::gm::Coord2D( 1963, 1327 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2594, 2347 ), te::gm::Coord2D( 2706, 2783 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4709, 1468 ), te::gm::Coord2D( 4824, 1818 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2254, 199 ), te::gm::Coord2D( 2239, 659 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3695, 1388 ), te::gm::Coord2D( 3759, 1726 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 26, 1778 ), te::gm::Coord2D( 121, 2356 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 986, 2172 ), te::gm::Coord2D( 680, 2429 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1656, 1977 ), te::gm::Coord2D( 1743, 2455 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3838, 435 ), te::gm::Coord2D( 3834, 785 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2826, 2694 ), te::gm::Coord2D( 2963, 3111 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2155, 158 ), te::gm::Coord2D( 2770, 220 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1722, 1105 ), te::gm::Coord2D( 1761, 1585 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2575, 722 ), te::gm::Coord2D( 2590, 1149 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2575, 513 ), te::gm::Coord2D( 2577, 942 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1457, 2703 ), te::gm::Coord2D( 1579, 3196 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2038, 691 ), te::gm::Coord2D( 2053, 1156 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2081, 1709 ), te::gm::Coord2D( 2154, 2159 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1964, 1041 ), te::gm::Coord2D( 1999, 1505 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3912, 1522 ), te::gm::Coord2D( 3989, 1852 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2236, 206 ), te::gm::Coord2D( 2223, 666 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1633, 1044 ), te::gm::Coord2D( 1670, 1545 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2465, 104 ), te::gm::Coord2D( 2444, 566 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1597, 1826 ), te::gm::Coord2D( 1676, 2305 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3000, 371 ), te::gm::Coord2D( 2993, 772 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1684, 1484 ), te::gm::Coord2D( 1745, 1963 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 309, 857 ), te::gm::Coord2D( 370, 1438 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2892, 77 ), te::gm::Coord2D( 2865, 494 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2125, 1626 ), te::gm::Coord2D( 2192, 2077 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3526, 2707 ), te::gm::Coord2D( 3682, 3085 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3387, 2764 ), te::gm::Coord2D( 3542, 3150 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3985, 2401 ), te::gm::Coord2D( 4133, 2743 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1787, 472 ), te::gm::Coord2D( 1794, 972 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1480, 1776 ), te::gm::Coord2D( 1558, 2264 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1660, 1989 ), te::gm::Coord2D( 1748, 2465 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1783, 1474 ), te::gm::Coord2D( 1843, 1946 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1352, 1377 ), te::gm::Coord2D( 1411, 1880 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2545, 1267 ), te::gm::Coord2D( 2591, 1697 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1336, 1024 ), te::gm::Coord2D( 1377, 1538 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2951, 2268 ), te::gm::Coord2D( 3062, 2677 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1948, 2493 ), te::gm::Coord2D( 2062, 2957 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4494, 2567 ), te::gm::Coord2D( 4685, 2875 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1612, 1693 ), te::gm::Coord2D( 1685, 2174 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2094, 2615 ), te::gm::Coord2D( 2217, 3080 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1159, 1094 ), te::gm::Coord2D( 1206, 1609 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1978, 1203 ), te::gm::Coord2D( 2022, 1665 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2373, 413 ), te::gm::Coord2D( 2371, 867 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2846, 376 ), te::gm::Coord2D( 2303, 25 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2372, 853 ), te::gm::Coord2D( 2394, 1301 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1091, 2241 ), te::gm::Coord2D( 1532, 2935 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1900, 1340 ), te::gm::Coord2D( 1952, 1805 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2353, 858 ), te::gm::Coord2D( 2376, 1307 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1919, 1787 ), te::gm::Coord2D( 1995, 2248 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2430, 1186 ), te::gm::Coord2D( 2472, 1618 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1563, 1751 ), te::gm::Coord2D( 1638, 2234 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 482, 1074 ), te::gm::Coord2D( 544, 1640 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2004, 2466 ), te::gm::Coord2D( 2118, 2926 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4383, 1999 ), te::gm::Coord2D( 4513, 2307 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2215, 2618 ), te::gm::Coord2D( 2339, 3075 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1391, 2426 ), te::gm::Coord2D( 1497, 2919 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2120, 760 ), te::gm::Coord2D( 2139, 1221 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2201, 1441 ), te::gm::Coord2D( 2258, 1887 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1703, 1094 ), te::gm::Coord2D( 1744, 1574 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2524, 348 ), te::gm::Coord2D( 2516, 795 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2048, 680 ), te::gm::Coord2D( 2065, 1142 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1992, 937 ), te::gm::Coord2D( 2022, 1400 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2058, 94 ), te::gm::Coord2D( 2042, 570 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 652, 1951 ), te::gm::Coord2D( 145, 2151 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2374, 1254 ), te::gm::Coord2D( 2420, 1689 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1937, 2574 ), te::gm::Coord2D( 2057, 3039 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1260, 1814 ), te::gm::Coord2D( 1339, 2332 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 504, 600 ), te::gm::Coord2D( 550, 1179 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3743, 1461 ), te::gm::Coord2D( 3812, 1796 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3025, 164 ), te::gm::Coord2D( 3002, 567 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2766, 2621 ), te::gm::Coord2D( 2897, 3045 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 592, 1007 ), te::gm::Coord2D( 648, 1567 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3962, 1234 ), te::gm::Coord2D( 4019, 1553 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3754, 1467 ), te::gm::Coord2D( 3823, 1801 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2044, 519 ), te::gm::Coord2D( 2051, 986 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2197, 1427 ), te::gm::Coord2D( 2253, 1872 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3436, 2646 ), te::gm::Coord2D( 3584, 3025 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1388, 1179 ), te::gm::Coord2D( 1585, 1669 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2458, 1299 ), te::gm::Coord2D( 2507, 1728 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1544, 143 ), te::gm::Coord2D( 1539, 664 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3708, 570 ), te::gm::Coord2D( 3714, 917 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1561, 2455 ), te::gm::Coord2D( 1672, 2941 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1713, 874 ), te::gm::Coord2D( 1741, 1370 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1998, 2746 ), te::gm::Coord2D( 2126, 3213 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1632, 1928 ), te::gm::Coord2D( 1717, 2408 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 375, 1770 ), te::gm::Coord2D( 75, 2113 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2102, 1246 ), te::gm::Coord2D( 2148, 1700 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 358, 1761 ), te::gm::Coord2D( 444, 2315 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1799, 1511 ), te::gm::Coord2D( 1862, 1982 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3692, 539 ), te::gm::Coord2D( 3912, 692 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1972, 1680 ), te::gm::Coord2D( 2042, 2139 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2296, 1151 ), te::gm::Coord2D( 2336, 1593 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1069, 2035 ), te::gm::Coord2D( 1160, 2560 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2440, 1865 ), te::gm::Coord2D( 2522, 2315 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1992, 822 ), te::gm::Coord2D( 2015, 1287 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2072, 2265 ), te::gm::Coord2D( 2175, 2719 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1656, 2303 ), te::gm::Coord2D( 1761, 2780 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3219, 784 ), te::gm::Coord2D( 3238, 1163 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1546, 2373 ), te::gm::Coord2D( 1652, 2856 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2167, 1586 ), te::gm::Coord2D( 2233, 2033 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1716, 2683 ), te::gm::Coord2D( 1839, 3161 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1318, 947 ), te::gm::Coord2D( 1355, 1468 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1709, 895 ), te::gm::Coord2D( 1738, 1391 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1903, 2109 ), te::gm::Coord2D( 1997, 2572 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1908, 105 ), te::gm::Coord2D( 1893, 601 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3987, 1266 ), te::gm::Coord2D( 4046, 1588 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1973, 637 ), te::gm::Coord2D( 1986, 1106 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1102, 996 ), te::gm::Coord2D( 1100, 1475 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3969, 1183 ), te::gm::Coord2D( 4022, 1502 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1229, 99 ), te::gm::Coord2D( 1231, 648 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2089, 698 ), te::gm::Coord2D( 2106, 1158 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1895, 2241 ), te::gm::Coord2D( 1996, 2704 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2133, 1479 ), te::gm::Coord2D( 2193, 1927 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1910, 1835 ), te::gm::Coord2D( 1990, 2295 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2214, 534 ), te::gm::Coord2D( 2219, 989 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2754, 828 ), te::gm::Coord2D( 2775, 1247 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1989, 2233 ), te::gm::Coord2D( 2089, 2690 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1810, 1502 ), te::gm::Coord2D( 1871, 1971 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1548, 278 ), te::gm::Coord2D( 1550, 794 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1621, 1636 ), te::gm::Coord2D( 1691, 2116 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3463, 807 ), te::gm::Coord2D( 3484, 1174 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4249, 2360 ), te::gm::Coord2D( 4405, 2687 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1607, 929 ), te::gm::Coord2D( 1640, 1420 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3399, 1715 ), te::gm::Coord2D( 3481, 2088 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2215, 376 ), te::gm::Coord2D( 2211, 832 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2094, 63 ), te::gm::Coord2D( 2075, 537 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2790, 2433 ), te::gm::Coord2D( 2909, 2855 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1661, 265 ), te::gm::Coord2D( 1659, 774 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1980, 2570 ), te::gm::Coord2D( 2099, 3035 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1550, 1678 ), te::gm::Coord2D( 1621, 2161 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2060, 1301 ), te::gm::Coord2D( 2109, 1756 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1647, 1913 ), te::gm::Coord2D( 1730, 2391 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2473, 1275 ), te::gm::Coord2D( 2520, 1704 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1323, 1313 ), te::gm::Coord2D( 1377, 1814 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2949, 486 ), te::gm::Coord2D( 2949, 888 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3450, 1352 ), te::gm::Coord2D( 3508, 1719 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 460, 1835 ), te::gm::Coord2D( 549, 2383 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2200, 1452 ), te::gm::Coord2D( 2258, 1897 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2517, 1431 ), te::gm::Coord2D( 2573, 1856 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3038, 394 ), te::gm::Coord2D( 3032, 790 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2232, 193 ), te::gm::Coord2D( 2218, 654 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2597, 2305 ), te::gm::Coord2D( 2706, 2741 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1854, 1087 ), te::gm::Coord2D( 1893, 1558 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1772, 2107 ), te::gm::Coord2D( 1864, 2576 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1620, 1184 ), te::gm::Coord2D( 1665, 1674 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 416, 888 ), te::gm::Coord2D( 474, 1464 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2256, 2629 ), te::gm::Coord2D( 2380, 3083 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1647, 1954 ), te::gm::Coord2D( 1732, 2434 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1876, 2303 ), te::gm::Coord2D( 1980, 2767 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 318, 1173 ), te::gm::Coord2D( 388, 1746 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2275, 1466 ), te::gm::Coord2D( 2333, 1905 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4415, 1875 ), te::gm::Coord2D( 4534, 2172 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1583, 1824 ), te::gm::Coord2D( 1662, 2304 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1332, 1332 ), te::gm::Coord2D( 1387, 1833 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 945, 855 ), te::gm::Coord2D( 985, 1389 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3484, 2544 ), te::gm::Coord2D( 3627, 2923 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1144, 23 ), te::gm::Coord2D( 1146, 579 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3225, 755 ), te::gm::Coord2D( 3243, 1133 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1959, 666 ), te::gm::Coord2D( 1971, 1133 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2766, 893 ), te::gm::Coord2D( 2791, 1304 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1651, 2264 ), te::gm::Coord2D( 1751, 2742 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 447, 1100 ), te::gm::Coord2D( 513, 1670 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1898, 2428 ), te::gm::Coord2D( 2009, 2894 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1640, 1991 ), te::gm::Coord2D( 1728, 2470 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1238, 1085 ), te::gm::Coord2D( 1284, 1606 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1874, 2072 ), te::gm::Coord2D( 1966, 2535 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1796, 2552 ), te::gm::Coord2D( 1913, 3024 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2171, 1402 ), te::gm::Coord2D( 2226, 1849 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3239, 88 ), te::gm::Coord2D( 3211, 482 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1964, 2483 ), te::gm::Coord2D( 2079, 2946 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3310, 2804 ), te::gm::Coord2D( 3466, 3202 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2898, 984 ), te::gm::Coord2D( 2929, 1384 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1996, 1257 ), te::gm::Coord2D( 2043, 1717 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1608, 1965 ), te::gm::Coord2D( 1695, 2446 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 691, 1976 ), te::gm::Coord2D( 783, 2510 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2047, 1733 ), te::gm::Coord2D( 2122, 2186 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3140, 101 ), te::gm::Coord2D( 3113, 502 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1313, 1199 ), te::gm::Coord2D( 1362, 1706 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1228, 679 ), te::gm::Coord2D( 1254, 1204 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2155, 1365 ), te::gm::Coord2D( 2207, 1814 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3963, 1253 ), te::gm::Coord2D( 4019, 1573 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1918, 2492 ), te::gm::Coord2D( 2032, 2956 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1386, 1425 ), te::gm::Coord2D( 1447, 1922 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2444, 1300 ), te::gm::Coord2D( 2492, 1730 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3999, 1149 ), te::gm::Coord2D( 4050, 1471 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1239, 1386 ), te::gm::Coord2D( 1299, 1898 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2272, 2628 ), te::gm::Coord2D( 2397, 3081 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2253, 1867 ), te::gm::Coord2D( 2334, 2319 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3834, 1416 ), te::gm::Coord2D( 3900, 1754 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1856, 1435 ), te::gm::Coord2D( 1913, 1902 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2305, 265 ), te::gm::Coord2D( 2295, 718 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2104, 1501 ), te::gm::Coord2D( 2165, 1952 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2459, 2489 ), te::gm::Coord2D( 2577, 2925 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3064, 1176 ), te::gm::Coord2D( 3107, 1563 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1616, 2535 ), te::gm::Coord2D( 1731, 3020 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3260, 1341 ), te::gm::Coord2D( 3316, 1712 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1848, 2191 ), te::gm::Coord2D( 1947, 2656 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4447, 1944 ), te::gm::Coord2D( 4574, 2234 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1315, 1278 ), te::gm::Coord2D( 1368, 1780 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2205, 2461 ), te::gm::Coord2D( 2319, 2917 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1038, 928 ), te::gm::Coord2D( 1079, 1451 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3518, 888 ), te::gm::Coord2D( 3544, 1248 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2132, 775 ), te::gm::Coord2D( 2152, 1231 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1600, 2409 ), te::gm::Coord2D( 1708, 2889 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3479, 891 ), te::gm::Coord2D( 3506, 1263 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1468, 2281 ), te::gm::Coord2D( 1569, 2769 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 343, 1030 ), te::gm::Coord2D( 408, 1604 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2781, 886 ), te::gm::Coord2D( 2805, 1296 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3473, 853 ), te::gm::Coord2D( 3497, 1218 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1146, 797 ), te::gm::Coord2D( 1180, 1324 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2032, 1825 ), te::gm::Coord2D( 2111, 2285 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2394, 1158 ), te::gm::Coord2D( 2434, 1592 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2272, 812 ), te::gm::Coord2D( 2292, 1268 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3155, 775 ), te::gm::Coord2D( 3173, 1164 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2446, 1419 ), te::gm::Coord2D( 2503, 1849 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2230, 2668 ), te::gm::Coord2D( 2357, 3123 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3162, 1919 ), te::gm::Coord2D( 3254, 2301 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3938, 1171 ), te::gm::Coord2D( 3990, 1491 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3372, 115 ), te::gm::Coord2D( 3345, 500 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1750, 1610 ), te::gm::Coord2D( 1816, 2082 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2392, 345 ), te::gm::Coord2D( 2386, 793 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1778, 2145 ), te::gm::Coord2D( 1874, 2612 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1293, 1329 ), te::gm::Coord2D( 1349, 1832 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3033, 364 ), te::gm::Coord2D( 3024, 762 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2514, 2546 ), te::gm::Coord2D( 2637, 2980 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2094, 2292 ), te::gm::Coord2D( 2198, 2746 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2113, 2735 ), te::gm::Coord2D( 2242, 3193 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1455, 973 ), te::gm::Coord2D( 1491, 1482 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3695, 997 ), te::gm::Coord2D( 3731, 1349 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2784, 799 ), te::gm::Coord2D( 2803, 1209 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2155, 1323 ), te::gm::Coord2D( 2205, 1773 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1620, 2320 ), te::gm::Coord2D( 1724, 2798 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2219, 1504 ), te::gm::Coord2D( 2280, 1949 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3305, 1446 ), te::gm::Coord2D( 3369, 1816 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1591, 2500 ), te::gm::Coord2D( 1704, 2987 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4692, 1536 ), te::gm::Coord2D( 4792, 1806 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 481, 637 ), te::gm::Coord2D( 529, 1216 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1823, 2259 ), te::gm::Coord2D( 1925, 2726 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1615, 2189 ), te::gm::Coord2D( 1713, 2669 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 848, 1983 ), te::gm::Coord2D( 939, 2507 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 882, 2096 ), te::gm::Coord2D( 220, 2206 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 853, 2078 ), te::gm::Coord2D( 515, 2364 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 513, 1081 ), te::gm::Coord2D( 575, 1645 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1648, 2431 ), te::gm::Coord2D( 1759, 2910 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2497, 477 ), te::gm::Coord2D( 2497, 912 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1333, 1350 ), te::gm::Coord2D( 1389, 1850 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2024, 1266 ), te::gm::Coord2D( 2072, 1724 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1939, 890 ), te::gm::Coord2D( 1967, 1358 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1858, 1634 ), te::gm::Coord2D( 1926, 2099 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2465, 2569 ), te::gm::Coord2D( 2588, 3005 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2080, 1727 ), te::gm::Coord2D( 2153, 2177 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1994, 1678 ), te::gm::Coord2D( 2064, 2134 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1666, 1972 ), te::gm::Coord2D( 1753, 2448 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2996, 206 ), te::gm::Coord2D( 2977, 608 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1747, 471 ), te::gm::Coord2D( 1754, 974 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2262, 1290 ), te::gm::Coord2D( 2310, 1733 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3034, 1958 ), te::gm::Coord2D( 3126, 2361 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2098, 815 ), te::gm::Coord2D( 2121, 1272 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1703, 2250 ), te::gm::Coord2D( 1804, 2724 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1794, 1042 ), te::gm::Coord2D( 1831, 1518 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1843, 1826 ), te::gm::Coord2D( 1921, 2292 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1726, 2564 ), te::gm::Coord2D( 1844, 3042 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2420, 1861 ), te::gm::Coord2D( 2501, 2313 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3208, 302 ), te::gm::Coord2D( 3195, 699 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 319, 1753 ), te::gm::Coord2D( 408, 2311 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1083, 2165 ), te::gm::Coord2D( 1180, 2681 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3548, 637 ), te::gm::Coord2D( 3558, 997 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1962, 2498 ), te::gm::Coord2D( 2078, 2962 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 530, 1859 ), te::gm::Coord2D( 620, 2404 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 81, 1483 ), te::gm::Coord2D( 167, 2064 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2265, 193 ), te::gm::Coord2D( 2251, 651 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1817, 1667 ), te::gm::Coord2D( 1887, 2135 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2025, 1689 ), te::gm::Coord2D( 2097, 2143 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1608, 2278 ), te::gm::Coord2D( 1709, 2758 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3061, 402 ), te::gm::Coord2D( 3054, 797 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2034, 2352 ), te::gm::Coord2D( 2142, 2808 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 860, 1952 ), te::gm::Coord2D( 950, 2481 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2167, 2733 ), te::gm::Coord2D( 2297, 3189 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2020, 1380 ), te::gm::Coord2D( 2074, 1837 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1923, 2314 ), te::gm::Coord2D( 2028, 2776 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3176, 1385 ), te::gm::Coord2D( 3233, 1764 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2156, 1451 ), te::gm::Coord2D( 2213, 1899 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4453, 1881 ), te::gm::Coord2D( 4576, 2174 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1849, 2581 ), te::gm::Coord2D( 1968, 3051 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1912, 2022 ), te::gm::Coord2D( 2001, 2483 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2962, 969 ), te::gm::Coord2D( 2994, 1371 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 89, 422 ), te::gm::Coord2D( 154, 1045 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2250, 2511 ), te::gm::Coord2D( 2368, 2964 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3711, 1433 ), te::gm::Coord2D( 3780, 1770 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1714, 2250 ), te::gm::Coord2D( 1815, 2722 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2004, 2371 ), te::gm::Coord2D( 2112, 2830 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1677, 2255 ), te::gm::Coord2D( 1778, 2730 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3815, 2729 ), te::gm::Coord2D( 3984, 3092 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2203, 634 ), te::gm::Coord2D( 2215, 1086 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2010, 885 ), te::gm::Coord2D( 2037, 1349 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2614, 693 ), te::gm::Coord2D( 2627, 1119 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2385, 855 ), te::gm::Coord2D( 2408, 1302 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2349, 330 ), te::gm::Coord2D( 2343, 779 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2967, 177 ), te::gm::Coord2D( 2947, 582 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1822, 2231 ), te::gm::Coord2D( 1922, 2698 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2533, 233 ), te::gm::Coord2D( 2511, 155 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3992, 2410 ), te::gm::Coord2D( 4141, 2752 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3071, 343 ), te::gm::Coord2D( 3061, 739 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2217, 1439 ), te::gm::Coord2D( 2273, 1883 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3213, 2151 ), te::gm::Coord2D( 3321, 2541 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3632, 2641 ), te::gm::Coord2D( 3786, 3013 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3944, 1019 ), te::gm::Coord2D( 3984, 1355 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2281, 1296 ), te::gm::Coord2D( 2330, 1737 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4065, 1241 ), te::gm::Coord2D( 4124, 1553 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2081, 833 ), te::gm::Coord2D( 2104, 1292 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 28, 326 ), te::gm::Coord2D( 96, 947 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4436, 2082 ), te::gm::Coord2D( 4577, 2383 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2279, 689 ), te::gm::Coord2D( 2293, 1135 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1839, 2147 ), te::gm::Coord2D( 1935, 2613 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2111, 2293 ), te::gm::Coord2D( 2217, 2745 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1820, 2171 ), te::gm::Coord2D( 1917, 2638 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2784, 786 ), te::gm::Coord2D( 2803, 1196 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3369, 132 ), te::gm::Coord2D( 3343, 516 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1636, 2410 ), te::gm::Coord2D( 1745, 2888 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1588, 2332 ), te::gm::Coord2D( 1694, 2813 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3375, 2617 ), te::gm::Coord2D( 3519, 3006 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3394, 997 ), te::gm::Coord2D( 3461, 1172 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2555, 225 ), te::gm::Coord2D( 2540, 666 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2974, 359 ), te::gm::Coord2D( 2965, 760 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1396, 2318 ), te::gm::Coord2D( 1500, 2809 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1684, 2290 ), te::gm::Coord2D( 1786, 2766 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 543, 656 ), te::gm::Coord2D( 589, 1234 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1875, 1595 ), te::gm::Coord2D( 1957, 1419 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1138, 1233 ), te::gm::Coord2D( 1193, 1751 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4407, 1994 ), te::gm::Coord2D( 4536, 2292 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2645, 440 ), te::gm::Coord2D( 2492, 78 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3682, 1069 ), te::gm::Coord2D( 3723, 1426 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1912, 2105 ), te::gm::Coord2D( 2006, 2567 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2409, 1389 ), te::gm::Coord2D( 2464, 1822 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1766, 1495 ), te::gm::Coord2D( 1826, 1967 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1840, 1977 ), te::gm::Coord2D( 1928, 2442 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1824, 1068 ), te::gm::Coord2D( 1862, 1541 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2493, 971 ), te::gm::Coord2D( 2522, 1401 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1226, 70 ), te::gm::Coord2D( 1227, 621 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1960, 2261 ), te::gm::Coord2D( 2062, 2720 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1039, 955 ), te::gm::Coord2D( 1082, 1480 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1973, 2257 ), te::gm::Coord2D( 2076, 2716 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2242, 119 ), te::gm::Coord2D( 2224, 586 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2095, 29 ), te::gm::Coord2D( 2074, 505 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3291, 945 ), te::gm::Coord2D( 3321, 1327 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1899, 1862 ), te::gm::Coord2D( 1979, 2324 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 471, 1825 ), te::gm::Coord2D( 560, 2373 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1607, 2365 ), te::gm::Coord2D( 1713, 2845 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2265, 2580 ), te::gm::Coord2D( 2387, 3032 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 191, 1177 ), te::gm::Coord2D( 267, 1753 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4346, 1975 ), te::gm::Coord2D( 4474, 2281 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2188, 1445 ), te::gm::Coord2D( 2245, 1891 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2588, 808 ), te::gm::Coord2D( 2607, 1245 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1979, 2214 ), te::gm::Coord2D( 2078, 2672 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1554, 2403 ), te::gm::Coord2D( 1663, 2886 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 272, 896 ), te::gm::Coord2D( 337, 1482 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3578, 913 ), te::gm::Coord2D( 3608, 1267 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4742, 1520 ), te::gm::Coord2D( 4843, 1790 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3154, 1256 ), te::gm::Coord2D( 3202, 1637 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3361, 2622 ), te::gm::Coord2D( 3568, 3187 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4090, 1597 ), te::gm::Coord2D( 4176, 1918 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1359, 2514 ), te::gm::Coord2D( 1473, 3013 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1765, 2588 ), te::gm::Coord2D( 1884, 3064 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2057, 1728 ), te::gm::Coord2D( 2131, 2181 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2139, 2754 ), te::gm::Coord2D( 2270, 3211 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1659, 1892 ), te::gm::Coord2D( 1742, 2369 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1601, 2309 ), te::gm::Coord2D( 1705, 2789 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2530, 507 ), te::gm::Coord2D( 2532, 939 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3320, 1406 ), te::gm::Coord2D( 3381, 1780 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2968, 2376 ), te::gm::Coord2D( 3086, 2790 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1440, 2346 ), te::gm::Coord2D( 1545, 2835 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1866, 1932 ), te::gm::Coord2D( 1950, 2395 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2094, 1438 ), te::gm::Coord2D( 2151, 1891 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3412, 2791 ), te::gm::Coord2D( 3751, 3121 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1922, 1273 ), te::gm::Coord2D( 1970, 1738 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1701, 2240 ), te::gm::Coord2D( 1802, 2713 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4681, 1528 ), te::gm::Coord2D( 4778, 1803 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1238, 1399 ), te::gm::Coord2D( 1298, 1910 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2184, 2190 ), te::gm::Coord2D( 2283, 2636 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 544, 1854 ), te::gm::Coord2D( 633, 2397 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1986, 679 ), te::gm::Coord2D( 2002, 1146 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1905, 2523 ), te::gm::Coord2D( 2021, 2990 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2644, 428 ), te::gm::Coord2D( 2873, 946 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3004, 338 ), te::gm::Coord2D( 2994, 740 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2289, 2766 ), te::gm::Coord2D( 2422, 3226 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 461, 1620 ), te::gm::Coord2D( 543, 2180 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2300, 2761 ), te::gm::Coord2D( 2432, 3221 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1647, 2313 ), te::gm::Coord2D( 1751, 2790 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1647, 1835 ), te::gm::Coord2D( 1727, 2313 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 637, 2130 ), te::gm::Coord2D( 735, 2674 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2164, 103 ), te::gm::Coord2D( 2145, 572 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3213, 433 ), te::gm::Coord2D( 3209, 824 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1978, 2559 ), te::gm::Coord2D( 2096, 3023 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1917, 1743 ), te::gm::Coord2D( 1991, 2204 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3936, 1186 ), te::gm::Coord2D( 3989, 1508 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1322, 719 ), te::gm::Coord2D( 1349, 1239 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4462, 1930 ), te::gm::Coord2D( 4588, 2218 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2828, 897 ), te::gm::Coord2D( 2853, 1302 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1671, 2245 ), te::gm::Coord2D( 1772, 2720 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1877, 2092 ), te::gm::Coord2D( 1971, 2556 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2489, 2558 ), te::gm::Coord2D( 2612, 2992 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1630, 1813 ), te::gm::Coord2D( 1708, 2292 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1657, 2005 ), te::gm::Coord2D( 1745, 2483 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2962, 640 ), te::gm::Coord2D( 2971, 1053 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1411, 2429 ), te::gm::Coord2D( 1520, 2921 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3237, 595 ), te::gm::Coord2D( 3243, 984 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3426, 81 ), te::gm::Coord2D( 3396, 468 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1166, 56 ), te::gm::Coord2D( 1169, 606 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2546, 1773 ), te::gm::Coord2D( 2623, 2221 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2167, 126 ), te::gm::Coord2D( 2151, 593 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3230, 719 ), te::gm::Coord2D( 3245, 1097 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4643, 2207 ), te::gm::Coord2D( 4806, 2502 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2695, 488 ), te::gm::Coord2D( 2696, 909 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3356, 407 ), te::gm::Coord2D( 3349, 792 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2464, 831 ), te::gm::Coord2D( 2485, 1272 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1803, 591 ), te::gm::Coord2D( 1815, 1087 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1221, 112 ), te::gm::Coord2D( 1224, 661 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2061, 2252 ), te::gm::Coord2D( 2164, 2707 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2182, 1602 ), te::gm::Coord2D( 2248, 2049 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1464, 2471 ), te::gm::Coord2D( 1575, 2960 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3442, 2792 ), te::gm::Coord2D( 3603, 3178 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2997, 176 ), te::gm::Coord2D( 2977, 581 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2070, 2327 ), te::gm::Coord2D( 2176, 2781 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1857, 965 ), te::gm::Coord2D( 1889, 1437 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2090, 1052 ), te::gm::Coord2D( 2125, 1508 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2414, 1055 ), te::gm::Coord2D( 2449, 1489 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2002, 1216 ), te::gm::Coord2D( 2046, 1676 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1627, 1160 ), te::gm::Coord2D( 1671, 1648 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3020, 1102 ), te::gm::Coord2D( 3059, 1494 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3553, 873 ), te::gm::Coord2D( 3580, 1231 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1670, 1936 ), te::gm::Coord2D( 1754, 2413 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2481, 1272 ), te::gm::Coord2D( 2529, 1699 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1713, 2159 ), te::gm::Coord2D( 1809, 2633 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 960, 860 ), te::gm::Coord2D( 1001, 1392 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2230, 925 ), te::gm::Coord2D( 2258, 1372 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3071, 388 ), te::gm::Coord2D( 3063, 784 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3689, 2226 ), te::gm::Coord2D( 3812, 2578 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1887, 1825 ), te::gm::Coord2D( 1966, 2287 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1568, 188 ), te::gm::Coord2D( 1565, 707 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2268, 213 ), te::gm::Coord2D( 2255, 671 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2199, 1543 ), te::gm::Coord2D( 2262, 1989 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1684, 2558 ), te::gm::Coord2D( 1800, 3039 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2012, 89 ), te::gm::Coord2D( 1996, 569 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1038, 904 ), te::gm::Coord2D( 1079, 1429 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1882, 1899 ), te::gm::Coord2D( 1965, 2362 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3602, 2150 ), te::gm::Coord2D( 3717, 2506 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3659, 2649 ), te::gm::Coord2D( 3815, 3020 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 329, 555 ), te::gm::Coord2D( 381, 1149 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2536, 2926 ), te::gm::Coord2D( 2167, 2637 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2450, 1409 ), te::gm::Coord2D( 2506, 1839 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2138, 1612 ), te::gm::Coord2D( 2204, 2061 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2396, 847 ), te::gm::Coord2D( 2418, 1293 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1477, 1278 ), te::gm::Coord2D( 1528, 1779 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2025, 2198 ), te::gm::Coord2D( 2124, 2652 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2609, 2314 ), te::gm::Coord2D( 2719, 2749 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 302, 1171 ), te::gm::Coord2D( 372, 1749 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3021, 230 ), te::gm::Coord2D( 3004, 631 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2727, 794 ), te::gm::Coord2D( 2753, 1129 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1651, 1925 ), te::gm::Coord2D( 1735, 2402 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1744, 2087 ), te::gm::Coord2D( 1837, 2558 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1241, 141 ), te::gm::Coord2D( 1244, 689 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 23, 338 ), te::gm::Coord2D( 92, 959 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3988, 1196 ), te::gm::Coord2D( 4042, 1513 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3344, 785 ), te::gm::Coord2D( 3363, 1161 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 203, 969 ), te::gm::Coord2D( 272, 1557 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2016, 2737 ), te::gm::Coord2D( 2143, 3199 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2108, 313 ), te::gm::Coord2D( 2102, 791 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1896, 2141 ), te::gm::Coord2D( 1991, 2604 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1948, 2519 ), te::gm::Coord2D( 2064, 2984 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3463, 1353 ), te::gm::Coord2D( 3521, 1721 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2477, 1049 ), te::gm::Coord2D( 2511, 1479 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1621, 2481 ), te::gm::Coord2D( 1734, 2961 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3122, 2765 ), te::gm::Coord2D( 3271, 3172 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2205, 302 ), te::gm::Coord2D( 1737, 407 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1802, 986 ), te::gm::Coord2D( 1835, 1462 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1805, 2148 ), te::gm::Coord2D( 1900, 2615 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1420, 1175 ), te::gm::Coord2D( 1467, 1677 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2027, 562 ), te::gm::Coord2D( 2036, 1029 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4431, 2093 ), te::gm::Coord2D( 4572, 2394 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2317, 1150 ), te::gm::Coord2D( 2357, 1589 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3199, 439 ), te::gm::Coord2D( 3195, 832 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1942, 2358 ), te::gm::Coord2D( 2049, 2821 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2913, 921 ), te::gm::Coord2D( 2472, 960 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2230, 177 ), te::gm::Coord2D( 2215, 638 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1979, 2458 ), te::gm::Coord2D( 2092, 2919 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2410, 804 ), te::gm::Coord2D( 2429, 1248 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4021, 1183 ), te::gm::Coord2D( 4074, 1499 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2537, 2539 ), te::gm::Coord2D( 2660, 2971 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2140, 508 ), te::gm::Coord2D( 2144, 969 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2021, 1716 ), te::gm::Coord2D( 2093, 2172 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2717, 766 ), te::gm::Coord2D( 2734, 1180 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1905, 1779 ), te::gm::Coord2D( 1981, 2241 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3986, 2549 ), te::gm::Coord2D( 4146, 2886 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2585, 1332 ), te::gm::Coord2D( 2636, 1761 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2806, 969 ), te::gm::Coord2D( 2835, 1377 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3416, 1709 ), te::gm::Coord2D( 3497, 2081 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1670, 2009 ), te::gm::Coord2D( 1759, 2486 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1916, 1751 ), te::gm::Coord2D( 1990, 2212 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3446, 2558 ), te::gm::Coord2D( 3589, 2939 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1126, 50 ), te::gm::Coord2D( 1130, 603 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3282, 2680 ), te::gm::Coord2D( 3430, 3071 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4116, 1320 ), te::gm::Coord2D( 4181, 1628 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3316, 65 ), te::gm::Coord2D( 3285, 456 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 358, 1150 ), te::gm::Coord2D( 426, 1722 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2497, 1320 ), te::gm::Coord2D( 2547, 1746 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4730, 1456 ), te::gm::Coord2D( 4824, 1728 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 136, 2169 ), te::gm::Coord2D( 239, 2740 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2468, 1087 ), te::gm::Coord2D( 2504, 1516 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3925, 1140 ), te::gm::Coord2D( 3972, 1473 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2127, 616 ), te::gm::Coord2D( 2136, 1077 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1593, 1276 ), te::gm::Coord2D( 1644, 1768 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1960, 432 ), te::gm::Coord2D( 1963, 907 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3191, 276 ), te::gm::Coord2D( 3175, 674 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2058, 1356 ), te::gm::Coord2D( 2111, 1811 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1577, 2299 ), te::gm::Coord2D( 1681, 2780 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2131, 1637 ), te::gm::Coord2D( 2198, 2086 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2834, 514 ), te::gm::Coord2D( 2835, 929 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1680, 626 ), te::gm::Coord2D( 1696, 1129 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1949, 2385 ), te::gm::Coord2D( 2058, 2848 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2314, 2474 ), te::gm::Coord2D( 2430, 2925 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2074, 1683 ), te::gm::Coord2D( 2145, 2134 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1740, 637 ), te::gm::Coord2D( 1756, 1140 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3353, 2783 ), te::gm::Coord2D( 3508, 3173 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2972, 1604 ), te::gm::Coord2D( 3042, 1997 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2019, 2286 ), te::gm::Coord2D( 2123, 2743 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1611, 1162 ), te::gm::Coord2D( 1655, 1652 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3490, 2695 ), te::gm::Coord2D( 3645, 3074 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3287, 2693 ), te::gm::Coord2D( 3434, 3085 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1908, 1724 ), te::gm::Coord2D( 1981, 2185 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3038, 354 ), te::gm::Coord2D( 3028, 752 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2034, 2226 ), te::gm::Coord2D( 2134, 2682 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2230, 476 ), te::gm::Coord2D( 2232, 931 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3350, 1637 ), te::gm::Coord2D( 3426, 2009 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1934, 656 ), te::gm::Coord2D( 1949, 1129 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1655, 2322 ), te::gm::Coord2D( 1760, 2800 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3810, 1419 ), te::gm::Coord2D( 3878, 1756 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1852, 1847 ), te::gm::Coord2D( 1932, 2311 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2255, 223 ), te::gm::Coord2D( 2243, 682 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4178, 1047 ), te::gm::Coord2D( 4224, 1359 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2031, 2132 ), te::gm::Coord2D( 2126, 2587 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1827, 2185 ), te::gm::Coord2D( 1925, 2652 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1924, 2119 ), te::gm::Coord2D( 2019, 2580 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2248, 1447 ), te::gm::Coord2D( 2305, 1888 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4071, 1200 ), te::gm::Coord2D( 4127, 1511 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1647, 2016 ), te::gm::Coord2D( 1736, 2495 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3186, 2631 ), te::gm::Coord2D( 3327, 3020 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 191, 1128 ), te::gm::Coord2D( 266, 1706 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2088, 2333 ), te::gm::Coord2D( 2195, 2786 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2290, 297 ), te::gm::Coord2D( 2282, 750 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1678, 1926 ), te::gm::Coord2D( 1762, 2402 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2371, 1376 ), te::gm::Coord2D( 2425, 1810 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1723, 2509 ), te::gm::Coord2D( 1837, 2984 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2466, 508 ), te::gm::Coord2D( 2641, 863 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2849, 676 ), te::gm::Coord2D( 2860, 1092 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4086, 1240 ), te::gm::Coord2D( 4144, 1550 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1314, 904 ), te::gm::Coord2D( 1349, 1422 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4630, 2192 ), te::gm::Coord2D( 4791, 2489 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 693, 1987 ), te::gm::Coord2D( 787, 2521 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2963, 2010 ), te::gm::Coord2D( 3058, 2421 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1855, 2030 ), te::gm::Coord2D( 1945, 2494 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2212, 358 ), te::gm::Coord2D( 2207, 815 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1948, 2581 ), te::gm::Coord2D( 2067, 3047 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3424, 2645 ), te::gm::Coord2D( 3572, 3025 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1824, 2241 ), te::gm::Coord2D( 1925, 2707 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2318, 2047 ), te::gm::Coord2D( 2410, 2491 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4283, 2028 ), te::gm::Coord2D( 4410, 2335 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3456, 889 ), te::gm::Coord2D( 3482, 1260 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1869, 1687 ), te::gm::Coord2D( 1940, 2152 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2134, 970 ), te::gm::Coord2D( 2165, 1424 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2706, 1486 ), te::gm::Coord2D( 2766, 1912 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1946, 2510 ), te::gm::Coord2D( 2061, 2974 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1632, 2165 ), te::gm::Coord2D( 1728, 2645 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1812, 2621 ), te::gm::Coord2D( 1932, 3098 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2305, 2653 ), te::gm::Coord2D( 2432, 3103 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3556, 2728 ), te::gm::Coord2D( 3715, 3103 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3240, 712 ), te::gm::Coord2D( 3254, 1089 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1677, 2273 ), te::gm::Coord2D( 1780, 2749 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2754, 1871 ), te::gm::Coord2D( 2838, 2291 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2912, 395 ), te::gm::Coord2D( 2906, 806 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2059, 599 ), te::gm::Coord2D( 2070, 1064 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1644, 1945 ), te::gm::Coord2D( 1729, 2424 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4446, 445 ), te::gm::Coord2D( 4444, 753 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3050, 1620 ), te::gm::Coord2D( 3121, 2007 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2198, 1108 ), te::gm::Coord2D( 2236, 1556 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1864, 164 ), te::gm::Coord2D( 1853, 662 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 275, 1025 ), te::gm::Coord2D( 343, 1606 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3014, 131 ), te::gm::Coord2D( 2990, 536 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1842, 2209 ), te::gm::Coord2D( 1941, 2674 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3577, 417 ), te::gm::Coord2D( 3572, 784 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2004, 2198 ), te::gm::Coord2D( 2103, 2656 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 377, 1176 ), te::gm::Coord2D( 445, 1746 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2916, 276 ), te::gm::Coord2D( 2902, 685 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2099, 710 ), te::gm::Coord2D( 2115, 1169 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3047, 1593 ), te::gm::Coord2D( 3119, 1982 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 422, 1029 ), te::gm::Coord2D( 483, 1601 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2092, 1284 ), te::gm::Coord2D( 2140, 1738 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2975, 1006 ), te::gm::Coord2D( 3007, 1401 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2667, 460 ), te::gm::Coord2D( 2668, 884 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1791, 2120 ), te::gm::Coord2D( 1886, 2588 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2016, 2479 ), te::gm::Coord2D( 2131, 2939 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2489, 1683 ), te::gm::Coord2D( 2560, 2131 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3326, 2726 ), te::gm::Coord2D( 3477, 3115 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2822, 524 ), te::gm::Coord2D( 2824, 940 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2044, 1501 ), te::gm::Coord2D( 2104, 1956 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2231, 650 ), te::gm::Coord2D( 2243, 1101 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2165, 1346 ), te::gm::Coord2D( 2216, 1794 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1572, 625 ), te::gm::Coord2D( 1589, 1134 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2007, 669 ), te::gm::Coord2D( 2022, 1136 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2288, 914 ), te::gm::Coord2D( 2315, 1358 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1696, 2564 ), te::gm::Coord2D( 1813, 3045 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3942, 1392 ), te::gm::Coord2D( 4010, 1717 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2630, 2303 ), te::gm::Coord2D( 2740, 2735 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3322, 2746 ), te::gm::Coord2D( 3473, 3137 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4641, 403 ), te::gm::Coord2D( 4636, 693 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1711, 2148 ), te::gm::Coord2D( 1807, 2621 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2036, 1691 ), te::gm::Coord2D( 2107, 2144 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3366, 797 ), te::gm::Coord2D( 3386, 1172 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2001, 2400 ), te::gm::Coord2D( 2111, 2859 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2628, 2345 ), te::gm::Coord2D( 2741, 2778 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1858, 2207 ), te::gm::Coord2D( 1957, 2672 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1720, 2132 ), te::gm::Coord2D( 1815, 2604 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1536, 1257 ), te::gm::Coord2D( 1584, 1757 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2246, 416 ), te::gm::Coord2D( 2245, 871 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2246, 214 ), te::gm::Coord2D( 2234, 674 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 875, 2012 ), te::gm::Coord2D( 967, 2532 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1928, 1743 ), te::gm::Coord2D( 2002, 2203 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 220, 1106 ), te::gm::Coord2D( 292, 1690 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 648, 2140 ), te::gm::Coord2D( 746, 2683 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4316, 2032 ), te::gm::Coord2D( 4443, 2339 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2288, 890 ), te::gm::Coord2D( 2314, 1334 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2326, 289 ), te::gm::Coord2D( 2317, 740 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1889, 2279 ), te::gm::Coord2D( 1991, 2742 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2116, 1651 ), te::gm::Coord2D( 2184, 2100 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2146, 2214 ), te::gm::Coord2D( 2246, 2663 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3594, 453 ), te::gm::Coord2D( 3591, 818 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1576, 2401 ), te::gm::Coord2D( 1684, 2883 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3950, 1245 ), te::gm::Coord2D( 4007, 1566 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3869, 1459 ), te::gm::Coord2D( 3941, 1791 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2047, 2232 ), te::gm::Coord2D( 2148, 2687 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1955, 2724 ), te::gm::Coord2D( 2082, 3192 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1929, 1189 ), te::gm::Coord2D( 1973, 1653 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3330, 2665 ), te::gm::Coord2D( 3475, 3051 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3491, 921 ), te::gm::Coord2D( 3520, 1281 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2062, 1739 ), te::gm::Coord2D( 2136, 2191 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1073, 1995 ), te::gm::Coord2D( 1161, 2512 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2165, 1379 ), te::gm::Coord2D( 2218, 1827 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3985, 1372 ), te::gm::Coord2D( 4051, 1692 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2162, 148 ), te::gm::Coord2D( 2146, 617 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4336, 1978 ), te::gm::Coord2D( 4461, 2284 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2087, 620 ), te::gm::Coord2D( 2098, 1081 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1449, 2347 ), te::gm::Coord2D( 1556, 2835 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1283, 1247 ), te::gm::Coord2D( 1335, 1752 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 300, 1638 ), te::gm::Coord2D( 386, 2198 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2023, 2183 ), te::gm::Coord2D( 2122, 2639 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2202, 91 ), te::gm::Coord2D( 2183, 558 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2689, 739 ), te::gm::Coord2D( 2977, 1403 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2025, 1706 ), te::gm::Coord2D( 2098, 2161 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3315, 972 ), te::gm::Coord2D( 3347, 1353 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2485, 1180 ), te::gm::Coord2D( 2527, 1608 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1619, 2161 ), te::gm::Coord2D( 1716, 2641 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2004, 2412 ), te::gm::Coord2D( 2115, 2871 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2648, 159 ), te::gm::Coord2D( 2629, 596 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1468, 1772 ), te::gm::Coord2D( 1545, 2260 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2214, 455 ), te::gm::Coord2D( 2215, 910 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1891, 2674 ), te::gm::Coord2D( 2015, 3146 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3476, 2555 ), te::gm::Coord2D( 3618, 2933 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 411, 1132 ), te::gm::Coord2D( 477, 1701 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3528, 921 ), te::gm::Coord2D( 3559, 1279 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1617, 1200 ), te::gm::Coord2D( 1664, 1689 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2791, 349 ), te::gm::Coord2D( 2782, 774 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2242, 1513 ), te::gm::Coord2D( 2303, 1956 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1079, 967 ), te::gm::Coord2D( 1121, 1495 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2691, 472 ), te::gm::Coord2D( 2690, 893 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1769, 2596 ), te::gm::Coord2D( 1888, 3073 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1937, 1321 ), te::gm::Coord2D( 1988, 1784 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1452, 2356 ), te::gm::Coord2D( 1559, 2843 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2180, 269 ), te::gm::Coord2D( 2171, 734 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1324, 1264 ), te::gm::Coord2D( 1384, 1795 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3635, 1014 ), te::gm::Coord2D( 3672, 1372 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1696, 2268 ), te::gm::Coord2D( 1798, 2742 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2159, 587 ), te::gm::Coord2D( 2169, 1046 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3019, 369 ), te::gm::Coord2D( 3011, 768 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2847, 1016 ), te::gm::Coord2D( 2880, 1422 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2089, 945 ), te::gm::Coord2D( 2118, 1402 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3591, 2787 ), te::gm::Coord2D( 3753, 3164 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1722, 1941 ), te::gm::Coord2D( 1807, 2414 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1993, 85 ), te::gm::Coord2D( 1977, 567 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1109, 1011 ), te::gm::Coord2D( 1153, 1536 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1319, 1241 ), te::gm::Coord2D( 1377, 1772 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1547, 1190 ), te::gm::Coord2D( 1594, 1686 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2106, 956 ), te::gm::Coord2D( 2136, 1412 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2068, 1653 ), te::gm::Coord2D( 2137, 2105 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 366, 1158 ), te::gm::Coord2D( 434, 1729 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1831, 1999 ), te::gm::Coord2D( 1919, 2464 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1923, 1252 ), te::gm::Coord2D( 1970, 1716 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3453, 1343 ), te::gm::Coord2D( 3511, 1711 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1771, 2177 ), te::gm::Coord2D( 1869, 2647 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1618, 2271 ), te::gm::Coord2D( 1720, 2750 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2729, 2204 ), te::gm::Coord2D( 2833, 2630 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1408, 1166 ), te::gm::Coord2D( 1455, 1669 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1793, 1636 ), te::gm::Coord2D( 1862, 2106 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1900, 641 ), te::gm::Coord2D( 1914, 1115 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 379, 1785 ), te::gm::Coord2D( 469, 2340 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3190, 1575 ), te::gm::Coord2D( 3260, 1961 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1893, 1781 ), te::gm::Coord2D( 1969, 2244 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1585, 2398 ), te::gm::Coord2D( 1693, 2879 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2568, 556 ), te::gm::Coord2D( 2573, 986 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2659, 654 ), te::gm::Coord2D( 2669, 1075 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2762, 2550 ), te::gm::Coord2D( 2889, 2972 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3251, 1376 ), te::gm::Coord2D( 3308, 1748 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1127, 1018 ), te::gm::Coord2D( 1173, 1537 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3341, 2685 ), te::gm::Coord2D( 3490, 3072 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1889, 662 ), te::gm::Coord2D( 1906, 1136 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2899, 30 ), te::gm::Coord2D( 2869, 447 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2062, 612 ), te::gm::Coord2D( 2072, 1076 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3965, 1410 ), te::gm::Coord2D( 4035, 1734 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2235, 436 ), te::gm::Coord2D( 2235, 891 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1956, 2247 ), te::gm::Coord2D( 2057, 2706 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1964, 650 ), te::gm::Coord2D( 1978, 1120 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4075, 127 ), te::gm::Coord2D( 4046, 454 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1311, 1336 ), te::gm::Coord2D( 1368, 1838 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 237, 1700 ), te::gm::Coord2D( 320, 2261 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4188, 111 ), te::gm::Coord2D( 4157, 431 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2083, 654 ), te::gm::Coord2D( 2097, 1115 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 276, 1699 ), te::gm::Coord2D( 453, 2305 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1623, 2393 ), te::gm::Coord2D( 1731, 2873 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1376, 1376 ), te::gm::Coord2D( 1430, 1881 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2500, 1021 ), te::gm::Coord2D( 2532, 1449 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1848, 2075 ), te::gm::Coord2D( 1944, 2542 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1761, 2096 ), te::gm::Coord2D( 1854, 2565 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2244, 1430 ), te::gm::Coord2D( 2301, 1872 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2630, 426 ), te::gm::Coord2D( 2628, 860 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1985, 1721 ), te::gm::Coord2D( 2058, 2177 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2220, 598 ), te::gm::Coord2D( 2229, 1051 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1689, 2281 ), te::gm::Coord2D( 1792, 2756 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2175, 1645 ), te::gm::Coord2D( 2243, 2091 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1784, 2176 ), te::gm::Coord2D( 1882, 2644 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2185, 1431 ), te::gm::Coord2D( 2242, 1877 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1912, 1169 ), te::gm::Coord2D( 1955, 1635 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2971, 98 ), te::gm::Coord2D( 2945, 508 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 847, 1954 ), te::gm::Coord2D( 936, 2480 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2851, 392 ), te::gm::Coord2D( 2844, 805 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2480, 1040 ), te::gm::Coord2D( 2514, 1470 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2419, 1390 ), te::gm::Coord2D( 2474, 1822 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4401, 2067 ), te::gm::Coord2D( 4537, 2368 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1911, 1195 ), te::gm::Coord2D( 1955, 1661 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2052, 1669 ), te::gm::Coord2D( 2122, 2121 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1778, 2068 ), te::gm::Coord2D( 1869, 2537 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2003, 615 ), te::gm::Coord2D( 2015, 1083 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2515, 208 ), te::gm::Coord2D( 2499, 652 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2037, 2325 ), te::gm::Coord2D( 2143, 2782 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1840, 1862 ), te::gm::Coord2D( 1920, 2328 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1597, 1666 ), te::gm::Coord2D( 1668, 2147 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1806, 2243 ), te::gm::Coord2D( 1908, 2711 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2916, 32 ), te::gm::Coord2D( 2887, 448 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2097, 604 ), te::gm::Coord2D( 2107, 1065 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2190, 1589 ), te::gm::Coord2D( 2255, 2035 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3498, 2555 ), te::gm::Coord2D( 3641, 2927 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3519, 915 ), te::gm::Coord2D( 3548, 1273 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3042, 304 ), te::gm::Coord2D( 3029, 703 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2863, 176 ), te::gm::Coord2D( 2843, 591 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1658, 2253 ), te::gm::Coord2D( 1759, 2729 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1966, 2216 ), te::gm::Coord2D( 2066, 2675 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2071, 219 ), te::gm::Coord2D( 2061, 701 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2977, 994 ), te::gm::Coord2D( 3009, 1389 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3578, 2787 ), te::gm::Coord2D( 3740, 3163 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2792, 573 ), te::gm::Coord2D( 2798, 993 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1907, 2260 ), te::gm::Coord2D( 2008, 2722 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 292, 1723 ), te::gm::Coord2D( 395, 2290 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2353, 363 ), te::gm::Coord2D( 2348, 810 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2207, 588 ), te::gm::Coord2D( 2215, 1043 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1921, 1731 ), te::gm::Coord2D( 1994, 2192 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1932, 1346 ), te::gm::Coord2D( 1985, 1810 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1932, 2103 ), te::gm::Coord2D( 2026, 2563 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1638, 1715 ), te::gm::Coord2D( 1712, 2193 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1868, 2106 ), te::gm::Coord2D( 1961, 2570 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1737, 1537 ), te::gm::Coord2D( 1800, 2011 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1224, 2150 ), te::gm::Coord2D( 1320, 2659 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2397, 864 ), te::gm::Coord2D( 2420, 1310 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2153, 616 ), te::gm::Coord2D( 2164, 1074 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2288, 1463 ), te::gm::Coord2D( 2347, 1902 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2784, 551 ), te::gm::Coord2D( 2788, 975 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1893, 2123 ), te::gm::Coord2D( 1987, 2586 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2326, 1159 ), te::gm::Coord2D( 2366, 1598 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2236, 1469 ), te::gm::Coord2D( 2294, 1911 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1634, 2265 ), te::gm::Coord2D( 1736, 2743 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2700, 3065 ), te::gm::Coord2D( 2073, 2579 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1872, 1670 ), te::gm::Coord2D( 1942, 2134 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1028, 866 ), te::gm::Coord2D( 1066, 1396 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1992, 2456 ), te::gm::Coord2D( 2105, 2917 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3183, 1278 ), te::gm::Coord2D( 3234, 1657 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1814, 2065 ), te::gm::Coord2D( 1905, 2531 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1627, 1890 ), te::gm::Coord2D( 1709, 2369 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2849, 524 ), te::gm::Coord2D( 2851, 937 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1219, 1884 ), te::gm::Coord2D( 1302, 2406 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2245, 582 ), te::gm::Coord2D( 2252, 1033 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2226, 151 ), te::gm::Coord2D( 2210, 614 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4370, 1866 ), te::gm::Coord2D( 4485, 2172 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3974, 1318 ), te::gm::Coord2D( 4036, 1641 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2156, 1621 ), te::gm::Coord2D( 2223, 2069 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2522, 459 ), te::gm::Coord2D( 2521, 893 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1805, 1734 ), te::gm::Coord2D( 1879, 2202 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1658, 2454 ), te::gm::Coord2D( 1770, 2932 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1575, 1833 ), te::gm::Coord2D( 1655, 2314 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1929, 2142 ), te::gm::Coord2D( 2025, 2603 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2485, 2238 ), te::gm::Coord2D( 2589, 2690 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2807, 873 ), te::gm::Coord2D( 2831, 1281 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3506, 966 ), te::gm::Coord2D( 3538, 1328 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3423, 2667 ), te::gm::Coord2D( 3573, 3046 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2057, 1699 ), te::gm::Coord2D( 2128, 2151 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1783, 2196 ), te::gm::Coord2D( 1881, 2665 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3309, 2743 ), te::gm::Coord2D( 3461, 3134 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3332, 986 ), te::gm::Coord2D( 3364, 1365 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2001, 2218 ), te::gm::Coord2D( 2102, 2675 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1477, 1842 ), te::gm::Coord2D( 1558, 2330 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2700, 447 ), te::gm::Coord2D( 2701, 873 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3105, 1181 ), te::gm::Coord2D( 3150, 1565 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3825, 1497 ), te::gm::Coord2D( 3899, 1830 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1801, 2007 ), te::gm::Coord2D( 1889, 2474 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4124, 1662 ), te::gm::Coord2D( 4216, 1982 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3341, 148 ), te::gm::Coord2D( 3316, 536 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1597, 1220 ), te::gm::Coord2D( 1645, 1711 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2452, 1311 ), te::gm::Coord2D( 2502, 1741 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 838, 1977 ), te::gm::Coord2D( 928, 2501 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1923, 2056 ), te::gm::Coord2D( 2014, 2517 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3511, 2773 ), te::gm::Coord2D( 3672, 3156 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2106, 2356 ), te::gm::Coord2D( 2214, 2810 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1794, 2249 ), te::gm::Coord2D( 1896, 2718 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1895, 1365 ), te::gm::Coord2D( 1949, 1830 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2098, 2268 ), te::gm::Coord2D( 2201, 2720 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2168, 66 ), te::gm::Coord2D( 2148, 536 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1780, 2050 ), te::gm::Coord2D( 1871, 2519 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1886, 1332 ), te::gm::Coord2D( 1938, 1798 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2042, 2383 ), te::gm::Coord2D( 2151, 2840 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1649, 2273 ), te::gm::Coord2D( 1751, 2750 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1808, 2039 ), te::gm::Coord2D( 1898, 2505 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4077, 1313 ), te::gm::Coord2D( 4142, 1627 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2891, 940 ), te::gm::Coord2D( 2920, 1342 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1933, 2286 ), te::gm::Coord2D( 2036, 2747 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 64, 1563 ), te::gm::Coord2D( 477, 2253 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2169, 545 ), te::gm::Coord2D( 2175, 1002 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2825, 863 ), te::gm::Coord2D( 2848, 1269 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2469, 1219 ), te::gm::Coord2D( 2513, 1648 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1509, 1262 ), te::gm::Coord2D( 1560, 1761 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2032, 1663 ), te::gm::Coord2D( 2102, 2117 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3597, 2569 ), te::gm::Coord2D( 3744, 2941 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2328, 1431 ), te::gm::Coord2D( 2384, 1867 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4089, 1277 ), te::gm::Coord2D( 4152, 1587 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4125, 675 ), te::gm::Coord2D( 4141, 990 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1965, 2730 ), te::gm::Coord2D( 2093, 3199 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3370, 2809 ), te::gm::Coord2D( 3529, 3198 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2200, 1078 ), te::gm::Coord2D( 2236, 1526 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 847, 2087 ), te::gm::Coord2D( 949, 2615 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2244, 1066 ), te::gm::Coord2D( 2280, 1511 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1707, 1624 ), te::gm::Coord2D( 1775, 2099 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 401, 1026 ), te::gm::Coord2D( 463, 1596 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1888, 2135 ), te::gm::Coord2D( 1983, 2597 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 97, 1626 ), te::gm::Coord2D( 181, 2196 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1589, 1168 ), te::gm::Coord2D( 1634, 1660 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2117, 1471 ), te::gm::Coord2D( 2176, 1921 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2526, 565 ), te::gm::Coord2D( 2290, 36 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1790, 1530 ), te::gm::Coord2D( 1853, 2001 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2168, 567 ), te::gm::Coord2D( 2176, 1023 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1877, 2598 ), te::gm::Coord2D( 1997, 3066 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1953, 596 ), te::gm::Coord2D( 1965, 1068 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2334, 2487 ), te::gm::Coord2D( 2451, 2937 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 356, 965 ), te::gm::Coord2D( 419, 1542 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 400, 1192 ), te::gm::Coord2D( 468, 1759 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2776, 778 ), te::gm::Coord2D( 2794, 1188 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2067, 1664 ), te::gm::Coord2D( 2137, 2116 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 214, 1171 ), te::gm::Coord2D( 288, 1745 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3584, 858 ), te::gm::Coord2D( 3101, 1504 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3326, 771 ), te::gm::Coord2D( 3345, 1146 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2198, 138 ), te::gm::Coord2D( 2182, 604 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4437, 1931 ), te::gm::Coord2D( 4563, 2226 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1918, 1824 ), te::gm::Coord2D( 1996, 2284 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2096, 1636 ), te::gm::Coord2D( 2164, 2086 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4030, 1373 ), te::gm::Coord2D( 4095, 1690 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2231, 636 ), te::gm::Coord2D( 2242, 1087 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1635, 2425 ), te::gm::Coord2D( 1745, 2904 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1809, 2170 ), te::gm::Coord2D( 1906, 2637 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2739, 523 ), te::gm::Coord2D( 2741, 943 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1943, 2207 ), te::gm::Coord2D( 2043, 2667 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2081, 641 ), te::gm::Coord2D( 2093, 1103 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1949, 1381 ), te::gm::Coord2D( 2003, 1842 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1766, 2055 ), te::gm::Coord2D( 1857, 2525 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1928, 1755 ), te::gm::Coord2D( 2003, 2215 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1668, 2281 ), te::gm::Coord2D( 1771, 2757 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1236, 651 ), te::gm::Coord2D( 1262, 1170 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2718, 483 ), te::gm::Coord2D( 2719, 901 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3772, 1349 ), te::gm::Coord2D( 3833, 1686 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2230, 516 ), te::gm::Coord2D( 2235, 969 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 867, 1998 ), te::gm::Coord2D( 958, 2522 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1856, 1667 ), te::gm::Coord2D( 1926, 2133 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2064, 71 ), te::gm::Coord2D( 2046, 547 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2086, 87 ), te::gm::Coord2D( 2068, 562 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1573, 2357 ), te::gm::Coord2D( 1679, 2839 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2200, 667 ), te::gm::Coord2D( 2213, 1120 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 183, 1639 ), te::gm::Coord2D( 383, 2268 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1946, 2155 ), te::gm::Coord2D( 2043, 2614 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3237, 1353 ), te::gm::Coord2D( 3293, 1727 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2471, 1015 ), te::gm::Coord2D( 2504, 1445 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2025, 1627 ), te::gm::Coord2D( 2093, 2081 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2064, 1673 ), te::gm::Coord2D( 2134, 2125 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2403, 347 ), te::gm::Coord2D( 2396, 792 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2160, 2224 ), te::gm::Coord2D( 2262, 2672 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2292, 240 ), te::gm::Coord2D( 2281, 696 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3486, 843 ), te::gm::Coord2D( 3509, 1207 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1769, 2115 ), te::gm::Coord2D( 1863, 2584 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2284, 673 ), te::gm::Coord2D( 2297, 1121 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2197, 646 ), te::gm::Coord2D( 2209, 1099 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2200, 578 ), te::gm::Coord2D( 2208, 1032 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1636, 1553 ), te::gm::Coord2D( 1701, 2033 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2321, 1421 ), te::gm::Coord2D( 2377, 1858 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2238, 265 ), te::gm::Coord2D( 2228, 724 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2482, 1079 ), te::gm::Coord2D( 2518, 1508 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3015, 286 ), te::gm::Coord2D( 3002, 686 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3851, 1294 ), te::gm::Coord2D( 3910, 1629 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3382, 748 ), te::gm::Coord2D( 3399, 1118 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2606, 123 ), te::gm::Coord2D( 2585, 564 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3264, 689 ), te::gm::Coord2D( 3277, 1064 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1986, 2419 ), te::gm::Coord2D( 2097, 2880 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1659, 2014 ), te::gm::Coord2D( 1748, 2492 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1942, 2139 ), te::gm::Coord2D( 2038, 2599 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1869, 1327 ), te::gm::Coord2D( 1920, 1795 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 213, 1659 ), te::gm::Coord2D( 299, 2225 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4601, 340 ), te::gm::Coord2D( 4181, 1032 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1590, 1176 ), te::gm::Coord2D( 1635, 1668 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2263, 687 ), te::gm::Coord2D( 2278, 1135 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2193, 591 ), te::gm::Coord2D( 2202, 1045 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1892, 2222 ), te::gm::Coord2D( 1992, 2685 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1782, 2572 ), te::gm::Coord2D( 1900, 3044 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3933, 1390 ), te::gm::Coord2D( 4000, 1716 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2242, 1356 ), te::gm::Coord2D( 2294, 1800 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3399, 890 ), te::gm::Coord2D( 3425, 1264 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2538, 471 ), te::gm::Coord2D( 2538, 904 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3465, 2676 ), te::gm::Coord2D( 3616, 3053 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2305, 355 ), te::gm::Coord2D( 2299, 807 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2971, 332 ), te::gm::Coord2D( 2960, 736 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 622, 1041 ), te::gm::Coord2D( 679, 1598 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2472, 1683 ), te::gm::Coord2D( 2544, 2131 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4162, 671 ), te::gm::Coord2D( 4181, 983 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2011, 1714 ), te::gm::Coord2D( 2084, 2170 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3468, 2598 ), te::gm::Coord2D( 3654, 2940 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2944, 66 ), te::gm::Coord2D( 2915, 479 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3211, 765 ), te::gm::Coord2D( 3229, 1145 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1666, 2305 ), te::gm::Coord2D( 1770, 2782 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3178, 1598 ), te::gm::Coord2D( 3249, 1984 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2055, 2356 ), te::gm::Coord2D( 2163, 2812 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 318, 931 ), te::gm::Coord2D( 386, 1515 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4137, 668 ), te::gm::Coord2D( 4151, 985 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2734, 707 ), te::gm::Coord2D( 2747, 1121 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2208, 647 ), te::gm::Coord2D( 2220, 1099 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2257, 1376 ), te::gm::Coord2D( 2310, 1819 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3592, 870 ), te::gm::Coord2D( 3619, 1225 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3426, 853 ), te::gm::Coord2D( 3451, 1224 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1643, 1604 ), te::gm::Coord2D( 1711, 2083 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2010, 1701 ), te::gm::Coord2D( 2081, 2156 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2179, 100 ), te::gm::Coord2D( 2161, 568 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 459, 1844 ), te::gm::Coord2D( 548, 2392 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2606, 545 ), te::gm::Coord2D( 2611, 971 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3241, 722 ), te::gm::Coord2D( 3256, 1099 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1835, 1344 ), te::gm::Coord2D( 1888, 1814 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1673, 1886 ), te::gm::Coord2D( 1755, 2362 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2168, 2196 ), te::gm::Coord2D( 2268, 2643 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1872, 1905 ), te::gm::Coord2D( 1955, 2368 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2805, 826 ), te::gm::Coord2D( 2826, 1234 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2907, 1640 ), te::gm::Coord2D( 2978, 2038 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3169, 355 ), te::gm::Coord2D( 3160, 751 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1321, 1357 ), te::gm::Coord2D( 1378, 1858 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3879, 1471 ), te::gm::Coord2D( 3952, 1801 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4046, 1310 ), te::gm::Coord2D( 4109, 1626 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1493, 2413 ), te::gm::Coord2D( 1602, 2903 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2047, 65 ), te::gm::Coord2D( 2029, 543 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2399, 329 ), te::gm::Coord2D( 2392, 775 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4448, 1904 ), te::gm::Coord2D( 4572, 2198 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3299, 1429 ), te::gm::Coord2D( 3360, 1798 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3396, 2584 ), te::gm::Coord2D( 3537, 2971 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4759, 1547 ), te::gm::Coord2D( 4863, 1814 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1311, 1294 ), te::gm::Coord2D( 1365, 1796 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4389, 2059 ), te::gm::Coord2D( 4524, 2360 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2779, 1912 ), te::gm::Coord2D( 2866, 2330 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2434, 1413 ), te::gm::Coord2D( 2489, 1843 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1574, 1848 ), te::gm::Coord2D( 1654, 2328 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3762, 1352 ), te::gm::Coord2D( 3825, 1690 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1965, 2615 ), te::gm::Coord2D( 2087, 3079 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 376, 1108 ), te::gm::Coord2D( 443, 1681 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2991, 117 ), te::gm::Coord2D( 2966, 526 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2627, 107 ), te::gm::Coord2D( 2604, 545 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1940, 1670 ), te::gm::Coord2D( 2010, 2130 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2015, 1731 ), te::gm::Coord2D( 2089, 2187 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3558, 478 ), te::gm::Coord2D( 3557, 848 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1830, 2071 ), te::gm::Coord2D( 1922, 2536 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3328, 2778 ), te::gm::Coord2D( 3483, 3166 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2682, 667 ), te::gm::Coord2D( 2694, 1088 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2952, 143 ), te::gm::Coord2D( 2930, 554 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1975, 2238 ), te::gm::Coord2D( 2076, 2696 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2264, 400 ), te::gm::Coord2D( 2262, 854 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2231, 598 ), te::gm::Coord2D( 2240, 1050 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1899, 1793 ), te::gm::Coord2D( 1976, 2255 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1919, 1300 ), te::gm::Coord2D( 1969, 1765 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3033, 162 ), te::gm::Coord2D( 3010, 565 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2041, 596 ), te::gm::Coord2D( 2052, 1061 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1650, 1697 ), te::gm::Coord2D( 1722, 2175 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2099, 2246 ), te::gm::Coord2D( 2201, 2697 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1643, 2236 ), te::gm::Coord2D( 1743, 2714 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2265, 1859 ), te::gm::Coord2D( 2345, 2311 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3513, 927 ), te::gm::Coord2D( 3544, 1285 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1846, 1890 ), te::gm::Coord2D( 1928, 2355 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1798, 2220 ), te::gm::Coord2D( 1897, 2688 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 794, 1856 ), te::gm::Coord2D( 880, 2384 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2149, 570 ), te::gm::Coord2D( 2156, 1029 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 183, 1679 ), te::gm::Coord2D( 270, 2246 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1898, 2194 ), te::gm::Coord2D( 1996, 2656 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4178, 1025 ), te::gm::Coord2D( 4222, 1339 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3830, 1473 ), te::gm::Coord2D( 3902, 1806 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1837, 1878 ), te::gm::Coord2D( 1919, 2344 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 297, 915 ), te::gm::Coord2D( 361, 1498 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1482, 2552 ), te::gm::Coord2D( 1598, 3041 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3011, 204 ), te::gm::Coord2D( 2991, 607 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3888, 1473 ), te::gm::Coord2D( 3961, 1803 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2980, 1020 ), te::gm::Coord2D( 3014, 1414 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1876, 2269 ), te::gm::Coord2D( 1979, 2733 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2066, 676 ), te::gm::Coord2D( 2081, 1139 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1010, 926 ), te::gm::Coord2D( 1053, 1454 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1627, 2371 ), te::gm::Coord2D( 1735, 2850 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2267, 647 ), te::gm::Coord2D( 2278, 1094 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1808, 2214 ), te::gm::Coord2D( 1908, 2681 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1032, 888 ), te::gm::Coord2D( 1073, 1414 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1400, 1201 ), te::gm::Coord2D( 1451, 1705 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 415, 1714 ), te::gm::Coord2D( 501, 2266 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3947, 1316 ), te::gm::Coord2D( 4008, 1641 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1937, 2246 ), te::gm::Coord2D( 2039, 2707 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2269, 1439 ), te::gm::Coord2D( 2326, 1879 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3592, 2736 ), te::gm::Coord2D( 3753, 3108 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2363, 1163 ), te::gm::Coord2D( 2404, 1599 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1912, 2244 ), te::gm::Coord2D( 2013, 2705 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1949, 2232 ), te::gm::Coord2D( 2050, 2691 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1881, 1875 ), te::gm::Coord2D( 1962, 2338 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3024, 329 ), te::gm::Coord2D( 3014, 728 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3986, 1412 ), te::gm::Coord2D( 4056, 1730 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2236, 392 ), te::gm::Coord2D( 2233, 849 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1726, 1653 ), te::gm::Coord2D( 1796, 2127 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 783, 2115 ), te::gm::Coord2D( 880, 2643 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2040, 2182 ), te::gm::Coord2D( 2138, 2637 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1879, 1309 ), te::gm::Coord2D( 1929, 1776 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1819, 1378 ), te::gm::Coord2D( 1873, 1848 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4362, 2008 ), te::gm::Coord2D( 4493, 2312 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3989, 1317 ), te::gm::Coord2D( 4053, 1638 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2930, 110 ), te::gm::Coord2D( 2906, 523 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 366, 1093 ), te::gm::Coord2D( 433, 1667 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2242, 616 ), te::gm::Coord2D( 2252, 1068 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2875, 351 ), te::gm::Coord2D( 2867, 764 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2817, 838 ), te::gm::Coord2D( 2838, 1244 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3547, 919 ), te::gm::Coord2D( 3578, 1276 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3363, 745 ), te::gm::Coord2D( 3379, 1116 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4414, 2066 ), te::gm::Coord2D( 4553, 2368 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3850, 1497 ), te::gm::Coord2D( 3924, 1827 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2177, 860 ), te::gm::Coord2D( 2202, 1312 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1364, 2409 ), te::gm::Coord2D( 1472, 2902 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3269, 764 ), te::gm::Coord2D( 3286, 1141 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2023, 550 ), te::gm::Coord2D( 2031, 1017 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3438, 2669 ), te::gm::Coord2D( 3587, 3047 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3263, 705 ), te::gm::Coord2D( 3277, 1080 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1988, 2722 ), te::gm::Coord2D( 2116, 3186 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3452, 2651 ), te::gm::Coord2D( 3601, 3029 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1613, 2309 ), te::gm::Coord2D( 1717, 2788 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3373, 2774 ), te::gm::Coord2D( 3529, 3162 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1946, 2528 ), te::gm::Coord2D( 2063, 2993 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2590, 643 ), te::gm::Coord2D( 2600, 1069 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2178, 1358 ), te::gm::Coord2D( 2230, 1806 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1908, 497 ), te::gm::Coord2D( 1915, 974 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1948, 2061 ), te::gm::Coord2D( 2039, 2520 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2975, 203 ), te::gm::Coord2D( 2956, 608 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3529, 934 ), te::gm::Coord2D( 3559, 1291 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2207, 1419 ), te::gm::Coord2D( 2263, 1864 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2969, 346 ), te::gm::Coord2D( 2959, 749 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2934, 1705 ), te::gm::Coord2D( 3009, 2101 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2343, 1097 ), te::gm::Coord2D( 2380, 1535 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2826, 572 ), te::gm::Coord2D( 2832, 985 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1664, 1508 ), te::gm::Coord2D( 1727, 1987 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3516, 2582 ), te::gm::Coord2D( 3666, 2961 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1633, 2248 ), te::gm::Coord2D( 1734, 2726 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2245, 602 ), te::gm::Coord2D( 2255, 1053 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1815, 1700 ), te::gm::Coord2D( 1887, 2168 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2655, 84 ), te::gm::Coord2D( 2631, 520 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2632, 567 ), te::gm::Coord2D( 2637, 991 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4073, 1223 ), te::gm::Coord2D( 4130, 1534 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2428, 1254 ), te::gm::Coord2D( 2474, 1685 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1306, 1345 ), te::gm::Coord2D( 1363, 1847 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1289, 1439 ), te::gm::Coord2D( 1350, 1955 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3552, 2751 ), te::gm::Coord2D( 3713, 3126 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3295, 734 ), te::gm::Coord2D( 3311, 1110 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2223, 254 ), te::gm::Coord2D( 2213, 714 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2219, 1400 ), te::gm::Coord2D( 2273, 1845 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1794, 1108 ), te::gm::Coord2D( 1834, 1583 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4390, 2026 ), te::gm::Coord2D( 4520, 2328 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2073, 655 ), te::gm::Coord2D( 2086, 1117 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1647, 2523 ), te::gm::Coord2D( 1762, 3006 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1830, 1683 ), te::gm::Coord2D( 1901, 2150 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1524, 210 ), te::gm::Coord2D( 1523, 731 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2053, 584 ), te::gm::Coord2D( 2063, 1049 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1723, 1642 ), te::gm::Coord2D( 1792, 2116 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2707, 749 ), te::gm::Coord2D( 2723, 1166 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3628, 881 ), te::gm::Coord2D( 3656, 1231 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1479, 1323 ), te::gm::Coord2D( 1533, 1823 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1392, 1469 ), te::gm::Coord2D( 1454, 1964 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4318, 1954 ), te::gm::Coord2D( 4443, 2259 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3953, 1226 ), te::gm::Coord2D( 4008, 1546 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1839, 2122 ), te::gm::Coord2D( 1934, 2588 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3263, 797 ), te::gm::Coord2D( 3283, 1182 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1901, 664 ), te::gm::Coord2D( 1917, 1138 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4700, 1466 ), te::gm::Coord2D( 4794, 1740 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2690, 678 ), te::gm::Coord2D( 2703, 1097 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2809, 982 ), te::gm::Coord2D( 2839, 1388 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4353, 2024 ), te::gm::Coord2D( 4483, 2333 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4039, 1322 ), te::gm::Coord2D( 4104, 1639 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1601, 1189 ), te::gm::Coord2D( 1647, 1680 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3911, 1321 ), te::gm::Coord2D( 3973, 1649 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1143, 1095 ), te::gm::Coord2D( 1190, 1611 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2094, 1670 ), te::gm::Coord2D( 2164, 2120 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1676, 2492 ), te::gm::Coord2D( 1789, 2970 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2979, 302 ), te::gm::Coord2D( 2965, 706 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2707, 2036 ), te::gm::Coord2D( 2801, 2465 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3999, 1370 ), te::gm::Coord2D( 4066, 1689 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2159, 2759 ), te::gm::Coord2D( 2290, 3216 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1839, 2065 ), te::gm::Coord2D( 1930, 2530 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2924, 1723 ), te::gm::Coord2D( 3002, 2120 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1624, 2236 ), te::gm::Coord2D( 1725, 2714 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1450, 1809 ), te::gm::Coord2D( 1529, 2299 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2188, 151 ), te::gm::Coord2D( 2173, 616 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2552, 160 ), te::gm::Coord2D( 2531, 604 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2213, 497 ), te::gm::Coord2D( 2216, 952 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2229, 376 ), te::gm::Coord2D( 2225, 832 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2758, 753 ), te::gm::Coord2D( 2774, 1166 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1797, 1987 ), te::gm::Coord2D( 1884, 2454 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3099, 1156 ), te::gm::Coord2D( 3141, 1542 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2517, 199 ), te::gm::Coord2D( 2500, 643 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1902, 1874 ), te::gm::Coord2D( 1983, 2336 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2296, 344 ), te::gm::Coord2D( 2291, 796 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2038, 626 ), te::gm::Coord2D( 2050, 1091 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2313, 1027 ), te::gm::Coord2D( 2346, 1468 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1577, 1191 ), te::gm::Coord2D( 1623, 1684 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3232, 1312 ), te::gm::Coord2D( 3286, 1686 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3376, 2795 ), te::gm::Coord2D( 3534, 3184 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3476, 925 ), te::gm::Coord2D( 3507, 1287 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1849, 894 ), te::gm::Coord2D( 1878, 1367 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 391, 1699 ), te::gm::Coord2D( 403, 2213 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3018, 411 ), te::gm::Coord2D( 3012, 809 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4647, 51 ), te::gm::Coord2D( 4607, 350 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3970, 1343 ), te::gm::Coord2D( 4035, 1665 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3571, 2708 ), te::gm::Coord2D( 3729, 3081 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 804, 1951 ), te::gm::Coord2D( 894, 2479 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3966, 1376 ), te::gm::Coord2D( 4033, 1699 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1882, 2201 ), te::gm::Coord2D( 1981, 2665 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 64, 1606 ), te::gm::Coord2D( 153, 2182 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2305, 1459 ), te::gm::Coord2D( 2363, 1897 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2772, 431 ), te::gm::Coord2D( 2768, 848 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1751, 1624 ), te::gm::Coord2D( 1819, 2096 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3575, 851 ), te::gm::Coord2D( 3600, 1208 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2986, 104 ), te::gm::Coord2D( 2961, 512 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4719, 1436 ), te::gm::Coord2D( 4811, 1706 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2461, 1006 ), te::gm::Coord2D( 2492, 1437 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3422, 807 ), te::gm::Coord2D( 3443, 1177 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1768, 2205 ), te::gm::Coord2D( 1867, 2674 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1733, 2095 ), te::gm::Coord2D( 1826, 2566 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1626, 2342 ), te::gm::Coord2D( 1732, 2821 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1945, 2421 ), te::gm::Coord2D( 2056, 2884 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1842, 1546 ), te::gm::Coord2D( 1906, 2013 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1864, 1820 ), te::gm::Coord2D( 1942, 2284 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2862, 544 ), te::gm::Coord2D( 2866, 955 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3791, 1348 ), te::gm::Coord2D( 3853, 1683 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3044, 366 ), te::gm::Coord2D( 3036, 763 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2827, 541 ), te::gm::Coord2D( 2830, 956 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 473, 1849 ), te::gm::Coord2D( 563, 2397 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1511, 1278 ), te::gm::Coord2D( 1561, 1778 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1921, 2700 ), te::gm::Coord2D( 2046, 3171 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 816, 2065 ), te::gm::Coord2D( 910, 2591 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 771, 2037 ), te::gm::Coord2D( 864, 2565 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3798, 1400 ), te::gm::Coord2D( 3864, 1738 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3725, 1437 ), te::gm::Coord2D( 3793, 1774 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2203, 71 ), te::gm::Coord2D( 2183, 538 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2195, 1406 ), te::gm::Coord2D( 2250, 1852 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1735, 1577 ), te::gm::Coord2D( 1800, 2050 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 423, 1823 ), te::gm::Coord2D( 144, 2176 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2841, 839 ), te::gm::Coord2D( 2863, 1246 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3569, 2677 ), te::gm::Coord2D( 3722, 3047 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1941, 1084 ), te::gm::Coord2D( 1979, 1549 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4056, 1207 ), te::gm::Coord2D( 4112, 1519 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3016, 1544 ), te::gm::Coord2D( 3083, 1933 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3405, 2823 ), te::gm::Coord2D( 3566, 3212 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1448, 1339 ), te::gm::Coord2D( 1504, 1841 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 861, 2696 ), te::gm::Coord2D( 979, 3226 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3047, 1605 ), te::gm::Coord2D( 3117, 1992 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 113, 1593 ), te::gm::Coord2D( 202, 2167 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1024, 937 ), te::gm::Coord2D( 1066, 1463 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2120, 1504 ), te::gm::Coord2D( 2181, 1954 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2582, 1028 ), te::gm::Coord2D( 2614, 1457 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2116, 496 ), te::gm::Coord2D( 2120, 958 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2323, 252 ), te::gm::Coord2D( 2312, 706 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1070, 1105 ), te::gm::Coord2D( 1119, 1625 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2586, 138 ), te::gm::Coord2D( 2564, 580 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3898, 1466 ), te::gm::Coord2D( 3970, 1796 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 807, 2061 ), te::gm::Coord2D( 901, 2587 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1405, 1257 ), te::gm::Coord2D( 1457, 1762 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 363, 1788 ), te::gm::Coord2D( 27, 2113 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2040, 2394 ), te::gm::Coord2D( 2150, 2851 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2224, 495 ), te::gm::Coord2D( 2227, 949 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1601, 2447 ), te::gm::Coord2D( 1711, 2928 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3306, 1508 ), te::gm::Coord2D( 3373, 1877 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1478, 1314 ), te::gm::Coord2D( 1532, 1814 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2408, 1400 ), te::gm::Coord2D( 2463, 1832 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 342, 951 ), te::gm::Coord2D( 404, 1529 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2212, 1370 ), te::gm::Coord2D( 2265, 1816 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2829, 370 ), te::gm::Coord2D( 2823, 785 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3031, 1573 ), te::gm::Coord2D( 3100, 1961 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 443, 1833 ), te::gm::Coord2D( 533, 2383 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3039, 1093 ), te::gm::Coord2D( 3077, 1482 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1992, 2487 ), te::gm::Coord2D( 2107, 2948 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3271, 748 ), te::gm::Coord2D( 3288, 1125 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1808, 2016 ), te::gm::Coord2D( 1897, 2483 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2468, 1340 ), te::gm::Coord2D( 2519, 1768 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3617, 910 ), te::gm::Coord2D( 3646, 1261 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1862, 2079 ), te::gm::Coord2D( 1955, 2544 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3015, 320 ), te::gm::Coord2D( 3004, 720 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2268, 370 ), te::gm::Coord2D( 2264, 824 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2510, 546 ), te::gm::Coord2D( 2513, 979 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3454, 2674 ), te::gm::Coord2D( 3605, 3051 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1996, 662 ), te::gm::Coord2D( 2011, 1129 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3595, 899 ), te::gm::Coord2D( 3624, 1252 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1955, 2694 ), te::gm::Coord2D( 2081, 3160 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3446, 2761 ), te::gm::Coord2D( 3603, 3143 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2054, 2193 ), te::gm::Coord2D( 2153, 2646 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 158, 1665 ), te::gm::Coord2D( 247, 2234 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3921, 1222 ), te::gm::Coord2D( 3977, 1545 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3777, 1462 ), te::gm::Coord2D( 3847, 1800 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2400, 976 ), te::gm::Coord2D( 2430, 1411 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3569, 2717 ), te::gm::Coord2D( 3727, 3090 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3968, 1352 ), te::gm::Coord2D( 4034, 1675 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2030, 1747 ), te::gm::Coord2D( 2105, 2201 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2926, 44 ), te::gm::Coord2D( 2896, 458 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2028, 1738 ), te::gm::Coord2D( 2102, 2193 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1630, 2507 ), te::gm::Coord2D( 1743, 2991 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3004, 397 ), te::gm::Coord2D( 2998, 796 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3905, 1380 ), te::gm::Coord2D( 3972, 1709 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1963, 2695 ), te::gm::Coord2D( 2089, 3161 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3314, 776 ), te::gm::Coord2D( 3333, 1152 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1700, 2551 ), te::gm::Coord2D( 1817, 3031 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2946, 51 ), te::gm::Coord2D( 2917, 463 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2854, 341 ), te::gm::Coord2D( 2845, 756 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 878, 2106 ), te::gm::Coord2D( 974, 2629 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3565, 898 ), te::gm::Coord2D( 3593, 1255 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3948, 1185 ), te::gm::Coord2D( 4000, 1505 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2436, 1351 ), te::gm::Coord2D( 2488, 1781 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3034, 181 ), te::gm::Coord2D( 3013, 583 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3345, 899 ), te::gm::Coord2D( 3372, 1277 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3991, 1299 ), te::gm::Coord2D( 4052, 1616 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3331, 897 ), te::gm::Coord2D( 3357, 1278 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2716, 775 ), te::gm::Coord2D( 2734, 1191 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2883, 89 ), te::gm::Coord2D( 2856, 502 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 432, 1076 ), te::gm::Coord2D( 495, 1644 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 210, 1697 ), te::gm::Coord2D( 302, 2264 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4395, 2037 ), te::gm::Coord2D( 4528, 2337 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1866, 1336 ), te::gm::Coord2D( 1918, 1804 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3339, 838 ), te::gm::Coord2D( 3361, 1216 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2217, 340 ), te::gm::Coord2D( 2212, 798 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 265, 1729 ), te::gm::Coord2D( 354, 2290 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2973, 113 ), te::gm::Coord2D( 2948, 521 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2517, 1024 ), te::gm::Coord2D( 2550, 1451 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1535, 1241 ), te::gm::Coord2D( 1583, 1739 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1908, 2220 ), te::gm::Coord2D( 2008, 2682 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1541, 1276 ), te::gm::Coord2D( 1592, 1772 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1837, 919 ), te::gm::Coord2D( 1867, 1393 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1836, 1529 ), te::gm::Coord2D( 1899, 1997 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2021, 1641 ), te::gm::Coord2D( 2089, 2096 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1535, 1196 ), te::gm::Coord2D( 1582, 1694 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2327, 2013 ), te::gm::Coord2D( 2417, 2460 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2932, 1071 ), te::gm::Coord2D( 2969, 1469 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2904, 512 ), te::gm::Coord2D( 2905, 921 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4178, 684 ), te::gm::Coord2D( 4194, 990 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2223, 1387 ), te::gm::Coord2D( 2277, 1832 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2636, 686 ), te::gm::Coord2D( 2649, 1107 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 124, 1597 ), te::gm::Coord2D( 213, 2171 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1862, 1364 ), te::gm::Coord2D( 1916, 1832 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3067, 1132 ), te::gm::Coord2D( 3108, 1519 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2269, 699 ), te::gm::Coord2D( 2283, 1147 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2259, 539 ), te::gm::Coord2D( 2264, 990 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3937, 1408 ), te::gm::Coord2D( 4006, 1734 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3622, 898 ), te::gm::Coord2D( 3651, 1249 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3327, 916 ), te::gm::Coord2D( 3354, 1295 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2741, 182 ), te::gm::Coord2D( 2722, 608 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2994, 297 ), te::gm::Coord2D( 2981, 699 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 228, 1665 ), te::gm::Coord2D( 316, 2231 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 412, 1818 ), te::gm::Coord2D( 504, 2371 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2807, 411 ), te::gm::Coord2D( 2803, 824 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3567, 2780 ), te::gm::Coord2D( 3730, 3155 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 796, 2053 ), te::gm::Coord2D( 890, 2580 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3905, 1543 ), te::gm::Coord2D( 3983, 1874 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1544, 1201 ), te::gm::Coord2D( 1591, 1699 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2033, 663 ), te::gm::Coord2D( 2047, 1128 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3955, 1467 ), te::gm::Coord2D( 4029, 1792 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1843, 2105 ), te::gm::Coord2D( 1937, 2570 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3760, 1365 ), te::gm::Coord2D( 3823, 1702 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1925, 1368 ), te::gm::Coord2D( 1979, 1831 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3845, 1343 ), te::gm::Coord2D( 3907, 1678 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2932, 131 ), te::gm::Coord2D( 2909, 542 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2671, 650 ), te::gm::Coord2D( 2681, 1070 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2491, 423 ), te::gm::Coord2D( 2488, 860 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3314, 2702 ), te::gm::Coord2D( 3462, 3090 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3807, 1304 ), te::gm::Coord2D( 3866, 1640 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3448, 2778 ), te::gm::Coord2D( 3607, 3162 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3419, 2689 ), te::gm::Coord2D( 3570, 3071 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1004, 906 ), te::gm::Coord2D( 1046, 1435 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2134, 1500 ), te::gm::Coord2D( 2195, 1949 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2751, 454 ), te::gm::Coord2D( 2750, 870 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2012, 637 ), te::gm::Coord2D( 2025, 1104 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3394, 927 ), te::gm::Coord2D( 3423, 1301 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2844, 320 ), te::gm::Coord2D( 2834, 737 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2670, 722 ), te::gm::Coord2D( 2684, 1142 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 518, 1124 ), te::gm::Coord2D( 581, 1683 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1852, 1371 ), te::gm::Coord2D( 1906, 1839 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1451, 2465 ), te::gm::Coord2D( 1562, 2954 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2996, 1039 ), te::gm::Coord2D( 3031, 1432 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1416, 1197 ), te::gm::Coord2D( 1459, 1703 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3447, 985 ), te::gm::Coord2D( 3479, 1357 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2826, 997 ), te::gm::Coord2D( 2857, 1402 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2878, 467 ), te::gm::Coord2D( 2874, 875 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3593, 2758 ), te::gm::Coord2D( 3755, 3131 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1923, 2668 ), te::gm::Coord2D( 2047, 3135 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3933, 1228 ), te::gm::Coord2D( 3988, 1549 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3334, 887 ), te::gm::Coord2D( 3361, 1264 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2694, 688 ), te::gm::Coord2D( 2706, 1106 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1552, 2317 ), te::gm::Coord2D( 1656, 2800 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3432, 885 ), te::gm::Coord2D( 3459, 1260 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2901, 78 ), te::gm::Coord2D( 2875, 493 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 411, 1054 ), te::gm::Coord2D( 475, 1625 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3440, 1003 ), te::gm::Coord2D( 3475, 1371 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1970, 1398 ), te::gm::Coord2D( 2025, 1859 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2522, 474 ), te::gm::Coord2D( 2522, 907 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2956, 155 ), te::gm::Coord2D( 2934, 563 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2725, 160 ), te::gm::Coord2D( 2702, 587 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3917, 1260 ), te::gm::Coord2D( 3974, 1586 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3419, 2818 ), te::gm::Coord2D( 3580, 3205 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3420, 881 ), te::gm::Coord2D( 3446, 1256 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2827, 434 ), te::gm::Coord2D( 2825, 849 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3413, 899 ), te::gm::Coord2D( 3440, 1274 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2266, 656 ), te::gm::Coord2D( 2278, 1105 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3930, 1464 ), te::gm::Coord2D( 4003, 1791 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2515, 992 ), te::gm::Coord2D( 2545, 1419 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3397, 2651 ), te::gm::Coord2D( 3545, 3034 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4686, 1491 ), te::gm::Coord2D( 4782, 1765 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4186, 707 ), te::gm::Coord2D( 4205, 1012 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1414, 1273 ), te::gm::Coord2D( 1467, 1779 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2883, 421 ), te::gm::Coord2D( 2878, 833 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2659, 629 ), te::gm::Coord2D( 2667, 1050 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4008, 1280 ), te::gm::Coord2D( 4069, 1596 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3534, 897 ), te::gm::Coord2D( 3562, 1255 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4151, 724 ), te::gm::Coord2D( 4171, 1032 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3972, 1212 ), te::gm::Coord2D( 4027, 1532 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3571, 2691 ), te::gm::Coord2D( 3726, 3064 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3404, 928 ), te::gm::Coord2D( 3433, 1301 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 349, 1781 ), te::gm::Coord2D( 439, 2337 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1111, 1051 ), te::gm::Coord2D( 1156, 1569 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2456, 401 ), te::gm::Coord2D( 2453, 842 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1563, 2429 ), te::gm::Coord2D( 1673, 2912 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2945, 361 ), te::gm::Coord2D( 2937, 766 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3941, 1471 ), te::gm::Coord2D( 4015, 1796 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1450, 1326 ), te::gm::Coord2D( 1504, 1827 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3323, 929 ), te::gm::Coord2D( 3351, 1310 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1658, 2495 ), te::gm::Coord2D( 1771, 2974 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1451, 1357 ), te::gm::Coord2D( 1507, 1858 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3839, 1369 ), te::gm::Coord2D( 3904, 1706 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 116, 1639 ), te::gm::Coord2D( 206, 2211 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2817, 83 ), te::gm::Coord2D( 2792, 504 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 996, 875 ), te::gm::Coord2D( 1036, 1405 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3057, 337 ), te::gm::Coord2D( 3046, 734 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1339, 1189 ), te::gm::Coord2D( 1391, 1696 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3772, 1452 ), te::gm::Coord2D( 3841, 1790 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4341, 2042 ), te::gm::Coord2D( 4472, 2350 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4003, 1295 ), te::gm::Coord2D( 4065, 1612 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1527, 1209 ), te::gm::Coord2D( 1575, 1708 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3057, 1104 ), te::gm::Coord2D( 3096, 1492 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1534, 1286 ), te::gm::Coord2D( 1586, 1784 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3288, 1499 ), te::gm::Coord2D( 3354, 1870 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2973, 399 ), te::gm::Coord2D( 2968, 800 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2996, 272 ), te::gm::Coord2D( 2980, 671 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4001, 1358 ), te::gm::Coord2D( 4067, 1678 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4420, 2005 ), te::gm::Coord2D( 4551, 2303 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3557, 2764 ), te::gm::Coord2D( 3718, 3140 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2908, 128 ), te::gm::Coord2D( 2885, 541 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 192, 1685 ), te::gm::Coord2D( 282, 2252 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2857, 443 ), te::gm::Coord2D( 2852, 854 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1516, 2397 ), te::gm::Coord2D( 1624, 2883 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1360, 1184 ), te::gm::Coord2D( 1409, 1691 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1134, 1081 ), te::gm::Coord2D( 1181, 1598 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1546, 2418 ), te::gm::Coord2D( 1655, 2902 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1322, 1193 ), te::gm::Coord2D( 1372, 1701 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2953, 405 ), te::gm::Coord2D( 2947, 808 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1529, 1221 ), te::gm::Coord2D( 1577, 1720 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3540, 2625 ), te::gm::Coord2D( 3691, 2998 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2848, 561 ), te::gm::Coord2D( 2853, 973 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2441, 388 ), te::gm::Coord2D( 2436, 829 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1501, 1177 ), te::gm::Coord2D( 1548, 1678 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1082, 1036 ), te::gm::Coord2D( 1128, 1557 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1442, 1191 ), te::gm::Coord2D( 1525, 1685 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3967, 1468 ), te::gm::Coord2D( 4041, 1791 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1486, 1181 ), te::gm::Coord2D( 1536, 1682 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4043, 1217 ), te::gm::Coord2D( 4099, 1529 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1527, 2400 ), te::gm::Coord2D( 1635, 2885 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1506, 2391 ), te::gm::Coord2D( 1613, 2877 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 819, 1967 ), te::gm::Coord2D( 910, 2493 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4419, 2021 ), te::gm::Coord2D( 4552, 2320 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2948, 292 ), te::gm::Coord2D( 2934, 699 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4170, 719 ), te::gm::Coord2D( 4190, 1025 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3021, 1555 ), te::gm::Coord2D( 3088, 1944 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3552, 2647 ), te::gm::Coord2D( 3703, 3018 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 4436, 2044 ), te::gm::Coord2D( 4572, 2344 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2888, 488 ), te::gm::Coord2D( 2888, 899 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2801, 69 ), te::gm::Coord2D( 2775, 491 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2792, 83 ), te::gm::Coord2D( 2766, 507 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1468, 1185 ), te::gm::Coord2D( 1510, 1689 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 1481, 2377 ), te::gm::Coord2D( 1588, 2864 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 3459, 952 ), te::gm::Coord2D( 3490, 1322 ) ) );
  tiePoints.push_back( te::gm::GTParameters::TiePoint( te::gm::Coord2D( 2942, 243 ), te::gm::Coord2D( 2929, 656 ) ) );
}

void TsGTFilter::tcApplyRansacWithTPSet1()
{
  te::gm::GTParameters transfParams;
  generateTestTPSet1( transfParams.m_tiePoints );
  
  transfParams.m_tiePoints.push_back( te::gm::GTParameters::TiePoint( 
    te::gm::Coord2D( 0, 0 ), te::gm::Coord2D( 0, 0 ) ) );
  transfParams.m_tiePoints.push_back( te::gm::GTParameters::TiePoint( 
    te::gm::Coord2D( 10, 0 ), te::gm::Coord2D( 10, 0 ) ) );
  transfParams.m_tiePoints.push_back( te::gm::GTParameters::TiePoint( 
    te::gm::Coord2D( 0, 10 ), te::gm::Coord2D( 0, 10 ) ) );
  transfParams.m_tiePoints.push_back( te::gm::GTParameters::TiePoint( 
    te::gm::Coord2D( 10, 10 ), te::gm::Coord2D( 10, 10 ) ) );
    
  std::vector< double > tiePointsWeights;
  tiePointsWeights.resize( transfParams.m_tiePoints.size(), 1.0 );

  std::auto_ptr< te::gm::GeometricTransformation > transfPtr;
  std::vector< te::gm::GTParameters::TiePoint > tiePoints;
  
  te::gm::GTFilter filter;

  CPPUNIT_ASSERT( filter.applyRansac( "Affine", transfParams, 0.01, 
    0.01, 0, 0.5, false, tiePointsWeights, tiePoints, transfPtr ) );
  
  CPPUNIT_ASSERT( transfPtr->getName() == "Affine" );
  
  testDirectMapping( transfPtr.get(), te::gm::Coord2D( 0, 0 ), 
    te::gm::Coord2D( 0, 0 ), 0.0000001 );
  testDirectMapping( transfPtr.get(), te::gm::Coord2D( 10, 0 ), 
    te::gm::Coord2D( 10, 0 ), 0.0000001 );        
  testDirectMapping( transfPtr.get(), te::gm::Coord2D( 0, 10 ), 
    te::gm::Coord2D( 0, 10 ), 0.0000001 );    
  testDirectMapping( transfPtr.get(), te::gm::Coord2D( 10, 10 ), 
    te::gm::Coord2D( 10, 10 ), 0.0000001 );    
  testDirectMapping( transfPtr.get(), te::gm::Coord2D( 5, 5 ), 
    te::gm::Coord2D( 5, 5 ), 0.0000001 );    
    
  testInverseMapping( transfPtr.get(), te::gm::Coord2D( 0, 0 ), 
    te::gm::Coord2D( 0, 0 ), 0.0000001 );
  testInverseMapping( transfPtr.get(), te::gm::Coord2D( 10, 0 ), 
    te::gm::Coord2D( 10, 0 ), 0.0000001 );        
  testInverseMapping( transfPtr.get(), te::gm::Coord2D( 0, 10 ), 
    te::gm::Coord2D( 0, 10 ), 0.0000001 );    
  testInverseMapping( transfPtr.get(), te::gm::Coord2D( 10, 10 ), 
    te::gm::Coord2D( 10, 10 ), 0.0000001 );    
  testInverseMapping( transfPtr.get(), te::gm::Coord2D( 5, 5 ), 
    te::gm::Coord2D( 5, 5 ), 0.0000001 );    
}

void TsGTFilter::tcApplyRansacWithTPSet2()
{
  te::gm::GTParameters transfParams;
  generateTestTPSet2( transfParams.m_tiePoints );
    
  std::vector< double > tiePointsWeights;
  tiePointsWeights.resize( transfParams.m_tiePoints.size(), 1.0 );

  std::auto_ptr< te::gm::GeometricTransformation > transfPtr;
  std::vector< te::gm::GTParameters::TiePoint > tiePoints;
  
  te::gm::GTFilter filter;

  CPPUNIT_ASSERT( filter.applyRansac( "Affine", transfParams, 1, 
    1, 0, 0.5, false, tiePointsWeights, tiePoints, transfPtr ) );
  
  CPPUNIT_ASSERT( transfPtr->getName() == "Affine" );
  CPPUNIT_ASSERT( tiePoints.size() >
    transfPtr->getMinRequiredTiePoints() );
}

void TsGTFilter::tcApplyRansacMultiThread()
{
  te::gm::GTParameters transfParams;
  generateTestTPSet1( transfParams.m_tiePoints );
  
  transfParams.m_tiePoints.push_back( te::gm::GTParameters::TiePoint( 
    te::gm::Coord2D( 0, 0 ), te::gm::Coord2D( 0, 0 ) ) );
  transfParams.m_tiePoints.push_back( te::gm::GTParameters::TiePoint( 
    te::gm::Coord2D( 10, 0 ), te::gm::Coord2D( 10, 0 ) ) );
  transfParams.m_tiePoints.push_back( te::gm::GTParameters::TiePoint( 
    te::gm::Coord2D( 0, 10 ), te::gm::Coord2D( 0, 10 ) ) );
  transfParams.m_tiePoints.push_back( te::gm::GTParameters::TiePoint( 
    te::gm::Coord2D( 10, 10 ), te::gm::Coord2D( 10, 10 ) ) );
    
  std::vector< double > tiePointsWeights;
  tiePointsWeights.resize( transfParams.m_tiePoints.size(), 1.0 );

  std::auto_ptr< te::gm::GeometricTransformation > transfPtr;
  std::vector< te::gm::GTParameters::TiePoint > tiePoints;
  
  te::gm::GTFilter filter;

  CPPUNIT_ASSERT( filter.applyRansac( "Affine", transfParams, 0.01, 
    0.01, 0, 0.5, true, tiePointsWeights, tiePoints, transfPtr ) );
  
  CPPUNIT_ASSERT( transfPtr->getName() == "Affine" );
  
  testDirectMapping( transfPtr.get(), te::gm::Coord2D( 0, 0 ), 
    te::gm::Coord2D( 0, 0 ), 0.0000001 );
  testDirectMapping( transfPtr.get(), te::gm::Coord2D( 10, 0 ), 
    te::gm::Coord2D( 10, 0 ), 0.0000001 );        
  testDirectMapping( transfPtr.get(), te::gm::Coord2D( 0, 10 ), 
    te::gm::Coord2D( 0, 10 ), 0.0000001 );    
  testDirectMapping( transfPtr.get(), te::gm::Coord2D( 10, 10 ), 
    te::gm::Coord2D( 10, 10 ), 0.0000001 );    
  testDirectMapping( transfPtr.get(), te::gm::Coord2D( 5, 5 ), 
    te::gm::Coord2D( 5, 5 ), 0.0000001 );    
    
  testInverseMapping( transfPtr.get(), te::gm::Coord2D( 0, 0 ), 
    te::gm::Coord2D( 0, 0 ), 0.0000001 );
  testInverseMapping( transfPtr.get(), te::gm::Coord2D( 10, 0 ), 
    te::gm::Coord2D( 10, 0 ), 0.0000001 );        
  testInverseMapping( transfPtr.get(), te::gm::Coord2D( 0, 10 ), 
    te::gm::Coord2D( 0, 10 ), 0.0000001 );    
  testInverseMapping( transfPtr.get(), te::gm::Coord2D( 10, 10 ), 
    te::gm::Coord2D( 10, 10 ), 0.0000001 );    
  testInverseMapping( transfPtr.get(), te::gm::Coord2D( 5, 5 ), 
    te::gm::Coord2D( 5, 5 ), 0.0000001 );    
}

