set ( CPACK_PACKAGE_VENDOR "www.dpi.inpe.br" )
set ( CPACK_PACKAGE_DESCRIPTION_FILE "${CMAKE_SOURCE_DIR}/../README" )
set ( CPACK_RESOURCE_FILE_LICENSE "${CMAKE_SOURCE_DIR}/../COPYING" )
set ( CPACK_PACKAGE_VERSION_MAJOR "${TE_MAJOR_VERSION}" )
set ( CPACK_PACKAGE_VERSION_MINOR "${TE_MINOR_VERSION}" )
set ( CPACK_PACKAGE_VERSION_PATCH "${TE_PATCH_VERSION}" )
set ( CPACK_PACKAGE_VERSION "${TERRALIB_STRING_VERSION}" )
set ( CPACK_PACKAGE_CONTACT "terralib-devel@dpi.inpe.br" )
set ( CPACK_PACKAGE_ICON "${CMAKE_SOURCE_DIR}/../resources/images/bmp\\\\terralib-installer-logo-large.bmp" )

if(${BUILD_TERRAVIEW})
  set ( CPACK_PACKAGE_DESCRIPTION_SUMMARY "TerraView binary instalation." )
  set ( CPACK_PACKAGE_NAME "terraview" )
  set ( CPACK_PACKAGE_INSTALL_DIRECTORY "terraview-${CPACK_PACKAGE_VERSION}" )
else()
  set ( CPACK_PACKAGE_DESCRIPTION_SUMMARY "TerraLib binary instalation." )
  set ( CPACK_PACKAGE_NAME "terralib" )
  set ( CPACK_PACKAGE_INSTALL_DIRECTORY "terralib-${CPACK_PACKAGE_VERSION}" )
endif()

getPackageName(pname)

set ( CPACK_PACKAGE_FILE_NAME ${pname} )

if(WIN32)
  include (${TE_MODULE_PATH}/NSISPackage.cmake)
else ()
  set (CPACK_STRIP_FILES "")
  set (CPACK_SOURCE_STRIP_FILES "")
  
  if(UNIX AND NOT APPLE)
    include (${TE_MODULE_PATH}/DEBPackage.cmake)
  endif()
endif()

set ( CPACK_COMPONENT_GROUP_TLIB_DESCRIPTION "Terralib files." )
set ( CPACK_COMPONENT_GROUP_TLIB_DISPLAY_NAME "Terralib" )

set ( CPACK_COMPONENT_HEADERS_DISPLAY_NAME "C++ headers" )
set ( CPACK_COMPONENT_HEADERS_DESCRIPTION "Terralib header files." )
set ( CPACK_COMPONENT_HEADERS_GROUP "tlib")
set ( CPACK_COMPONENT_HEADERS_INSTALL_TYPES Developer Full )

set ( CPACK_COMPONENT_BINARIES_DISPLAY_NAME "Binaries" )
set ( CPACK_COMPONENT_BINARIES_DESCRIPTION "Platform-dependent binaries." )
set ( CPACK_COMPONENT_BINARIES_GROUP "tlib")
set ( CPACK_COMPONENT_BINARIES_REQUIRED "1")

set ( CPACK_COMPONENT_LIBRARIES_DISPLAY_NAME "Libraries" )
set ( CPACK_COMPONENT_LIBRARIES_DESCRIPTION "Platform-dependent libraries." )
set ( CPACK_COMPONENT_LIBRARIES_GROUP "tlib")
set ( CPACK_COMPONENT_LIBRARIES_INSTALL_TYPES Developer Full )

set ( CPACK_COMPONENT_CMAKE_DISPLAY_NAME "CMake files" )
set ( CPACK_COMPONENT_CMAKE_DESCRIPTION "CMake files." )
set ( CPACK_COMPONENT_CMAKE_GROUP "tlib")
set ( CPACK_COMPONENT_CMAKE_INSTALL_TYPES Developer Full )

set ( CPACK_COMPONENT_DOCS_DISPLAY_NAME "API documentation" )
set ( CPACK_COMPONENT_DOCS_DESCRIPTION "API documentation generated by Doxygen." )
set ( CPACK_COMPONENT_DOCS_GROUP "tlib")
set ( CPACK_COMPONENT_DOCS_INSTALL_TYPES Developer Full )

set ( CPACK_COMPONENT_PLUGINS_DISPLAY_NAME "TerraLib Plugins" )
set ( CPACK_COMPONENT_PLUGINS_DESCRIPTION "Plugins for TerraLib-based applications." )
set ( CPACK_COMPONENT_PLUGINS_GROUP "tlib")
set ( CPACK_COMPONENT_PLUGINS_INSTALL_TYPES Developer Full )

if(${BUILD_TERRAVIEW})
  set ( CPACK_COMPONENTS_ALL BINARIES PLUGINS)
else()
  set ( CPACK_COMPONENTS_ALL HEADERS BINARIES LIBRARIES PLUGINS CMAKE DOCS)
endif()

include (CPack)
