#include "MyLayerRenderer.h"
#include "MyLayer.h"
#include "MyDisplay.h"
#include <terralib/dataaccess.h>
#include <terralib/geometry.h>
#include <terralib/maptools.h>
#include <terralib/maptools/Grouping.h>
#include <terralib/maptools/LegendItem.h>
#include <terralib/qt/widgets.h>
#include <terralib/srs/Converter.h>

#include <QMatrix>
#include <QMutex>
#include <QRectF>
#include <set>

MyLayerRenderer::MyLayerRenderer(bool useChanged) : 
  QThread(),
  te::map::LayerRenderer(),
  m_useChanged(useChanged)
{
}

MyLayerRenderer::~MyLayerRenderer()
{
}

// Existe um erro nesta forma de desenho. Quando se tem um emaranhado de pontos ou linhas superpostas, deveriamos
// desenhar primeiro os nao selecionados e em seguida o resto. Desta forma garantimos que os
// selecionados serao visiveis (ficam por cima dos nao selecionados). Mas, como fazer isso de forma eficiente???
//void MyLayerRenderer::draw(te::map::AbstractLayer* al, te::map::Canvas* canvas,
//     const te::gm::Envelope& e, int srid)
//{
  //if(m_useChanged == false)
  //  canvas->clear();

  //MyLayer* layer =  (MyLayer*)al;
  //te::map::DataGridOperation* op = layer->getDataGridOperation();

  //if(op)
  //{
  //  const std::set<std::string>& changeds = op->getTheChanged();
  //  te::da::DataSet* dataSet = op->getDataSet();
  //  te::da::DataSetType* dsType = op->getDataSetType();
  //  te::da::PrimaryKey *pk = dsType->getPrimaryKey();
  //  const std::vector<te::dt::Property*>& pkProps = pk->getProperties();
  //  //std::string pkName = pkProps[0]->getName();
  //  //int pkPos = dsType->getPropertyPosition(pkName);
  //  std::string pkv;
  //  int status = -1;
  //  te::color::RGBAColor defaultColor;
  //  te::color::RGBAColor cor;
  //  std::size_t gPos = dsType->getDefaultGeomPropertyPos();
  //  te::gm::GeometryProperty* gProp = dsType->getDefaultGeomProperty();
  //  int gtype = gProp->getGeometryType();
  //  int width = 0, ptMark = 0;

  //  if(gtype == te::gm::PointType || gtype == te::gm::PointZType || gtype == te::gm::PointMType || gtype == te::gm::PointZMType)
  //  {
  //    defaultColor = op->getPointColor();
  //    canvas->setPointColor(defaultColor);
  //    canvas->setPointPattern(op->getPointIcon(), op->getPointIconSize(), op->getPointIconImageType());
  //    canvas->setPointWidth(op->getPointWidth());
  //  }
  //  else if(gtype == te::gm::LineStringType || gtype == te::gm::LineStringZType || gtype == te::gm::LineStringMType || gtype == te::gm::LineStringZMType ||
  //    gtype == te::gm::MultiLineStringType || gtype == te::gm::MultiLineStringZType || gtype == te::gm::MultiLineStringMType || gtype == te::gm::MultiLineStringZMType)
  //  {
  //    defaultColor = op->getLineColor();
  //    canvas->setLinePattern(op->getLinePatternIcon(), op->getLinePatternIconSize(), op->getLinePatternIconImageType());
  //    canvas->setLineWidth(op->getLineWidth());
  //    canvas->setLineColor(op->getLineColor());
  //    //((te::qt::widgets::Canvas*)canvas)->setLineStyle(Qt::SolidLine);
  //  }
  //  else
  //  {
  //    // polygon fill style
  //    defaultColor = op->getPolygonFillColor();
  //    canvas->setPolygonFillColor(defaultColor);
  //    canvas->setPolygonFillPattern(op->getPolygonPatternIcon(), op->getPolygonPatternIconSize(), op->getPolygonPatternIconImageType());
  //    if(op->getPolygonPatternIcon())
  //      canvas->setPolygonPatternWidth(op->getPolygonPatternWidth());

  //    // polygon contour style
  //    canvas->setPolygonContourColor(op->getPolygonContourColor());
  //    //((te::qt::widgets::Canvas*)canvas)->setPolygonContourStyle(Qt::SolidLine);
  //    canvas->setPolygonContourWidth(op->getPolygonContourWidth());
  //    canvas->setPolygonContourPattern(op->getPolygonContourPatternIcon(), op->getPolygonContourPatternIconSize(), op->getPolygonContourPatternIconImageType());
  //  }

  //  // verify grouping (legends)
  //  bool useDouble = false;
  //  double dfrom, dto, dv;
  //  std::string gName;
  //  size_t precision;
  //  std::vector<te::map::LegendItem*> legends;
  //  te::map::Grouping* group = al->getGrouping();
  //  if(group)
  //  {
  //    gName = group->getPropertyName();
  //    precision = group->getPrecision();
  //    int t = dsType->getProperty(gName)->getType();
  //    if(t == te::dt::INT16_TYPE || t == te::dt::UINT16_TYPE || t == te::dt::INT32_TYPE ||
  //      t == te::dt::UINT32_TYPE || t == te::dt::INT64_TYPE || t == te::dt::UINT64_TYPE ||
  //      t == te::dt::FLOAT_TYPE || t == te::dt::DOUBLE_TYPE || t == te::dt::NUMERIC_TYPE)
  //      useDouble = true;

  //    legends = al->getLegend();
  //  }

  //  size_t size = changeds.size();

  //  int w = canvas->getWidth();
  //  int h = canvas->getHeight();
  //  QMatrix matrix = ((te::qt::widgets::Canvas*)canvas)->getMatrix();
  //  QRectF deviceRect(0, 0, w, h);
  //  QRectF worldRect = matrix.inverted().mapRect(deviceRect);

  //  // increase the rectangle to verify geometries of type point. 
  //  double delta = 50.; 
  //  QRectF pointDeviceRect(-delta, -delta, w + 2 * delta, h + 2 * delta);
  //  QRectF pointWorldRect = matrix.inverted().mapRect(pointDeviceRect);

  //  te::gm::Geometry* g;
  //  std::vector<te::gm::Geometry*> geoms, tgeoms;
  //  std::vector<te::color::RGBAColor> colors, tcolors;
  //  dataSet->moveBeforeFirst();
  //  while(dataSet->moveNext())
  //  {
  //    //pkv = dataSet->getAsString(pkPos);
  //    pkv.clear();
  //    for (size_t i = 0; i < pkProps.size(); ++i)
  //      pkv += dataSet->getAsString(pkProps[i]->getName());

  //    if(pkv.empty())
  //      continue;

  //    if(m_useChanged)
  //    {
  //      if(size <= 0)
  //        break;
  //      if(changeds.find(pkv) == changeds.end())
  //        continue;

  //      --size;
  //    }

  //    g = dataSet->getGeometry(gPos);
  //    if(g == 0)
  //      continue;
  //    
  //    g->setSRID(layer->getSRID());
  //    g->transform(srid);
  //    const te::gm::Envelope* env = g->getMBR();
  //    QRectF r(env->m_llx, env->m_lly, env->getWidth(), env->getHeight());

  //    if(env->getWidth() == 0 && env->getHeight() == 0)
  //    {
  //      if(pointWorldRect.contains(env->m_llx, env->m_lly) == false)
  //      {
  //        delete g;
  //        continue;
  //      }
  //    }
  //    else
  //    {
  //      if(r.intersects(worldRect) == false)
  //      {
  //        delete g;
  //        continue;
  //      }
  //    }

  //    status = op->getDataSetSelectionStatus(pkv);
  //    //if(!(status == te::map::DataGridOperation::POINTED || status == te::map::DataGridOperation::QUERIED))
  //    //  cor = op->getDefaultColor();

  //    if(status == te::map::DataGridOperation::DESELECTED)
  //    {
  //      cor = defaultColor;

  //      if(legends.empty() == false)
  //      {
  //        std::string v = dataSet->getAsString(gName, precision);
  //        if(useDouble)
  //        {
  //          QString q = v.c_str();
  //          dv = q.toDouble();
  //        }
  //        std::vector<te::map::LegendItem*>::iterator it;
  //        for(it = legends.begin(); it != legends.end(); ++it)
  //        {
  //          std::string from = (*it)->getLowerLimit();
  //          std::string to = (*it)->getUpperLimit();

  //          if(v.empty() && from == "Null Values")
  //          {
  //            cor = (*it)->getColor();
  //          }
  //          else
  //          {
  //            if(useDouble)
  //            {
  //              QString q = from.c_str();
  //              dfrom = q.toDouble();
  //              q = to.c_str();
  //              dto = q.toDouble();
  //              if(dv >= dfrom && dv < dto)
  //              {
  //                cor = (*it)->getColor();
  //                break;
  //              }
  //            }
  //            else
  //            {
  //              if(v == from)
  //              {
  //                cor = (*it)->getColor();
  //                break;
  //              }
  //            }
  //          }
  //        }
  //      }
  //    }
  //    else if(status == te::map::DataGridOperation::POINTED)
  //      cor = op->getPointedColor();
  //    else if(status == te::map::DataGridOperation::QUERIED)
  //      cor = op->getQueriedColor();
  //    else if(status == te::map::DataGridOperation::POINTED_AND_QUERIED)
  //      cor = op->getPointedAndQueriedColor();

  //    if(m_useChanged == false)
  //    {
  //      draw(canvas, g, cor);
  //      delete g;
  //    }
  //    else
  //    {
  //      if(cor.getAlpha() == 255)
  //      {
  //        geoms.push_back(g);
  //        colors.push_back(cor);
  //      }
  //      else
  //      {
  //        tgeoms.push_back(g);
  //        tcolors.push_back(cor);
  //      }
  //    }
  //  }
  //  
  //  if(m_useChanged)
  //  {
  //    std::vector<te::gm::Geometry*>::iterator git;
  //    std::vector<te::color::RGBAColor>::iterator cit;
  //    
  //    // erase transparent geometries
  //    ((te::qt::widgets::Canvas*)(canvas))->setEraseMode();
  //    for(git = tgeoms.begin(), cit = tcolors.begin(); git != tgeoms.end(); ++git, ++cit)
  //    {
  //      g = *git;
  //      cor = *cit;
  //      draw(canvas, g, cor);
  //    }
  //    ((te::qt::widgets::Canvas*)(canvas))->setNormalMode();

  //    // draw opaque geometries
  //    for(git = geoms.begin(), cit = colors.begin(); git != geoms.end(); ++git, ++cit)
  //    {
  //      g = *git;
  //      cor = *cit;
  //      draw(canvas, g, cor);
  //      delete g;
  //    }

  //    // draw transparent geometries
  //    for(git = tgeoms.begin(), cit = tcolors.begin(); git != tgeoms.end(); ++git, ++cit)
  //    {
  //      g = *git;
  //      cor = *cit;
  //      draw(canvas, g, cor);
  //      delete g;
  //    }
  //  }
  //}
  //else
  //{
  //  //te::map::LayerRenderer::draw(al, canvas, e, srid);
  //  std::string name = layer->getId();
  //  te::da::DataSource* ds = layer->getDataSource();
  //  te::da::DataSourceTransactor* t = ds->getTransactor();
  //  te::da::DataSet* dataSet = t->getDataSet(name);
  //  //te::da::DataSourceCatalogLoader* loader = t->getCatalogLoader();
  //  //te::da::DataSetType* dsType = loader->getDataSetType(name, true);
  //  te::da::DataSetTypePtr dsType = ds->getCatalog()->getDataSetType(name);
  //  te::gm::GeometryProperty* gProp = dsType->getDefaultGeomProperty();
  //  int gtype = gProp->getGeometryType();
  //  std::size_t gPos = dsType->getDefaultGeomPropertyPos();

  //  if(gtype == te::gm::PointType || gtype == te::gm::PointZType || gtype == te::gm::PointMType || gtype == te::gm::PointZMType)
  //  {
  //    canvas->setPointColor(te::color::RGBAColor(255, 0, 0, 255));
  //    canvas->setPointPattern(0, 0, 0);
  //    canvas->setPointWidth(2);
  //  }
  //  else if(gtype == te::gm::LineStringType || gtype == te::gm::LineStringZType || gtype == te::gm::LineStringMType || gtype == te::gm::LineStringZMType ||
  //    gtype == te::gm::MultiLineStringType || gtype == te::gm::MultiLineStringZType || gtype == te::gm::MultiLineStringMType || gtype == te::gm::MultiLineStringZMType)
  //  {
  //    canvas->setLinePattern(0, 0, 0);
  //    canvas->setLineWidth(1);
  //    canvas->setLineColor(te::color::RGBAColor(0, 0, 255, 255));
  //    //((te::qt::widgets::Canvas*)canvas)->setLineStyle(Qt::SolidLine);
  //  }
  //  else
  //  {
  //    // polygon fill style
  //    canvas->setPolygonFillColor(te::color::RGBAColor(0, 255, 0, 255));
  //    canvas->setPolygonFillPattern(0, 0, 0);

  //    // polygon contour style
  //    canvas->setPolygonContourColor(te::color::RGBAColor(0, 0, 0, 255));
  //    canvas->setPolygonContourWidth(1);
  //    canvas->setPolygonContourPattern(0, 0, 0);
  //  }
  //  dataSet->moveBeforeFirst();
  //  while(dataSet->moveNext())
  //  {
  //    te::gm::Geometry* g = dataSet->getGeometry(gPos);
  //    if(g == 0)
  //      continue;
  //    
  //    if(g->getSRID() <= 0)
  //      g->setSRID(layer->getSRID());
  //    g->transform(srid);

  //    const te::gm::Envelope* env = g->getMBR();
  //    QRectF r(env->m_llx, env->m_lly, env->getWidth(), env->getHeight());

  //    int w = canvas->getWidth();
  //    int h = canvas->getHeight();
  //    QMatrix matrix = ((te::qt::widgets::Canvas*)canvas)->getMatrix();
  //    QRectF deviceRect(0, 0, w, h);
  //    QRectF worldRect = matrix.inverted().mapRect(deviceRect);

  //    // increase the rectangle to verify geometries of type point. 
  //    double delta = 50.; 
  //    QRectF pointDeviceRect(-delta, -delta, w + 2 * delta, h + 2 * delta);
  //    QRectF pointWorldRect = matrix.inverted().mapRect(pointDeviceRect);

  //    if(env->getWidth() == 0 && env->getHeight() == 0)
  //    {
  //      if(pointWorldRect.contains(env->m_llx, env->m_lly) == false)
  //      {
  //        delete g;
  //        continue;
  //      }
  //    }
  //    else
  //    {
  //      if(r.intersects(worldRect) == false)
  //      {
  //        delete g;
  //        continue;
  //      }
  //    }

  //    canvas->draw(g);
  //      delete g;
  //  }
  //  delete dataSet;
  //  delete t;
  //}
//}

void MyLayerRenderer::draw(te::map::AbstractLayer* al, te::map::Canvas* canvas,
     const te::gm::Envelope& e, int srid)
{
  m_al = al;
  m_canvas = canvas;
  m_e = e;
  m_srid = srid;
  start();
}

void MyLayerRenderer::run()
//void MyLayerRenderer::draw(te::map::AbstractLayer* al, te::map::Canvas* canvas,
//     const te::gm::Envelope& e, int srid)
{
  m_abort = false;
  te::map::AbstractLayer* al = m_al;
  te::map::Canvas* canvas = m_canvas;
  const te::gm::Envelope& e = m_e;
  int srid = m_srid;

  if(m_useChanged == false)
    //will draw all geometries
    canvas->clear();

  MyLayer* layer =  (MyLayer*)al;
  te::map::DataGridOperation* op = layer->getDataGridOperation();

  if(op)
  {
    bool hasZoom = false;
    const te::gm::Envelope* layerEnvelope = layer->getExtent();
    te::gm::Envelope env = e;
    if(transform(env, srid, layer->getSRID()) == false)
      return;

    te::gm::Envelope* interEnv = env.intersection(*layerEnvelope);
    if(layerEnvelope->getArea() / interEnv->getArea() >= 4)
      hasZoom = true;

    te::da::DataSet* dataSet = op->getDataSet();
    te::da::DataSetType* dsType = op->getDataSetType();
    te::da::PrimaryKey *pk = dsType->getPrimaryKey();
    const std::vector<te::dt::Property*>& pkProps = pk->getProperties();
    std::string pkv;
    int status = -1;
    te::color::RGBAColor defaultColor;
    te::color::RGBAColor cor;
    std::size_t gPos = dsType->getDefaultGeomPropertyPos();
    te::gm::GeometryProperty* gProp = dsType->getDefaultGeomProperty();
    int gtype = gProp->getGeometryType();

    if(gtype == te::gm::PointType || gtype == te::gm::PointZType || gtype == te::gm::PointMType || gtype == te::gm::PointZMType)
    {
      defaultColor = op->getPointColor();
      canvas->setPointColor(defaultColor);
      canvas->setPointPattern(op->getPointIcon(), op->getPointIconSize(), op->getPointIconImageType());
      canvas->setPointWidth(op->getPointWidth());
    }
    else if(gtype == te::gm::LineStringType || gtype == te::gm::LineStringZType || gtype == te::gm::LineStringMType || gtype == te::gm::LineStringZMType ||
      gtype == te::gm::MultiLineStringType || gtype == te::gm::MultiLineStringZType || gtype == te::gm::MultiLineStringMType || gtype == te::gm::MultiLineStringZMType)
    {
      defaultColor = op->getLineColor();
      canvas->setLinePattern(op->getLinePatternIcon(), op->getLinePatternIconSize(), op->getLinePatternIconImageType());
      canvas->setLineWidth(op->getLineWidth());
      canvas->setLineColor(op->getLineColor());
      //((te::qt::widgets::Canvas*)canvas)->setLineStyle(Qt::SolidLine);
    }
    else
    {
      // polygon fill style
      defaultColor = op->getPolygonFillColor();
      canvas->setPolygonFillColor(defaultColor);
      canvas->setPolygonFillPattern(op->getPolygonPatternIcon(), op->getPolygonPatternIconSize(), op->getPolygonPatternIconImageType());
      if(op->getPolygonPatternIcon())
        canvas->setPolygonPatternWidth(op->getPolygonPatternWidth());

      // polygon contour style
      canvas->setPolygonContourColor(op->getPolygonContourColor());
      //((te::qt::widgets::Canvas*)canvas)->setPolygonContourStyle(Qt::SolidLine);
      canvas->setPolygonContourWidth(op->getPolygonContourWidth());
      canvas->setPolygonContourPattern(op->getPolygonContourPatternIcon(), op->getPolygonContourPatternIconSize(), op->getPolygonContourPatternIconImageType());
    }

    // verify grouping (legends)
    bool useDouble = false;
    std::string gName;
    size_t precision;
    std::vector<te::map::LegendItem*> legends;
    te::map::Grouping* group = al->getGrouping();
    if(group)
    {
      gName = group->getPropertyName();
      precision = group->getPrecision();
      int t = dsType->getProperty(gName)->getType();
      if(t == te::dt::INT16_TYPE || t == te::dt::UINT16_TYPE || t == te::dt::INT32_TYPE ||
        t == te::dt::UINT32_TYPE || t == te::dt::INT64_TYPE || t == te::dt::UINT64_TYPE ||
        t == te::dt::FLOAT_TYPE || t == te::dt::DOUBLE_TYPE || t == te::dt::NUMERIC_TYPE)
        useDouble = true;

      legends = al->getLegend();
    }

    //int w = canvas->getWidth();
    //int h = canvas->getHeight();
    //QMatrix matrix = ((te::qt::widgets::Canvas*)canvas)->getMatrix();
    //QRectF deviceRect(0, 0, w, h);
    //QRectF worldRect = matrix.inverted().mapRect(deviceRect);
    QRectF worldRect(e.getLowerLeftX(), e.getLowerLeftY(), e.getWidth(), e.getHeight());

    te::gm::Geometry* g;
    std::vector<te::gm::Geometry*> geoms, tgeoms;
    std::vector<te::color::RGBAColor> colors, tcolors;

    if(m_useChanged == false)
    {
      // canvas was clear, draw all geometries
      te::da::DataSourceTransactor* transactor = 0;
      if(hasZoom)
      {
        transactor = layer->getDataSource()->getTransactor();
        dataSet = transactor->getDataSet(layer->getId(), interEnv, te::gm::INTERSECTS);
      } 

      dataSet->moveBeforeFirst();
      while(m_abort == false && dataSet->moveNext())
      {
        pkv.clear();
        for (size_t i = 0; i < pkProps.size(); ++i)
          pkv += dataSet->getAsString(pkProps[i]->getName());

        if(pkv.empty())
          continue;

        g = dataSet->getGeometry(gPos);
        if(g == 0)
          continue;
      
        g->setSRID(layer->getSRID());
        g->transform(srid);
        const te::gm::Envelope* env = g->getMBR();
        QRectF r(env->m_llx, env->m_lly, env->getWidth(), env->getHeight());

        if((r.isValid() && r.intersects(worldRect)) || (worldRect.contains(r.x(), r.y())))
        {
          status = op->getDataSetSelectionStatus(pkv);

          if(status == te::map::DataGridOperation::DESELECTED)
          {
            cor = defaultColor;
            if(legends.empty() == false)
            {
              std::string gValue = dataSet->getAsString(gName, precision);
              cor = getLegendColor(legends, gValue, useDouble);
            }
          }
          else if(status == te::map::DataGridOperation::POINTED)
            cor = op->getPointedColor();
          else if(status == te::map::DataGridOperation::QUERIED)
            cor = op->getQueriedColor();
          else if(status == te::map::DataGridOperation::POINTED_AND_QUERIED)
            cor = op->getPointedAndQueriedColor();

          draw(canvas, g, cor);
        }
        delete g;
      }
      delete interEnv;
      if(hasZoom)
      {
        delete dataSet;
        delete transactor;
      }
    }
    else
    {
      // draw only changeds. 
      const std::set<std::string>& changeds = op->getTheChanged();
      std::set<std::string>::const_iterator cit;
      std::multimap<int, int> mm;
      std::map<int, te::color::RGBAColor> colorMap;
      size_t logRow;
      //size_t size = changeds.size();
      for(cit = changeds.begin(); m_abort == false && cit != changeds.end(); ++cit)
      {
        pkv = *cit;
        status = op->getDataSetSelectionStatus(pkv);
        logRow = op->getLogicalRow(pkv);
        mm.insert(std::pair<int, int>(status, logRow));

        if(status == te::map::DataGridOperation::DESELECTED)
        {
          cor = defaultColor;
          if(legends.empty() == false)
          {
            std::string gValue = dataSet->getAsString(gName, precision);
            cor = getLegendColor(legends, gValue, useDouble);
          }
        }
        else if(status == te::map::DataGridOperation::POINTED)
          cor = op->getPointedColor();
        else if(status == te::map::DataGridOperation::QUERIED)
          cor = op->getQueriedColor();
        else if(status == te::map::DataGridOperation::POINTED_AND_QUERIED)
          cor = op->getPointedAndQueriedColor();
        
        colorMap.insert(std::pair<int, te::color::RGBAColor>(logRow, cor));
      }

      // erase transparent geometries
      ((te::qt::widgets::Canvas*)(canvas))->setEraseMode();
      std::map<int, te::color::RGBAColor>::iterator corit;
      for(corit = colorMap.begin(); m_abort == false &&  corit != colorMap.end(); ++corit)
      {
        logRow = corit->first;
        cor = corit->second;
        if(cor.getAlpha() < 255)
        {
          dataSet->move(logRow);
          g = dataSet->getGeometry(gPos);
          if(g == 0)
            continue;
      
          g->setSRID(layer->getSRID());
          g->transform(srid);
          const te::gm::Envelope* env = g->getMBR();
          QRectF r(env->m_llx, env->m_lly, env->getWidth(), env->getHeight());

          if((r.isValid() && r.intersects(worldRect)) || (worldRect.contains(r.x(), r.y())))
            draw(canvas, g, cor);
          delete g;
        }
      }

      // draw geometries. Start by not selecteds
      ((te::qt::widgets::Canvas*)(canvas))->setNormalMode();
      std::multimap<int, int>::iterator mit;
      for(mit = mm.begin(); m_abort == false &&  mit != mm.end(); ++mit)
      {
        logRow = mit->second;
        cor = colorMap[logRow];
        dataSet->move(logRow);
        g = dataSet->getGeometry(gPos);
        if(g == 0)
          continue;
      
        g->setSRID(layer->getSRID());
        g->transform(srid);
        const te::gm::Envelope* env = g->getMBR();
        QRectF r(env->m_llx, env->m_lly, env->getWidth(), env->getHeight());

        if((r.isValid() && r.intersects(worldRect)) || (worldRect.contains(r.x(), r.y())))
          draw(canvas, g, cor);
        delete g;
      }
    }
  }
  else
  {
    // have not grid operation
    //te::map::LayerRenderer::draw(al, canvas, e, srid);
    std::string name = layer->getId();
    te::da::DataSource* ds = layer->getDataSource();
    te::da::DataSourceTransactor* t = ds->getTransactor();
    te::da::DataSet* dataSet = t->getDataSet(name);
    //te::da::DataSourceCatalogLoader* loader = t->getCatalogLoader();
    //te::da::DataSetType* dsType = loader->getDataSetType(name, true);
    te::da::DataSetTypePtr dsType = ds->getCatalog()->getDataSetType(name);
    te::gm::GeometryProperty* gProp = dsType->getDefaultGeomProperty();
    int gtype = gProp->getGeometryType();
    std::size_t gPos = dsType->getDefaultGeomPropertyPos();

    if(gtype == te::gm::PointType || gtype == te::gm::PointZType || gtype == te::gm::PointMType || gtype == te::gm::PointZMType)
    {
      canvas->setPointColor(te::color::RGBAColor(255, 0, 0, 255));
      canvas->setPointPattern(0, 0, 0);
      canvas->setPointWidth(2);
    }
    else if(gtype == te::gm::LineStringType || gtype == te::gm::LineStringZType || gtype == te::gm::LineStringMType || gtype == te::gm::LineStringZMType ||
      gtype == te::gm::MultiLineStringType || gtype == te::gm::MultiLineStringZType || gtype == te::gm::MultiLineStringMType || gtype == te::gm::MultiLineStringZMType)
    {
      canvas->setLinePattern(0, 0, 0);
      canvas->setLineWidth(1);
      canvas->setLineColor(te::color::RGBAColor(0, 0, 255, 255));
      //((te::qt::widgets::Canvas*)canvas)->setLineStyle(Qt::SolidLine);
    }
    else
    {
      // polygon fill style
      canvas->setPolygonFillColor(te::color::RGBAColor(0, 255, 0, 255));
      canvas->setPolygonFillPattern(0, 0, 0);

      // polygon contour style
      canvas->setPolygonContourColor(te::color::RGBAColor(0, 0, 0, 255));
      canvas->setPolygonContourWidth(1);
      canvas->setPolygonContourPattern(0, 0, 0);
    }
    dataSet->moveBeforeFirst();
    while(m_abort == false && dataSet->moveNext())
    {
      te::gm::Geometry* g = dataSet->getGeometry(gPos);
      if(g == 0)
        continue;
      
      if(g->getSRID() <= 0)
        g->setSRID(layer->getSRID());
      g->transform(srid);

      const te::gm::Envelope* env = g->getMBR();
      QRectF r(env->m_llx, env->m_lly, env->getWidth(), env->getHeight());

      int w = canvas->getWidth();
      int h = canvas->getHeight();
      QMatrix matrix = ((te::qt::widgets::Canvas*)canvas)->getMatrix();
      QRectF deviceRect(0, 0, w, h);
      QRectF worldRect = matrix.inverted().mapRect(deviceRect);

      if((r.isValid() && r.intersects(worldRect)) || (worldRect.contains(r.x(), r.y())))
        canvas->draw(g);
      delete g;
    }
    delete dataSet;
    delete t;
  }
}

void MyLayerRenderer::abort()
{
  m_abort = true;
}

te::color::RGBAColor MyLayerRenderer::getLegendColor(const std::vector<te::map::LegendItem*>& legends, const std::string& gValue, bool useDouble)
{ 
  te::color::RGBAColor cor;
  double dv, dfrom, dto;

  if(legends.empty() == false)
  {
    if(useDouble)
    {
      QString q = gValue.c_str();
      dv = q.toDouble();
    }
    std::vector<te::map::LegendItem*>::const_iterator cit;
    for(cit = legends.begin(); cit != legends.end(); ++cit)
    {
      std::string from = (*cit)->getLowerLimit();
      std::string to = (*cit)->getUpperLimit();

      if(gValue.empty() && from == "Null Values")
      {
        cor = (*cit)->getColor();
      }
      else
      {
        if(useDouble)
        {
          QString q = from.c_str();
          dfrom = q.toDouble();
          q = to.c_str();
          dto = q.toDouble();
          if(dv >= dfrom && dv < dto)
          {
            cor = (*cit)->getColor();
            break;
          }
        }
        else
        {
          if(gValue == from)
          {
            cor = (*cit)->getColor();
            break;
          }
        }
      }
    }
  }
  return cor;
}

void MyLayerRenderer::draw(te::map::Canvas* canvas, const te::gm::Geometry* g, const te::color::RGBAColor& cor)
{
  int gtype = g->getGeomTypeId();
  switch(gtype)
  {
    case te::gm::MultiPolygonType:
    case te::gm::PolygonType:
    {
      canvas->setPolygonFillColor(cor);
    }
    break;
    
    case te::gm::MultiLineStringType:
    case te::gm::LineStringType:
    {
      canvas->setLineColor(cor);
    }
    break;
  
    default:
      canvas->setPointColor(cor);
  }
  canvas->draw(g);
}

bool MyLayerRenderer::transform(te::gm::Envelope& e, int oldsrid, int newsrid)
{
  if(oldsrid == newsrid)
    return true;

  try
  {
    double x1, y1, x2, y2, cx, cy, dx, dy;
  
    std::auto_ptr<te::srs::Converter> converter(new te::srs::Converter());

    converter->setSourceSRID(oldsrid);
    converter->setTargetSRID(newsrid);

    cx = e.getLowerLeftX() + e.getWidth() / 2.;
    cy = e.getLowerLeftY() + e.getHeight() / 2.;
    converter->convert(cx, cy);

    x1 = e.getLowerLeftX();
    y1 = e.getLowerLeftY();
    converter->convert(x1, y1);

    x2 = e.getUpperRightX();
    y2 = e.getUpperRightY();
    converter->convert(x2, y2);
    if(std::numeric_limits<double>::has_infinity)
    {
      if(x1 == std::numeric_limits<double>::infinity() || y1 == std::numeric_limits<double>::infinity() ||
         x2 == std::numeric_limits<double>::infinity() || y2 == std::numeric_limits<double>::infinity())
      {
        if(cx == std::numeric_limits<double>::infinity() || cy == std::numeric_limits<double>::infinity())
          return false;
        else
        {
          x1 = y1 = -20000000;
          x2 = y2 = 20000000;
        }
      }
    }

    dx = fabs(x2 - x1) / 2.;
    dy = fabs(y2 - y1) / 2.;

    x1 = cx - dx;
    x2 = cx + dx;
    y1 = cy - dy;
    y2 = cy + dy;

    e.init(x1, y1, x2, y2);
    if(e.getWidth() == 0. || e.getHeight() == 0.)
      return false;
    return true;
  }
  catch(std::exception&)
  {
    return false;
  }
}

void MyLayerRenderer::setDisplay(MyDisplay* display)
{
  m_display = display;
}

MyDisplay* MyLayerRenderer::getDisplay()
{
  return m_display;
}

te::map::Canvas* MyLayerRenderer::getCanvas()
{
  return m_canvas;
}
