/*  Copyright (C) 2008-2013 National Institute For Space Research (INPE) - Brazil.

    This file is part of the TerraLib - a Framework for building GIS enabled applications.

    TerraLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License,
    or (at your option) any later version.

    TerraLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with TerraLib. See COPYING. If not, write to
    TerraLib Team at <terralib-team@terralib.org>.
 */

/*!
  \file terralib/qt/plugins/rp/Plugin.cpp

  \brief Plugin implementation for the RP Qt Plugin widget.
*/

// TerraLib
#include "../../../common/Config.h"
#include "../../../common/Translator.h"
#include "../../../common/Logger.h"
#include "../../af/ApplicationController.h"
#include "../../af/events/LayerEvents.h"
#include "Plugin.h"

#ifdef TE_QT_PLUGIN_RP_HAVE_CLASSIFIER
  #include "ClassifierAction.h"
#endif

#ifdef TE_QT_PLUGIN_RP_HAVE_CONTRAST
  #include "ContrastAction.h"
#endif

#ifdef TE_QT_PLUGIN_RP_HAVE_MIXTUREMODEL
  #include "MixtureModelAction.h"
#endif

#ifdef TE_QT_PLUGIN_RP_HAVE_SEGMENTER
  #include "SegmenterAction.h"
#endif

#ifdef TE_QT_PLUGIN_RP_HAVE_REGISTER
  #include "RegisterAction.h"
#endif

// QT
#include <QtGui/QMenu>
#include <QtGui/QMenuBar>

te::qt::plugins::rp::Plugin::Plugin(const te::plugin::PluginInfo& pluginInfo)
  : te::plugin::Plugin(pluginInfo), m_rpMenu(0)
{
}

te::qt::plugins::rp::Plugin::~Plugin() 
{
}

void te::qt::plugins::rp::Plugin::startup()
{
  if(m_initialized)
    return;

// it initializes the Translator support for the TerraLib RP Qt Plugin
  TE_ADD_TEXT_DOMAIN(TE_QT_PLUGIN_RP_TEXT_DOMAIN, TE_QT_PLUGIN_RP_TEXT_DOMAIN_DIR, "UTF-8");

  TE_LOG_TRACE(TE_QT_PLUGIN_RP("TerraLib Qt RP Plugin startup!"));

// add plugin menu
  m_rpMenu = te::qt::af::ApplicationController::getInstance().getMenu("RP");

  m_rpMenu->setTitle(TE_QT_PLUGIN_RP("Raster Processing"));

// add pop up menu
  m_popupAction = new QAction(m_rpMenu);
  m_popupAction->setText(TE_QT_PLUGIN_RP("Raster Processing"));

  //add to application layer tree pop up menu
  //te::qt::af::evt::LayerPopUpAddAction evt(m_popupAction, "RASTER_LAYER_ITEM", 2 /*UNIQUE_ITEM_SELECTED*/);
  //te::qt::af::ApplicationController::getInstance().broadcast(&evt);

  m_rpPopupMenu = new QMenu(m_rpMenu);
  m_popupAction->setMenu(m_rpPopupMenu);

// register actions
  registerActions();

  m_initialized = true;
}

void te::qt::plugins::rp::Plugin::shutdown()
{
  if(!m_initialized)
    return;

//remove from application layer tree pop up menu
  //te::qt::af::evt::LayerPopUpRemoveAction evt(m_popupAction);
  //te::qt::af::ApplicationController::getInstance().broadcast(&evt);

// remove menu
  delete m_rpMenu;

// unregister actions
  unRegisterActions();

  TE_LOG_TRACE(TE_QT_PLUGIN_RP("TerraLib Qt RP Plugin shutdown!"));

  m_initialized = false;
}

void te::qt::plugins::rp::Plugin::registerActions()
{
#ifdef TE_QT_PLUGIN_RP_HAVE_CLASSIFIER
    m_classifier = new te::qt::plugins::rp::ClassifierAction(m_rpMenu, m_rpPopupMenu);
#endif

#ifdef TE_QT_PLUGIN_RP_HAVE_CONTRAST
    m_contrast = new te::qt::plugins::rp::ContrastAction(m_rpMenu, m_rpPopupMenu);
#endif

#ifdef TE_QT_PLUGIN_RP_HAVE_MIXTUREMODEL
  m_mixtureModel = new te::qt::plugins::rp::MixtureModelAction(m_rpMenu, m_rpPopupMenu);
#endif

#ifdef TE_QT_PLUGIN_RP_HAVE_SEGMENTER
    m_segmenter = new te::qt::plugins::rp::SegmenterAction(m_rpMenu, m_rpPopupMenu);
#endif

#ifdef TE_QT_PLUGIN_RP_HAVE_REGISTER
  m_register = new te::qt::plugins::rp::RegisterAction(m_rpMenu, m_rpPopupMenu);
#endif
}

void  te::qt::plugins::rp::Plugin::unRegisterActions()
{
#ifdef TE_QT_PLUGIN_RP_HAVE_CLASSIFIER
    delete m_classifier;
#endif

#ifdef TE_QT_PLUGIN_RP_HAVE_CONTRAST
    delete m_contrast;
#endif

#ifdef TE_QT_PLUGIN_RP_HAVE_CONTRAST
    delete m_mixtureModel;
#endif

#ifdef TE_QT_PLUGIN_RP_HAVE_SEGMENTER
    delete m_segmenter;
#endif

#ifdef TE_QT_PLUGIN_RP_HAVE_REGISTER
  delete m_register;
#endif
}

PLUGIN_CALL_BACK_IMPL(te::qt::plugins::rp::Plugin)
