/*  Copyright (C) 2001-2009 National Institute For Space Research (INPE) - Brazil.

    This file is part of the TerraLib - a Framework for building GIS enabled applications.

    TerraLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License,
    or (at your option) any later version.

    TerraLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with TerraLib. See COPYING. If not, write to
    TerraLib Team at <terralib-team@terralib.org>.
 */

/*!
  \file terralib/se/SymbologyManager.cpp
 
  \brief The SymbologyManager is a singleton that can be used to manage all loaded symbols in TerraLib.
*/

// TerraLib
#include "Symbolizer.h"
#include "SymbologyManager.h"

void te::se::SymbologyManager::clear()
{
  std::map<std::string, Symbolizer*>::const_iterator it = m_catalogIdxByName.begin();
  std::map<std::string, Symbolizer*>::const_iterator itend = m_catalogIdxByName.end();

  while(it != itend)
  {
    delete it->second;
    ++it;
  }

  m_catalogIdxByName.clear();
}

te::se::SymbologyManager::~SymbologyManager()
{
}

te::se::SymbologyManager::SymbologyManager()
{
}

