/*  Copyright (C) 2008-2013 National Institute For Space Research (INPE) - Brazil.

    This file is part of the TerraLib - a Framework for building GIS enabled applications.

    TerraLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License,
    or (at your option) any later version.

    TerraLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with TerraLib. See COPYING. If not, write to
    TerraLib Team at <terralib-team@terralib.org>.
 */

/*!
  \file terralib/dataaccess/dataset_h.h

  \brief This file contains include headers for the DataSet module.
 */

#ifndef __TERRALIB_DATAACCESS_INTERNAL_DATASET_H_H
#define __TERRALIB_DATAACCESS_INTERNAL_DATASET_H_H

// TerraLib
#include "dataset/CheckConstraint.h"
#include "dataset/Constraint.h"
#include "dataset/DataSet.h"
#include "dataset/DataSetAdapter.h"
//#include "dataset/DataSetPersistence.h"
#include "dataset/DataSetType.h"
#include "dataset/DataSetTypeConverter.h"
//#include "dataset/DataSetTypePersistence.h"
#include "dataset/ForeignKey.h"
#include "dataset/Index.h"
#include "dataset/ObjectId.h"
#include "dataset/ObjectIdSet.h"
#include "dataset/PrimaryKey.h"
#include "dataset/Sequence.h"
#include "dataset/UniqueKey.h"

#endif  // __TERRALIB_DATAACCESS_INTERNAL_DATASET_H_H

