/*  Copyright (C) 2001-2009 National Institute For Space Research (INPE) - Brazil.

    This file is part of the TerraLib - a Framework for building GIS enabled applications.

    TerraLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License,
    or (at your option) any later version.

    TerraLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with TerraLib. See COPYING. If not, write to
    TerraLib Team at <terralib-team@terralib.org>.
 */

/*!
  \file af.h

  \brief This file contains include headers for the TerraLib Qt Application Framework.
 */

#ifndef __TERRALIB_QT_INTERNAL_AF_H
#define __TERRALIB_QT_INTERNAL_AF_H

/*!
  \defgroup af Application Framework

  \ingroup qt

  \brief This module provides a framework to help customizing an application built on top of TerraLib's Qt Components

    The namespace associated to the Qt Application Framework module is te::qt::af. To know more about it, see the te::qt::af namespace documentation.
*/
namespace te
{
  namespace qt
  {
    /*!
      \brief Namespace for the Qt Application Framework module of TerraLib.
    */
    namespace af
    {
    }
  } // end namespace qt
}   // end namespace te

#endif  // __TERRALIB_QT_INTERNAL_AF_H

