/*  Copyright (C) 2001-2009 National Institute For Space Research (INPE) - Brazil.

    This file is part of the TerraLib - a Framework for building GIS enabled applications.

    TerraLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License,
    or (at your option) any later version.

    TerraLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with TerraLib. See COPYING. If not, write to
    TerraLib Team at <terralib-team@terralib.org>.
 */

/*!
  \file terralib/rp.h

  \brief This file contains include headers for the TerraLib Raster Processing module.
*/

#ifndef __TERRALIB_INTERNAL_RP_H
#define __TERRALIB_INTERNAL_RP_H

// TerraLib
#include "rp/Algorithm.h"
#include "rp/Config.h"
#include "rp/Contrast.h"
#include "rp/Exception.h"
#include "rp/Module.h"
#include "rp/RasterHandler.h"

/*!
  \defgroup rp Raster Processing

  \brief This module provides classes and functions with raster processing capabilities.

    Basically, the TerraLib Raster Processing module contains several processing operations applied to an image.
    The main classes/concepts in this module are listed here. The namespace associated to the Raster Processing module is te::rp.
    To know more about it, see the te::rp namespace documentation.
*/

namespace te
{
  /*!
    \brief Namespace for Raster Processing module of TerraLib.
  */
  namespace rp
  {
  } // end namespace rp
}   // end namespace te

#endif  // __TERRALIB_INTERNAL_RP_H
