/*  Copyright (C) 2001-2009 National Institute For Space Research (INPE) - Brazil.

    This file is part of the TerraLib - a Framework for building GIS enabled applications.

    TerraLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License,
    or (at your option) any later version.

    TerraLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with TerraLib. See COPYING. If not, write to
    TerraLib Team at <terralib-team@terralib.org>.
 */

/*!
  \file rtree.h
  
  \brief This file contains include headers for the Rtree Spatial Access Method.
 */
#ifndef __TERRALIB_SAM_INTERNAL_RTREE_H
#define __TERRALIB_SAM_INTERNAL_RTREE_H

// TerraLib
#include "rtree/Branch.h"
#include "rtree/Index.h"
#include "rtree/Node.h"
#include "rtree/PartitionVars.h"

namespace te
{
  namespace sam
  {
    /*!
	    \brief This is the namespace for the R-tree Spatial Access Method.
    
      \note See namespace te comments for any detail on using namespaces.
     */
    namespace rtree
    {
    } // end namespace rtree
  }   // end namespace sam
}     // end namespace te

#endif  // __TERRALIB_SAM_INTERNAL_RTREE_H

