/*  Copyright (C) 2001-2009 National Institute For Space Research (INPE) - Brazil.

    This file is part of the TerraLib - a Framework for building GIS enabled applications.

    TerraLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License,
    or (at your option) any later version.

    TerraLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with TerraLib. See COPYING. If not, write to
    TerraLib Team at <terralib-team@terralib.org>.
 */

/*!
  \file se_fw.h
   
  \brief Forward declarations for the Symbology Encoding module.
 */

#ifndef __TERRALIB_FW_INTERNAL_SE_FW_H
#define __TERRALIB_FW_INTERNAL_SE_FW_H

// Forward declarations
namespace te
{
  namespace se
  {
    class AnchorPoint;
    class Categorize;
    class ChangeCase;
    class ChannelSelection;
    class ColorMap;
    class Concatenate;
    class ContrastEnhancement;
    class CoverageStyle;
    class Description;
    class Displacement;
    class ExternalGraphic;
    class FeatureTypeStyle;
    class Fill;
    class FillBasicColor;
    class Font;
    class FormatDate;
    class FormatNumber;
    class Function;
    class Graphic;
    class GraphicStroke;
    class Halo;
    class ImageOutline;
    class InlineContent;
    class Interpolate;
    class InterpolationPoint;
    class LabelPlacement;
    class LinePlacement;
    class LineSymbolizer;
    class MapItem;
    class Mark;
    class ParameterValue;
    class PointPlacement;
    class PointSymbolizer;
    class PolygonSymbolizer;
    class RasterSymbolizer;
    class Recode;
    class Rule;
    class SelectedChannel;
    class ShadedRelief;
    class StringLength;
    class StringPosition;
    class Stroke;
    class StrokeBasicColor;
    class Style;
    class Substring;
    class SvgParameter;
    class Symbolizer;
    class TextSymbolizer;
    class Trim;
  }
}

#endif // __TERRALIB_FW_INTERNAL_SE_FW_H
