/*  Copyright (C) 2001-2009 National Institute For Space Research (INPE) - Brazil.

    This file is part of the TerraLib - a Framework for building GIS enabled applications.

    TerraLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License,
    or (at your option) any later version.

    TerraLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with TerraLib. See COPYING. If not, write to
    TerraLib Team at <terralib-team@terralib.org>.
 */

/*!
  \file terralib/vp.h

  \brief This file contains include headers for the TerraLib Vector Processing module.
*/

#ifndef __TERRALIB_INTERNAL_VP_H
#define __TERRALIB_INTERNAL_VP_H

/*!
  \defgroup vp Vector Processing

  \brief This module provides classes and functions with vector processing capabilities.

    Basically, the TerraLib Vector Processing module contains several processing operations applied to vectorial data and it is organized as follows:

    <ul>
      <li>Aggregation Geographical Operation</li>
      <li>Buffer Geographical Operation</li>
      <li>Intersection Geographical Operation</li>
    </ul>

  The main classes/concepts in this module are listed here. The namespace associated to the Vector Processing module is te::vp.
  To know more about it, see the te::vp namespace documentation.
*/

namespace te
{
  /*!
    \brief Namespace for Vector Processing module of TerraLib.
  */
  namespace vp
  {
  } // end namespace vp
}   // end namespace te

#endif  // __TERRALIB_INTERNAL_VP_H
