/*  Copyright (C) 2001-2009 National Institute For Space Research (INPE) - Brazil.

    This file is part of the TerraLib - a Framework for building GIS enabled applications.

    TerraLib is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License,
    or (at your option) any later version.

    TerraLib is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with TerraLib. See COPYING. If not, write to
    TerraLib Team at <terralib-team@terralib.org>.
 */

/*!
  \file xerces.h

  \brief This file contains include headers for TerraLib Xerces module.
 */

#ifndef __TERRALIB_INTERNAL_XERCES_H
#define __TERRALIB_INTERNAL_XERCES_H

// TerraLib
#include "xml/Config.h"
#include "xml/ErrorHandler.h"
#include "xml/Platform.h"
#include "xml/Reader.h"
#include "xml/ReaderFactory.h"
#include "xml/ReaderHandler.h"
#include "xml/StrToXMLCh.h"
#include "xml/XMLChToStr.h"

namespace te
{
  /*!
    \brief Namespace for TerraLib Xerces module.

    This is the namespace for the TerraLib XML support built on top of Xerces-C++.
   */
  namespace xerces
  {
  }	// end namespace xerces
}   // end namespace te

#endif  // __TERRALIB_INTERNAL_XERCES_H

